/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.property;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.PossibleTypesService;
import org.eclipse.sapphire.Type;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.junit.Test;

public final class ListPropertyTests
extends SapphireTestCase {
    @Test
    public void OrderedPossibleTypes() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (OrderedPossibleTypesTestElement a = (OrderedPossibleTypesTestElement)OrderedPossibleTypesTestElement.TYPE.instantiate();){
            PossibleTypesService unorderedPossibleTypesService = (PossibleTypesService)a.getListWithUnorderedPossibleTypes().service(PossibleTypesService.class);
            ListPropertyTests.assertEquals((Object)false, (Object)unorderedPossibleTypesService.ordered());
            ListPropertyTests.assertSetOrder(unorderedPossibleTypesService.types(), OrderedPossibleTypesTestElement.Child1.TYPE, OrderedPossibleTypesTestElement.Child2.TYPE, OrderedPossibleTypesTestElement.Child3.TYPE);
            PossibleTypesService orderedPossibleTypesService = (PossibleTypesService)a.getListWithOrderedPossibleTypes().service(PossibleTypesService.class);
            ListPropertyTests.assertEquals((Object)true, (Object)orderedPossibleTypesService.ordered());
            ListPropertyTests.assertSetOrder(orderedPossibleTypesService.types(), OrderedPossibleTypesTestElement.Child2.TYPE, OrderedPossibleTypesTestElement.Child1.TYPE, OrderedPossibleTypesTestElement.Child3.TYPE);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static interface OrderedPossibleTypesTestElement
    extends Element {
        public static final ElementType TYPE = new ElementType(OrderedPossibleTypesTestElement.class);
        @Type(base=Child.class, possible={Child2.class, Child1.class, Child3.class})
        public static final ListProperty PROP_LIST_WITH_UNORDERED_POSSIBLE_TYPES = new ListProperty(TYPE, "ListWithUnorderedPossibleTypes");
        @Type(base=Child.class, possible={Child2.class, Child1.class, Child3.class}, ordered=true)
        public static final ListProperty PROP_LIST_WITH_ORDERED_POSSIBLE_TYPES = new ListProperty(TYPE, "ListWithOrderedPossibleTypes");

        public ElementList<Child> getListWithUnorderedPossibleTypes();

        public ElementList<Child> getListWithOrderedPossibleTypes();

        public static interface Child
        extends Element {
            public static final ElementType TYPE = new ElementType(Child.class);
            public static final ValueProperty PROP_VALUE = new ValueProperty(TYPE, "Value");

            public Value<String> getValue();

            public void setValue(String var1);
        }

        public static interface Child1
        extends Child {
            public static final ElementType TYPE = new ElementType(Child1.class);
        }

        public static interface Child2
        extends Child {
            public static final ElementType TYPE = new ElementType(Child2.class);
        }

        public static interface Child3
        extends Child {
            public static final ElementType TYPE = new ElementType(Child3.class);
        }
    }
}

