/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;

public final class CollectionUtility {
    private CollectionUtility() {
    }

    public static <T> boolean equalsCollection(Collection<? extends T> c1, Collection<? extends T> c2) {
        return CollectionUtility.equalsCollection(c1, c2, false);
    }

    public static <T> boolean equalsCollection(Collection<? extends T> c1, Collection<? extends T> c2, boolean considerElementPosition) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        if (c1.size() != c2.size()) {
            return false;
        }
        if (considerElementPosition) {
            Iterator<T> it1 = c1.iterator();
            Iterator<T> it2 = c2.iterator();
            while (it1.hasNext()) {
                if (CompareUtility.equals(it1.next(), it2.next())) continue;
                return false;
            }
            return true;
        }
        return c1.containsAll(c2);
    }

    public static <T> boolean equalsCollection(List<? extends T> c1, List<? extends T> c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        if (c1.size() != c2.size()) {
            return false;
        }
        return c1.equals(c2);
    }

    public static <T> T firstElement(Collection<T> c) {
        if (CollectionUtility.isEmpty(c)) {
            return null;
        }
        return c.iterator().next();
    }

    public static <T> T firstElement(List<T> c) {
        if (CollectionUtility.isEmpty(c)) {
            return null;
        }
        return c.get(0);
    }

    public static <T> T lastElement(List<T> c) {
        if (CollectionUtility.isEmpty(c)) {
            return null;
        }
        return c.get(c.size() - 1);
    }

    public static <T> boolean containsAny(Collection<T> c, Collection<? extends T> values) {
        if (values == null || c == null) {
            return false;
        }
        HashSet<Collection<T>> set = CollectionUtility.hashSet(c);
        for (T value : values) {
            if (!set.contains(value)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAny(Collection<T> c, T ... values) {
        if (values == null || c == null) {
            return false;
        }
        HashSet<Collection<T>> set = CollectionUtility.hashSet(c);
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            if (set.contains(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> T getElement(List<T> list, int index) {
        if (index >= 0 && index < list.size()) {
            return list.get(index);
        }
        return null;
    }

    public static <T> ArrayList<T> arrayList(T ... values) {
        if (values != null) {
            ArrayList<T> list = new ArrayList<T>(values.length);
            T[] TArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                T v = TArray[n2];
                list.add(v);
                ++n2;
            }
            return list;
        }
        return CollectionUtility.emptyArrayList();
    }

    public static <T> ArrayList<T> emptyArrayList() {
        return new ArrayList(0);
    }

    public static <T> ArrayList<T> arrayList(T value) {
        ArrayList<T> list = new ArrayList<T>();
        if (value != null) {
            list.add(value);
        }
        return list;
    }

    public static <T> ArrayList<T> truncateList(List<? extends T> input, int maxSize) {
        if (input == null) {
            input = new ArrayList<T>();
        }
        int endIndex = Math.min(input.size(), maxSize);
        ArrayList<T> result = new ArrayList<T>(endIndex);
        int i = 0;
        while (i < endIndex) {
            result.add(input.get(i));
            ++i;
        }
        return result;
    }

    public static <T> ArrayList<T> arrayList(Collection<? extends T> c) {
        if (c != null) {
            return new ArrayList<T>(c);
        }
        return CollectionUtility.emptyArrayList();
    }

    public static <T> ArrayList<T> arrayListWithoutNullElements(Collection<? extends T> c) {
        if (c != null) {
            ArrayList<T> list = new ArrayList<T>(c.size());
            for (T o : c) {
                if (o == null) continue;
                list.add(o);
            }
            return list;
        }
        return CollectionUtility.emptyArrayList();
    }

    public static <T> HashSet<T> hashSet(Collection<? extends T> c) {
        if (c != null) {
            return new HashSet<T>(c);
        }
        return new HashSet(0);
    }

    public static <T> HashSet<T> hashSetWithoutNullElements(Collection<? extends T> c) {
        HashSet<Collection<T>> set = CollectionUtility.hashSet(c);
        set.remove(null);
        return set;
    }

    public static <T> LinkedHashSet<T> orderedHashSet(Collection<? extends T> c) {
        if (c != null) {
            return new LinkedHashSet<T>(c);
        }
        return new LinkedHashSet(0);
    }

    public static <T> LinkedHashSet<T> orderedHashSetWithoutNullElements(Collection<? extends T> c) {
        LinkedHashSet<T> set = CollectionUtility.orderedHashSet(c);
        set.remove(null);
        return set;
    }

    @Deprecated
    public static <T> List<T> copyList(Collection<T> c) {
        return CollectionUtility.arrayList(c);
    }

    public static <T> T[] toArray(Collection<T> c, Class<T> clazz) {
        if (c == null || c.size() == 0) {
            Object[] a = (Object[])Array.newInstance(clazz, 0);
            return Collections.emptyList().toArray(a);
        }
        Object[] a = (Object[])Array.newInstance(clazz, c.size());
        return c.toArray(a);
    }

    @Deprecated
    public static <T> List<T> toList(Collection<T> c) {
        if (c == null) {
            return null;
        }
        if (c instanceof List) {
            return (List)c;
        }
        return new ArrayList<T>(c);
    }

    public static <T, V extends T> List<T> appendList(List<T> list, V o) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        list.add(o);
        return list;
    }

    public static <T, V extends T> List<T> appendList(List<T> list, int index, V o) {
        if (list == null) {
            list = new ArrayList<T>(1);
        }
        if (index > list.size()) {
            int i = list.size();
            while (i < index) {
                list.add(i, null);
                ++i;
            }
        }
        list.add(index, o);
        return list;
    }

    public static <T> List<T> appendAllList(List<T> list, Collection<? extends T> c) {
        if (list == null) {
            list = new ArrayList<T>(1);
        }
        if (c != null && c.size() > 0) {
            list.addAll(c);
        }
        return list;
    }

    public static <T, V extends T> List<T> removeObjectList(List<T> list, V o) {
        if (list == null) {
            list = new ArrayList<T>(1);
        }
        list.remove(o);
        return list;
    }

    public static <T> List<T> removeObjectList(List<T> list, int i) {
        if (list == null) {
            list = new ArrayList<T>(1);
        }
        list.remove(i);
        return list;
    }

    public static <T, V extends T> Set<T> removeObjectSet(Set<T> set, V o) {
        if (set == null) {
            set = new HashSet<T>(1);
        }
        set.remove(o);
        return set;
    }

    public static <T> int size(Collection<T> list) {
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public static <T, U> U[] getValueArray(Map<T, U> m, Class<U> clazz) {
        if (m == null || m.size() == 0) {
            Object[] a = (Object[])Array.newInstance(clazz, 0);
            return Collections.emptyList().toArray(a);
        }
        Object[] a = (Object[])Array.newInstance(clazz, m.size());
        return m.values().toArray(a);
    }

    public static <T, U> T[] getKeyArray(Map<T, U> m, Class<T> clazz) {
        if (m == null || m.size() == 0) {
            Object[] a = (Object[])Array.newInstance(clazz, 0);
            return Collections.emptyList().toArray(a);
        }
        Object[] a = (Object[])Array.newInstance(clazz, m.size());
        return m.keySet().toArray(a);
    }

    public static <T, U> Map<T, U> copyMap(Map<T, U> m) {
        if (m == null || m.size() == 0) {
            return new HashMap(0);
        }
        return new HashMap<T, U>(m);
    }

    public static <T, U, V extends T, W extends U> Map<T, U> putObject(Map<T, U> map, V key, W value) {
        if (map == null) {
            map = new HashMap<T, U>();
        }
        map.put(key, value);
        return map;
    }

    public static <T, U> U getObject(Map<T, U> map, T key) {
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public static <T, U> Map<T, U> removeObject(Map<T, U> map, T key) {
        if (map == null) {
            return new HashMap();
        }
        map.remove(key);
        return map;
    }

    public static <T, U> boolean containsValue(Map<T, U> map, U value) {
        if (map == null) {
            return false;
        }
        return map.containsValue(value);
    }

    public static <T, U> boolean containsKey(Map<T, U> map, T key) {
        if (map == null) {
            return false;
        }
        return map.containsKey(key);
    }

    public static <T, U> Map<T, U> putAllObjects(Map<T, U> targetMap, Map<T, U> sourceMap) {
        if (targetMap == null && sourceMap == null) {
            return new HashMap();
        }
        if (targetMap == null) {
            return new HashMap<T, U>(sourceMap);
        }
        if (sourceMap == null) {
            return targetMap;
        }
        targetMap.putAll(sourceMap);
        return targetMap;
    }

    @Deprecated
    public static <T, U> Map<T, U> getEmptyMap(Map<T, U> m) {
        return new HashMap();
    }

    public static <T, U> U[] getSortedValueArray(SortedMap<T, U> m, Class<U> clazz) {
        if (m == null || m.size() == 0) {
            Object[] a = (Object[])Array.newInstance(clazz, 0);
            return Collections.emptyList().toArray(a);
        }
        Object[] a = (Object[])Array.newInstance(clazz, m.size());
        return m.values().toArray(a);
    }

    public static <T, U> SortedMap<T, U> copySortedMap(SortedMap<T, U> m) {
        if (m == null || m.size() == 0) {
            return new TreeMap();
        }
        return new TreeMap<T, U>(m);
    }

    public static <T extends Comparable, U> SortedMap<T, U> putObjectSortedMap(SortedMap<T, U> map, T key, U value) {
        if (map == null) {
            map = new TreeMap<T, U>();
        }
        map.put(key, value);
        return map;
    }

    public static <T extends Comparable, U> U getObjectSortedMap(SortedMap<T, U> map, T key) {
        if (map == null) {
            return null;
        }
        return (U)map.get(key);
    }

    public static <T extends Comparable, U> SortedMap<T, U> removeObjectSortedMap(SortedMap<T, U> map, T key) {
        if (map == null) {
            return new TreeMap();
        }
        map.remove(key);
        return map;
    }

    public static <T extends Comparable, U> SortedMap<T, U> putAllObjectsSortedMap(SortedMap<T, U> targetMap, Map<T, U> sourceMap) {
        if (targetMap == null && sourceMap == null) {
            return new TreeMap();
        }
        if (targetMap == null) {
            return new TreeMap<T, U>(sourceMap);
        }
        if (sourceMap == null) {
            return targetMap;
        }
        targetMap.putAll(sourceMap);
        return targetMap;
    }

    @Deprecated
    public static <T, U> SortedMap<T, U> getEmptySortedMap(SortedMap<T, U> m) {
        return new TreeMap();
    }

    public static <T, U> U lastElement(SortedMap<T, U> m) {
        if (m == null || m.isEmpty()) {
            return null;
        }
        return (U)m.get(m.lastKey());
    }

    public static <T, U> U firstElement(SortedMap<T, U> m) {
        if (m == null || m.isEmpty()) {
            return null;
        }
        return (U)m.get(m.firstKey());
    }

    public static <T> HashSet<T> hashSet(T ... values) {
        if (values != null) {
            HashSet<T> set = new HashSet<T>(values.length);
            T[] TArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                T v = TArray[n2];
                set.add(v);
                ++n2;
            }
            return set;
        }
        return new HashSet(0);
    }

    public static <T> HashSet<T> hashSet(T value) {
        HashSet<T> set = new HashSet<T>();
        if (value != null) {
            set.add(value);
        }
        return set;
    }

    public static <T> List<T> combine(Collection<?> ... collections) {
        ArrayList list = new ArrayList();
        if (collections != null && collections.length > 0) {
            Collection<?>[] collectionArray = collections;
            int n = collections.length;
            int n2 = 0;
            while (n2 < n) {
                Collection<?> c = collectionArray[n2];
                for (Object t : c) {
                    list.add(t);
                }
                ++n2;
            }
        }
        return list;
    }

    public static boolean isEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static boolean hasElements(Collection<?> c) {
        return !CollectionUtility.isEmpty(c);
    }

    public static <T> boolean hasElements(T[] array) {
        if (array == null) {
            return false;
        }
        return array.length > 0;
    }

    public static int hashCode(Collection<?> c) {
        if (c == null) {
            return 0;
        }
        return Arrays.hashCode(c.toArray());
    }

    public static List<Object> parse(String text) {
        List list = null;
        if (StringUtility.hasText(text)) {
            String[] a;
            String[] stringArray = a = text.split(",");
            int n = a.length;
            int n2 = 0;
            while (n2 < n) {
                Object o;
                String s = stringArray[n2];
                if ((s = s.replaceAll("%2C", ",")).equalsIgnoreCase("null")) {
                    o = null;
                } else if (s.length() >= 2 && s.startsWith("'") && s.endsWith("'")) {
                    o = s.substring(1, s.length() - 2);
                } else if (s.length() >= 2 && s.startsWith("\"") && s.endsWith("\"")) {
                    o = s.substring(1, s.length() - 2);
                } else if (s.indexOf(46) >= 0) {
                    try {
                        o = new Double(Double.parseDouble(s));
                    }
                    catch (Exception e) {
                        o = s;
                    }
                } else {
                    try {
                        o = new Long(Long.parseLong(s));
                    }
                    catch (Exception e) {
                        o = s;
                    }
                }
                list = CollectionUtility.appendList(list, o);
                ++n2;
            }
        }
        return CollectionUtility.arrayList(list);
    }

    public static <T> String format(Collection<T> list, String delimiter) {
        return CollectionUtility.format(list, delimiter, false);
    }

    public static String format(Collection<?> list) {
        return CollectionUtility.format(list, false);
    }

    public static <T> String format(Collection<T> c, boolean quoteStrings) {
        return CollectionUtility.format(c, ", ", quoteStrings);
    }

    public static <T> String format(Collection<T> list, String delimiter, boolean quoteStrings) {
        if (CollectionUtility.isEmpty(list)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Iterator<T> it = list.iterator();
        result.append(CollectionUtility.objectToString(it.next(), quoteStrings));
        while (it.hasNext()) {
            result.append(delimiter);
            result.append(CollectionUtility.objectToString(it.next(), quoteStrings));
        }
        return result.toString();
    }

    private static String objectToString(Object o, boolean quoteStrings) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Number) {
            return o.toString();
        }
        if (quoteStrings) {
            return "'" + o.toString().replaceAll(",", "%2C") + "'";
        }
        return o.toString();
    }
}

