/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.osgi;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.internal.Activator;
import org.eclipse.scout.commons.osgi.BundleInspector;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

public class BundleListClassLoader
extends ClassLoader {
    private static final HashMap<String, Class> PRIMITIVE_TYPES = new HashMap(8, 1.0f);
    private static final ThreadLocal<Set<String>> LOOP_DETECTOR;
    private static final Enumeration<URL> EMPTY_URL_ENUMERATION;
    private static final String BUNDLE_INCLUDE_FILTER_PROPERTY = "org.eclipse.scout.commons.osgi.BundleListClassLoader#includeBundles";
    private static final String BUNDLE_EXCLUDE_FILTER_PROPERTY = "org.eclipse.scout.commons.osgi.BundleListClassLoader#excludeBundles";
    private static final String REGEX_MARKER = "regex:";
    private static P_FastClassContextFinder s_fastClassContextFinder;
    private static ClassLoader s_myClassLoader;
    private final Bundle[] m_bundles;
    private final Bundle[] m_bundlesSortedByBundleSymbolicNameLenght;
    private final ClassLoader m_parentContextClassLoader;
    private final ReadWriteLock m_cacheLock = new ReentrantReadWriteLock();
    private final Map<String, WeakReference<Class<?>>> m_classCache;
    private final PrivilegedAction<List<ClassLoader>> m_getClassLoaderImplPrivilegedAction = new PrivilegedAction<List<ClassLoader>>(){

        @Override
        public List<ClassLoader> run() {
            return BundleListClassLoader.this.getClassLoaderContextImpl();
        }
    };

    static {
        PRIMITIVE_TYPES.put("boolean", Boolean.TYPE);
        PRIMITIVE_TYPES.put("byte", Byte.TYPE);
        PRIMITIVE_TYPES.put("char", Character.TYPE);
        PRIMITIVE_TYPES.put("short", Short.TYPE);
        PRIMITIVE_TYPES.put("int", Integer.TYPE);
        PRIMITIVE_TYPES.put("long", Long.TYPE);
        PRIMITIVE_TYPES.put("float", Float.TYPE);
        PRIMITIVE_TYPES.put("double", Double.TYPE);
        PRIMITIVE_TYPES.put("void", Void.TYPE);
        PRIMITIVE_TYPES.put("Z", Boolean.TYPE);
        PRIMITIVE_TYPES.put("B", Byte.TYPE);
        PRIMITIVE_TYPES.put("C", Character.TYPE);
        PRIMITIVE_TYPES.put("S", Short.TYPE);
        PRIMITIVE_TYPES.put("I", Integer.TYPE);
        PRIMITIVE_TYPES.put("J", Long.TYPE);
        PRIMITIVE_TYPES.put("F", Float.TYPE);
        PRIMITIVE_TYPES.put("D", Double.TYPE);
        PRIMITIVE_TYPES.put("V", Void.TYPE);
        LOOP_DETECTOR = new ThreadLocal();
        EMPTY_URL_ENUMERATION = new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public URL nextElement() {
                throw new NoSuchElementException();
            }
        };
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                s_fastClassContextFinder = new P_FastClassContextFinder();
                s_myClassLoader = BundleListClassLoader.class.getClassLoader();
                return null;
            }
        });
    }

    public BundleListClassLoader(ClassLoader parent, Bundle ... bundles) {
        super(parent);
        ClassLoader classLoader = this.m_parentContextClassLoader = parent != null ? parent : new ClassLoader(Object.class.getClassLoader()){};
        if (bundles == null || bundles.length == 0) {
            throw new IllegalArgumentException("bundle list must not be null or empty");
        }
        String bundleIncludeFilter = Activator.getDefault().getBundle().getBundleContext().getProperty(BUNDLE_INCLUDE_FILTER_PROPERTY);
        String bundleExcludeFilter = Activator.getDefault().getBundle().getBundleContext().getProperty(BUNDLE_EXCLUDE_FILTER_PROPERTY);
        Pattern[] bundleIncludePatterns = BundleListClassLoader.parseFilterPatterns(bundleIncludeFilter);
        Pattern[] bundleExcludePatterns = BundleListClassLoader.parseFilterPatterns(bundleExcludeFilter);
        ArrayList<Bundle> filteredBundleList = new ArrayList<Bundle>();
        Bundle[] bundleArray = BundleInspector.filterPluginBundles(bundles);
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (BundleListClassLoader.accept(b.getSymbolicName(), bundleIncludePatterns, bundleExcludePatterns)) {
                filteredBundleList.add(b);
            }
            ++n2;
        }
        this.m_bundles = filteredBundleList.toArray(new Bundle[filteredBundleList.size()]);
        if (this.m_bundles.length == 0) {
            throw new IllegalArgumentException("filtered bundle list must not be empty. [bundles=" + Arrays.toString(bundles) + "]");
        }
        this.m_bundlesSortedByBundleSymbolicNameLenght = new Bundle[this.m_bundles.length];
        System.arraycopy(this.m_bundles, 0, this.m_bundlesSortedByBundleSymbolicNameLenght, 0, this.m_bundles.length);
        Arrays.sort(this.m_bundlesSortedByBundleSymbolicNameLenght, new Comparator<Bundle>(){

            @Override
            public int compare(Bundle b1, Bundle b2) {
                if (b1 == null && b2 == null) {
                    return 0;
                }
                if (b1 == null) {
                    return -1;
                }
                if (b2 == null) {
                    return 1;
                }
                return StringUtility.length(b2.getSymbolicName()) - StringUtility.length(b1.getSymbolicName());
            }
        });
        this.m_classCache = new HashMap();
    }

    private Class<?> putInCache(String name, Class<?> c) {
        this.m_cacheLock.writeLock().lock();
        try {
            this.m_classCache.put(name, new WeakReference(c));
        }
        finally {
            this.m_cacheLock.writeLock().unlock();
        }
        return c;
    }

    public void clearCaches() {
        this.m_cacheLock.writeLock().lock();
        try {
            this.m_classCache.clear();
        }
        finally {
            this.m_cacheLock.writeLock().unlock();
        }
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        if (!this.registerLoadingItem(className)) {
            throw new ClassNotFoundException(className);
        }
        try {
            Class<?> clazz = this.doLoadClass(className);
            return clazz;
        }
        finally {
            this.unregisterLoadingItem(className);
        }
    }

    protected Class<?> doLoadClass(String className) throws ClassNotFoundException {
        Bundle bundle;
        Class c = PRIMITIVE_TYPES.get(className);
        if (c != null) {
            return c;
        }
        int arrayDim = 0;
        while (className.startsWith("[")) {
            className = className.substring(1);
            ++arrayDim;
        }
        if (className.matches("L.*;")) {
            className = className.substring(1, className.length() - 1);
        }
        if (arrayDim > 0) {
            c = this.loadClass(className);
            int[] dimensions = new int[arrayDim];
            c = Array.newInstance(c, dimensions).getClass();
            return c;
        }
        if (className.startsWith("java.")) {
            return this.m_parentContextClassLoader.loadClass(className);
        }
        this.m_cacheLock.readLock().lock();
        try {
            WeakReference<Class<?>> ref = this.m_classCache.get(className);
            if (ref != null && (c = (Class)ref.get()) != null) {
                Class clazz = c;
                return clazz;
            }
            if (this.m_classCache.containsKey(className)) {
                throw new ClassNotFoundException(className);
            }
        }
        finally {
            this.m_cacheLock.readLock().unlock();
        }
        HashSet<Bundle> usedBundles = new HashSet<Bundle>();
        Bundle[] bundleArray = this.m_bundlesSortedByBundleSymbolicNameLenght;
        int n = this.m_bundlesSortedByBundleSymbolicNameLenght.length;
        int n2 = 0;
        while (n2 < n) {
            bundle = bundleArray[n2];
            if (!usedBundles.contains(bundle) && className.startsWith(String.valueOf(bundle.getSymbolicName()) + ".")) {
                usedBundles.add(bundle);
                try {
                    c = bundle.loadClass(className);
                    return this.putInCache(className, c);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        bundleArray = this.m_bundlesSortedByBundleSymbolicNameLenght;
        n = this.m_bundlesSortedByBundleSymbolicNameLenght.length;
        n2 = 0;
        while (n2 < n) {
            bundle = bundleArray[n2];
            if (!usedBundles.contains(bundle) && bundle.getState() == 32) {
                usedBundles.add(bundle);
                try {
                    c = bundle.loadClass(className);
                    return this.putInCache(className, c);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        bundleArray = this.m_bundles;
        n = this.m_bundles.length;
        n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (!usedBundles.contains(b)) {
                try {
                    c = b.loadClass(className);
                    return this.putInCache(className, c);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        try {
            c = this.m_parentContextClassLoader.loadClass(className);
            return this.putInCache(className, c);
        }
        catch (Exception exception) {
            this.putInCache(className, null);
            throw new ClassNotFoundException(className);
        }
    }

    @Override
    public URL getResource(String name) {
        if (!this.registerLoadingItem(name)) {
            return null;
        }
        try {
            List<ClassLoader> clList = this.getClassLoaderContext();
            for (ClassLoader cl : clList) {
                URL res = cl.getResource(name);
                if (res == null) continue;
                URL uRL = res;
                return uRL;
            }
            URL uRL = super.getResource(name);
            return uRL;
        }
        finally {
            this.unregisterLoadingItem(name);
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        if (!this.registerLoadingItem(name)) {
            return EMPTY_URL_ENUMERATION;
        }
        try {
            List<ClassLoader> clList = this.getClassLoaderContext();
            for (ClassLoader cl : clList) {
                Enumeration<URL> res = cl.getResources(name);
                if (res == null || !res.hasMoreElements()) continue;
                Enumeration<URL> enumeration = res;
                return enumeration;
            }
            Enumeration<URL> enumeration = super.findResources(name);
            return enumeration;
        }
        finally {
            this.unregisterLoadingItem(name);
        }
    }

    private List<ClassLoader> getClassLoaderContext() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(this.m_getClassLoaderImplPrivilegedAction);
        }
        return this.getClassLoaderContextImpl();
    }

    private List<ClassLoader> getClassLoaderContextImpl() {
        Class<?>[] currentStack = s_fastClassContextFinder.getClassContext();
        ArrayList<ClassLoader> result = new ArrayList<ClassLoader>(1);
        ClassLoader prevCl = null;
        Class<?>[] classArray = currentStack;
        int n = currentStack.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader cl;
            Class<?> classOnStack = classArray[n2];
            if (classOnStack != BundleListClassLoader.class && classOnStack != P_FastClassContextFinder.class && (cl = classOnStack.getClassLoader()) != null && cl != this) {
                if (prevCl != cl && this.isDistinctClassLoaderHierarchy(cl)) {
                    prevCl = cl;
                    result.add(cl);
                }
                if (cl == s_myClassLoader || cl instanceof BundleReference) break;
            }
            ++n2;
        }
        return result;
    }

    private boolean isDistinctClassLoaderHierarchy(ClassLoader cl) {
        if (cl == null || cl == this.getParent()) {
            return false;
        }
        ClassLoader parent = cl.getParent();
        while (parent != null) {
            if (parent == this) {
                return false;
            }
            parent = parent.getParent();
        }
        return true;
    }

    private boolean registerLoadingItem(String name) {
        Set<String> loadingItems = LOOP_DETECTOR.get();
        if (loadingItems != null && loadingItems.contains(name)) {
            return false;
        }
        if (loadingItems == null) {
            loadingItems = new HashSet<String>(3);
            LOOP_DETECTOR.set(loadingItems);
        }
        loadingItems.add(name);
        return true;
    }

    private void unregisterLoadingItem(String name) {
        LOOP_DETECTOR.get().remove(name);
    }

    private static boolean accept(String s, Pattern[] includePatterns, Pattern[] excludePatterns) {
        Pattern p;
        int n;
        int n2;
        Pattern[] patternArray;
        if (s == null) {
            return false;
        }
        boolean included = true;
        boolean excluded = false;
        if (includePatterns != null && includePatterns.length > 0) {
            included = false;
            patternArray = includePatterns;
            n2 = includePatterns.length;
            n = 0;
            while (n < n2) {
                p = patternArray[n];
                if (p.matcher(s).matches()) {
                    included = true;
                    break;
                }
                ++n;
            }
        }
        if (included && excludePatterns != null && excludePatterns.length > 0) {
            patternArray = excludePatterns;
            n2 = excludePatterns.length;
            n = 0;
            while (n < n2) {
                p = patternArray[n];
                if (p.matcher(s).matches()) {
                    excluded = true;
                    break;
                }
                ++n;
            }
        }
        return included && !excluded;
    }

    private static Pattern[] parseFilterPatterns(String filter) {
        if (filter == null) {
            return null;
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        String[] stringArray = filter.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            if ((f = f.trim()).length() > 0) {
                try {
                    f = BundleListClassLoader.toRegexPattern(f);
                    Pattern pattern = Pattern.compile(f);
                    patterns.add(pattern);
                }
                catch (Exception e) {
                    System.err.println("invalid filter pattern: " + e);
                }
            }
            ++n2;
        }
        if (patterns.isEmpty()) {
            return null;
        }
        return patterns.toArray(new Pattern[patterns.size()]);
    }

    private static String toRegexPattern(String s) {
        if (s == null) {
            return null;
        }
        String pattern = s.trim();
        if (pattern.startsWith(REGEX_MARKER)) {
            return pattern.substring(REGEX_MARKER.length());
        }
        pattern = pattern.replaceAll("[.]", "\\\\.");
        pattern = pattern.replaceAll("[*]", ".*");
        pattern = pattern.replaceAll("[?]", ".");
        return pattern;
    }

    private static final class P_FastClassContextFinder
    extends SecurityManager {
        private P_FastClassContextFinder() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

