/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.internal.resources;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;

abstract class AbstractResolver<T> {
    private static final Logger LOG = Logger.getLogger("com.sun.xml.ws.server.http");
    private Bundle[] m_bundles;

    public AbstractResolver(Bundle ... bundles) {
        this.m_bundles = bundles;
    }

    public void setBundles(Bundle[] bundles) {
        this.m_bundles = bundles;
    }

    public T resolve() {
        Bundle[] bundleArray = this.m_bundles;
        int n = this.m_bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getState() < 4) {
                LOG.log(Level.SEVERE, "JAXWS resources could not be loaded as bundle '" + bundle.getSymbolicName() + "' is not in state RESOLVED.");
            } else {
                try {
                    return this.resolve(bundle);
                }
                catch (ResourceNotFoundException resourceNotFoundException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return this.resolveEmpty();
    }

    public abstract T resolve(Bundle var1) throws ResourceNotFoundException;

    public T resolveEmpty() {
        return null;
    }

    static class ResourceNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ResourceNotFoundException() {
        }
    }
}

