/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.model;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.internal.model.IReferenceProvider;
import org.eclipse.scout.nls.sdk.internal.model.workspace.InheritedNlsEntry;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class NlsTableModel
extends ViewerComparator
implements IStructuredContentProvider,
ITableLabelProvider,
ITableColorProvider {
    private int m_sortIndex = -2;
    private boolean m_ascSorting = false;
    private final INlsProject m_projects;
    private IReferenceProvider m_referenceProvider;

    public NlsTableModel(INlsProject projects) {
        this.m_projects = projects;
    }

    public Object[] getElements(Object inputElement) {
        if (this.getProjects() == null) {
            return new Object[0];
        }
        return this.getProjects().getAllEntries();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image img = null;
        if (columnIndex == 0) {
            img = NlsCore.getImage("text");
        }
        return img;
    }

    public Language getLanguageOfColumn(int colIndex) {
        Language[] allLanguages = this.getProjects().getAllLanguages();
        int offset = 2;
        if (allLanguages != null && colIndex >= offset && allLanguages.length > 0 && allLanguages.length + offset > colIndex) {
            return allLanguages[colIndex - offset];
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Language lang;
        INlsEntry row = (INlsEntry)element;
        switch (columnIndex) {
            case 0: {
                if (this.getReferenceProvider() != null) {
                    return "" + this.getReferenceProvider().getReferenceCount(row);
                }
                return "";
            }
            case 1: {
                return row.getKey();
            }
        }
        String text = "";
        if (columnIndex > 0 && (lang = this.getLanguageOfColumn(columnIndex)) != null && (text = row.getTranslation(lang)) == null) {
            return "";
        }
        return text.replace("\n", " ").replace("\r", "");
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        Color c = null;
        if (element instanceof InheritedNlsEntry) {
            c = NlsCore.getColor("nlsRowInactiveForeground");
        }
        return c;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int index = this.m_sortIndex;
        if (this.m_ascSorting) {
            return this.getColumnText(e2, index).toLowerCase().compareTo(this.getColumnText(e1, index).toLowerCase());
        }
        return this.getColumnText(e1, index).toLowerCase().compareTo(this.getColumnText(e2, index).toLowerCase());
    }

    public boolean isAscSorting() {
        return this.m_ascSorting;
    }

    public void setAscSorting(boolean sorting) {
        this.m_ascSorting = sorting;
    }

    public int getSortIndex() {
        return this.m_sortIndex;
    }

    public void setSortIndex(int index) {
        this.m_sortIndex = index;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public INlsProject getProjects() {
        return this.m_projects;
    }

    public void setReferenceProvider(IReferenceProvider referenceProvider) {
        this.m_referenceProvider = referenceProvider;
    }

    public IReferenceProvider getReferenceProvider() {
        return this.m_referenceProvider;
    }
}

