/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.search;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.internal.search.INlsKeySearchListener;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.ui.text.Match;

public class NlsKeySearchRequestor
extends TextSearchRequestor {
    private Map<String, List<Match>> m_matches;
    private EventListenerList m_eventListeners = new EventListenerList();

    public void beginReporting() {
        this.m_matches = new HashMap<String, List<Match>>();
        INlsKeySearchListener[] iNlsKeySearchListenerArray = (INlsKeySearchListener[])this.m_eventListeners.getListeners(INlsKeySearchListener.class);
        int n = iNlsKeySearchListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            INlsKeySearchListener l = iNlsKeySearchListenerArray[n2];
            try {
                l.beginReporting();
            }
            catch (Exception t) {
                NlsCore.logError("error during listener notification.", t);
            }
            ++n2;
        }
    }

    public boolean acceptPatternMatch(TextSearchMatchAccess matchAccess) throws CoreException {
        Match match = new Match((Object)matchAccess.getFile(), matchAccess.getMatchOffset(), matchAccess.getMatchLength());
        String key = matchAccess.getFileContent(matchAccess.getMatchOffset(), matchAccess.getMatchLength());
        key = key.replaceAll("\\\"", "");
        this.acceptNlsKeyMatch(key, match);
        return true;
    }

    protected void acceptNlsKeyMatch(String nlsKey, Match match) {
        List<Match> list = this.m_matches.get(nlsKey);
        if (list == null) {
            list = new ArrayList<Match>();
            this.m_matches.put(nlsKey, list);
        }
        list.add(match);
        INlsKeySearchListener[] iNlsKeySearchListenerArray = (INlsKeySearchListener[])this.m_eventListeners.getListeners(INlsKeySearchListener.class);
        int n = iNlsKeySearchListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            INlsKeySearchListener l = iNlsKeySearchListenerArray[n2];
            try {
                l.foundMatch(nlsKey, match);
            }
            catch (Exception t) {
                NlsCore.logError("error during listener notification.", t);
            }
            ++n2;
        }
    }

    public void endReporting() {
        INlsKeySearchListener[] iNlsKeySearchListenerArray = (INlsKeySearchListener[])this.m_eventListeners.getListeners(INlsKeySearchListener.class);
        int n = iNlsKeySearchListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            INlsKeySearchListener l = iNlsKeySearchListenerArray[n2];
            try {
                l.endReporting();
            }
            catch (Exception t) {
                NlsCore.logError("error during listener notification.", t);
            }
            ++n2;
        }
    }

    public void addFindReferencesListener(INlsKeySearchListener listener) {
        this.m_eventListeners.add(INlsKeySearchListener.class, (EventListener)listener);
    }

    public void removeFindReferencesListener(INlsKeySearchListener listener) {
        this.m_eventListeners.remove(INlsKeySearchListener.class, (EventListener)listener);
    }

    public Match[] getMatches(String nlsKey) {
        List<Match> list = this.m_matches.get(nlsKey);
        if (list == null) {
            list = new ArrayList<Match>();
        }
        return list.toArray(new Match[list.size()]);
    }

    public Map<String, List<Match>> getAllMatches() {
        return new HashMap<String, List<Match>>(this.m_matches);
    }
}

