/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.model.workspace.project;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.internal.model.workspace.InheritedNlsEntry;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.NlsStatusDialog;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.model.workspace.NlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProjectListener;
import org.eclipse.scout.nls.sdk.model.workspace.project.NlsProjectEvent;
import org.eclipse.scout.nls.sdk.model.workspace.project.NlsResourceProvider;
import org.eclipse.scout.nls.sdk.model.workspace.translationResource.ITranslationResource;
import org.eclipse.scout.nls.sdk.model.workspace.translationResource.ITranslationResourceListener;
import org.eclipse.scout.nls.sdk.model.workspace.translationResource.TranslationResourceEvent;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractNlsProject
implements INlsProject {
    private final EventListenerList m_listeners = new EventListenerList();
    private final ITranslationResourceListener m_translationResourceListener = new P_TranslationResourceChangedListener();
    private final OptimisticLock m_translationResourceEventLock = new OptimisticLock();
    private final NlsResourceProvider m_resourceProvider = new NlsResourceProvider();
    private final IType m_nlsAccessorType;
    private Map<String, NlsEntry> m_entries = null;
    private Language m_developerLanguage = null;
    private INlsProject m_parent = null;

    public AbstractNlsProject(IType type) {
        this.m_nlsAccessorType = type;
    }

    @Override
    public IType getNlsAccessorType() {
        return this.m_nlsAccessorType;
    }

    @Override
    public String getName() {
        return this.m_nlsAccessorType.getElementName();
    }

    protected void resetCache() {
        this.m_entries = null;
    }

    @Override
    public boolean isReadOnly() {
        Language[] languageArray = this.getAllLanguages();
        int n = languageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language l = languageArray[n2];
            ITranslationResource resource = this.getTranslationResource(l);
            if (resource != null && resource.isReadOnly()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Language[] getAllLanguages() {
        return this.m_resourceProvider.getAllLanguages();
    }

    @Override
    public ITranslationResource getTranslationResource(Language language) {
        return this.m_resourceProvider.getResource(language);
    }

    public ITranslationResource[] getAllTranslationResources() {
        return this.m_resourceProvider.getSortedResources();
    }

    private void cache() {
        if (this.m_entries == null) {
            int n;
            int n2;
            Object[] objectArray;
            this.m_entries = new HashMap<String, NlsEntry>();
            if (this.getParent() != null) {
                objectArray = this.getParent().getAllKeys();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Object parentKey = objectArray[n];
                    this.m_entries.put((String)parentKey, new InheritedNlsEntry(this.getParent().getEntry((String)parentKey), (INlsProject)this));
                    ++n;
                }
            }
            objectArray = this.getAllTranslationResources();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object r = objectArray[n];
                String[] stringArray = r.getAllKeys();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String key = stringArray[n4];
                    NlsEntry nlsEntry = this.m_entries.get(key);
                    if (nlsEntry == null) {
                        nlsEntry = new NlsEntry(key, (INlsProject)this);
                        this.m_entries.put(key, nlsEntry);
                    }
                    if (nlsEntry.getType() == 2) {
                        this.m_entries.remove(key);
                        nlsEntry = new NlsEntry(nlsEntry);
                        this.m_entries.put(key, nlsEntry);
                    }
                    nlsEntry.addTranslation(r.getLanguage(), r.getTranslation(key));
                    ++n4;
                }
                ++n;
            }
        }
    }

    @Override
    public String[] getAllKeys() {
        this.cache();
        return this.m_entries.keySet().toArray(new String[this.m_entries.size()]);
    }

    @Override
    public IStatus removeEntries(INlsEntry[] entries, IProgressMonitor m) {
        ITranslationResource[] iTranslationResourceArray = this.getAllTranslationResources();
        int n = iTranslationResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITranslationResource r = iTranslationResourceArray[n2];
            INlsEntry[] iNlsEntryArray = entries;
            int n3 = entries.length;
            int n4 = 0;
            while (n4 < n3) {
                INlsEntry e = iNlsEntryArray[n4];
                IStatus status = r.remove(e.getKey(), m);
                if (!status.isOK()) {
                    new NlsStatusDialog(Display.getDefault().getActiveShell(), status).open();
                    return status;
                }
                ++n4;
            }
            r.commitChanges(m);
            ++n2;
        }
        this.refresh();
        return Status.OK_STATUS;
    }

    @Override
    public INlsEntry getEntry(String key) {
        this.cache();
        return this.m_entries.get(key);
    }

    @Override
    public INlsEntry[] getEntries(String prefix, boolean caseSensitive) {
        this.cache();
        if (StringUtility.hasText((String)prefix)) {
            String compareablePrefix = prefix;
            if (!caseSensitive) {
                compareablePrefix = compareablePrefix.toLowerCase();
            }
            ArrayList<INlsEntry> entries = new ArrayList<INlsEntry>();
            Iterator<String> iterator = this.m_entries.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                String compareKey = key = iterator.next();
                if (!caseSensitive) {
                    compareKey = compareKey.toLowerCase();
                }
                if (!compareKey.startsWith(compareablePrefix)) continue;
                entries.add(this.m_entries.get(key));
            }
            return entries.toArray(new INlsEntry[entries.size()]);
        }
        return this.m_entries.values().toArray(new INlsEntry[this.m_entries.values().size()]);
    }

    @Override
    public INlsEntry[] getAllEntries() {
        this.cache();
        return this.m_entries.values().toArray(new INlsEntry[this.m_entries.size()]);
    }

    @Override
    public INlsProject getParent() {
        return this.m_parent;
    }

    @Override
    public String generateKey(String baseText) {
        return this.generateKey(baseText, false);
    }

    @Override
    public String generateNewKey(String baseText) {
        return this.generateKey(baseText, true);
    }

    protected String generateKey(String baseText, boolean appendFreeNumSuffix) {
        this.cache();
        if (!StringUtility.hasText((String)baseText)) {
            return null;
        }
        StringBuilder ret = new StringBuilder(baseText.length());
        baseText = baseText.replaceAll("[^a-zA-Z0-9_.\\-\\s]*", "").trim();
        String[] split = baseText.split(" ");
        int i = 0;
        while (i < split.length) {
            String splitValue = split[i];
            if (splitValue.length() > 0) {
                char first = splitValue.charAt(0);
                if (split.length > 1) {
                    first = Character.toUpperCase(first);
                }
                ret.append(first);
                if (splitValue.length() > 1) {
                    ret.append(splitValue.substring(1));
                }
            }
            ++i;
        }
        while (ret.length() > 0 && (ret.charAt(0) == '.' || ret.charAt(0) == '_' || ret.charAt(0) == '-')) {
            ret.deleteCharAt(0);
        }
        while (ret.length() > 0 && (ret.charAt(ret.length() - 1) == '.' || ret.charAt(ret.length() - 1) == '-')) {
            ret.deleteCharAt(ret.length() - 1);
        }
        int maxLength = 190;
        String newKey = ret.length() > maxLength ? ret.substring(0, maxLength) : ret.toString();
        String result = newKey;
        if (appendFreeNumSuffix) {
            int i2 = 0;
            while (this.m_entries.containsKey(result)) {
                result = String.valueOf(newKey) + i2++;
            }
        }
        return result;
    }

    protected void setParent(INlsProject newParent) {
        this.m_parent = newParent;
        this.m_parent.addProjectListener(new P_ParentListener());
    }

    @Override
    public Language getDevelopmentLanguage() {
        if (this.m_developerLanguage == null) {
            Language lang = new Language(Locale.getDefault());
            if (!(this.containsLanguage(lang) || this.containsLanguage(lang = new Language(new Locale(lang.getLocale().getLanguage(), lang.getLocale().getCountry()))) || this.containsLanguage(lang = new Language(new Locale(lang.getLocale().getLanguage()))))) {
                lang = Language.LANGUAGE_DEFAULT;
            }
            this.m_developerLanguage = lang;
        }
        return this.m_developerLanguage;
    }

    @Override
    public void updateKey(INlsEntry entry, String newKey, IProgressMonitor monitor) {
        if (this.m_entries != null) {
            NlsProjectEvent multiEvent = new NlsProjectEvent(this);
            try {
                this.m_translationResourceEventLock.acquire();
                monitor.beginTask("update Key", -1);
                NlsEntry originalEntry = this.m_entries.remove(entry.getKey());
                if (originalEntry == null) {
                    NlsCore.logError("The nls entry with the key '" + entry.getKey() + "' can not be found");
                    return;
                }
                if (originalEntry.getType() == 2) {
                    NlsCore.logError("The inherited NLS entry '" + originalEntry.getKey() + "' can not be modified");
                    return;
                }
                multiEvent.addChildEvent(new NlsProjectEvent((INlsProject)this, originalEntry, 2));
                for (Map.Entry<Language, String> e : entry.getAllTranslations().entrySet()) {
                    ITranslationResource r = this.getTranslationResource(e.getKey());
                    if (r == null) continue;
                    r.updateKey(entry.getKey(), newKey, monitor);
                }
                NlsEntry newEntry = new NlsEntry(originalEntry);
                newEntry.setKey(newKey);
                this.m_entries.put(newEntry.getKey(), newEntry);
                multiEvent.addChildEvent(new NlsProjectEvent((INlsProject)this, newEntry, 1));
            }
            finally {
                this.m_translationResourceEventLock.release();
            }
        }
    }

    @Override
    public void updateRow(INlsEntry row, IProgressMonitor monitor) {
        this.updateRow(row, true, monitor);
    }

    @Override
    public void flush(IProgressMonitor monitor) {
        ITranslationResource[] iTranslationResourceArray = this.m_resourceProvider.getResources();
        int n = iTranslationResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITranslationResource r = iTranslationResourceArray[n2];
            r.commitChanges(monitor);
            ++n2;
        }
    }

    @Override
    public void updateRow(INlsEntry row, boolean flush, IProgressMonitor monitor) {
        if (!StringUtility.hasText((String)row.getKey())) {
            throw new IllegalArgumentException("a text key cannot be null.");
        }
        this.cache();
        try {
            this.m_translationResourceEventLock.acquire();
            NlsEntry existingEntry = this.m_entries.get(row.getKey());
            if (existingEntry != null) {
                if (existingEntry.getType() == 2) {
                    this.createNewRowInternal(row, flush, monitor);
                } else {
                    this.updateExistingRowInternal(existingEntry, row, flush, monitor);
                }
            } else {
                this.createNewRowInternal(row, flush, monitor);
            }
        }
        finally {
            this.m_translationResourceEventLock.release();
        }
    }

    private void createNewRowInternal(INlsEntry row, boolean flush, IProgressMonitor monitor) {
        NlsEntry newRow = new NlsEntry(row);
        this.m_entries.put(newRow.getKey(), newRow);
        for (Map.Entry<Language, String> entry : newRow.getAllTranslations().entrySet()) {
            ITranslationResource r = this.getTranslationResource(entry.getKey());
            if (r == null) continue;
            r.updateText(newRow.getKey(), entry.getValue(), flush, monitor);
        }
        this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, newRow, 1));
    }

    private void updateExistingRowInternal(NlsEntry existingRow, INlsEntry row, boolean flush, IProgressMonitor monitor) {
        boolean updated = false;
        for (Map.Entry<Language, String> entry : row.getAllTranslations().entrySet()) {
            ITranslationResource r;
            String existingTranslation = existingRow.getTranslation(entry.getKey());
            if (!CompareUtility.notEquals((Object)existingTranslation, (Object)entry.getValue()) || (r = this.getTranslationResource(entry.getKey())) == null) continue;
            updated = true;
            r.updateText(row.getKey(), entry.getValue(), flush, monitor);
            existingRow.addTranslation(entry.getKey(), entry.getValue());
        }
        if (updated) {
            this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, existingRow, 4));
        }
    }

    private void handleParentRowAdded(INlsEntry superRow) {
        NlsEntry entry;
        if (this.m_entries != null && ((entry = this.m_entries.get(superRow.getKey())) == null || entry.getType() == 2)) {
            entry = new InheritedNlsEntry(superRow, (INlsProject)this);
            this.m_entries.put(entry.getKey(), entry);
            this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, entry, 1));
        }
    }

    private void handleParentRowRemoved(INlsEntry superRow) {
        NlsEntry removedEntry;
        NlsEntry existing;
        if (this.m_entries != null && (existing = this.m_entries.get(superRow.getKey())).getType() == 2 && (removedEntry = this.m_entries.remove(superRow.getKey())) != null) {
            this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, removedEntry, 2));
        }
    }

    private void handleParentRowModified(INlsEntry superRow) {
        if (this.m_entries != null) {
            NlsEntry entry = this.m_entries.get(superRow.getKey());
            if (entry == null) {
                NlsCore.logError("NLS entry with key:'" + superRow.getKey() + "' not found");
                return;
            }
            if (entry.getType() == 2) {
                entry.update(superRow);
                this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, entry, 4));
            }
        }
    }

    protected abstract ITranslationResource[] loadTranslationResources() throws CoreException;

    protected void updateTranslationResourceLocation() {
        try {
            ITranslationResource[] translationResources;
            ITranslationResource[] iTranslationResourceArray = translationResources = this.loadTranslationResources();
            int n = translationResources.length;
            int n2 = 0;
            while (n2 < n) {
                ITranslationResource r = iTranslationResourceArray[n2];
                if (r.getLanguage() != null) {
                    this.addTranslationResource(r, (IProgressMonitor)new NullProgressMonitor());
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            NlsCore.logError("could not load tranlstion property resources.", e);
        }
    }

    protected void addTranslationResource(ITranslationResource r, IProgressMonitor monitor) {
        r.getLanguage().setLocal(true);
        r.addTranslationResourceListener(this.m_translationResourceListener);
        this.m_resourceProvider.addResource(r);
        this.resetCache();
        this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, r, 32));
    }

    @Override
    public void refresh() {
        this.resetCache();
        ITranslationResource[] iTranslationResourceArray = this.m_resourceProvider.getResources();
        int n = iTranslationResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITranslationResource r = iTranslationResourceArray[n2];
            r.removeTranslationResourceListener(this.m_translationResourceListener);
            this.m_resourceProvider.remove(r);
            ++n2;
        }
        this.updateTranslationResourceLocation();
        this.fireNlsProjectEvent(new NlsProjectEvent(this, 16));
    }

    @Override
    public Language getBestMatchingProjectLanguage(Language language) {
        if (this.containsLanguage(language)) {
            return language;
        }
        Locale locale = new Locale(language.getLocale().getLanguage(), language.getLocale().getCountry());
        Language bestMatch = new Language(locale);
        if (this.containsLanguage(bestMatch)) {
            return bestMatch;
        }
        locale = new Locale(language.getLocale().getLanguage());
        bestMatch = new Language(locale);
        if (this.containsLanguage(bestMatch)) {
            return bestMatch;
        }
        return Language.LANGUAGE_DEFAULT;
    }

    @Override
    public boolean containsLanguage(Language languge) {
        return this.m_resourceProvider.containsResource(languge);
    }

    @Override
    public void addProjectListener(INlsProjectListener listener) {
        this.m_listeners.add(INlsProjectListener.class, (EventListener)listener);
    }

    @Override
    public void removeProjectListener(INlsProjectListener listener) {
        this.m_listeners.remove(INlsProjectListener.class, (EventListener)listener);
    }

    protected void fireNlsProjectEvent(NlsProjectEvent event) {
        INlsProjectListener[] iNlsProjectListenerArray = (INlsProjectListener[])this.m_listeners.getListeners(INlsProjectListener.class);
        int n = iNlsProjectListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            INlsProjectListener listener = iNlsProjectListenerArray[n2];
            try {
                listener.notifyProjectChanged(event);
            }
            catch (Exception t) {
                NlsCore.logError("error during listener notification.", t);
            }
            ++n2;
        }
    }

    private void handleTranlationResourceChanged(TranslationResourceEvent event) {
        try {
            if (this.m_translationResourceEventLock.acquire()) {
                HashMap<INlsEntry, NlsProjectEvent> addEvents = new HashMap<INlsEntry, NlsProjectEvent>();
                HashMap<INlsEntry, NlsProjectEvent> modifyEvents = new HashMap<INlsEntry, NlsProjectEvent>();
                HashMap<INlsEntry, NlsProjectEvent> removeEvents = new HashMap<INlsEntry, NlsProjectEvent>();
                this.handleTranslationResourceChangedRec(addEvents, modifyEvents, removeEvents, event);
                NlsProjectEvent multiEvent = new NlsProjectEvent(this);
                for (NlsProjectEvent e : addEvents.values()) {
                    multiEvent.addChildEvent(e);
                }
                for (NlsProjectEvent e : removeEvents.values()) {
                    multiEvent.addChildEvent(e);
                }
                for (NlsProjectEvent e : modifyEvents.values()) {
                    multiEvent.addChildEvent(e);
                }
                if (multiEvent.getChildEvents().length == 1) {
                    this.fireNlsProjectEvent(multiEvent.getChildEvents()[0]);
                } else if (multiEvent.getChildEvents().length > 1) {
                    this.fireNlsProjectEvent(multiEvent);
                }
            }
        }
        finally {
            this.m_translationResourceEventLock.release();
        }
    }

    private void handleTranslationResourceChangedRec(Map<INlsEntry, NlsProjectEvent> addEvents, Map<INlsEntry, NlsProjectEvent> modifyEvents, Map<INlsEntry, NlsProjectEvent> removeEvents, TranslationResourceEvent event) {
        if (event.isMulti()) {
            TranslationResourceEvent[] translationResourceEventArray = event.getSubEvents();
            int n = translationResourceEventArray.length;
            int n2 = 0;
            while (n2 < n) {
                TranslationResourceEvent e = translationResourceEventArray[n2];
                this.handleTranslationResourceChangedRec(addEvents, modifyEvents, removeEvents, e);
                ++n2;
            }
        } else {
            String key = event.getKey();
            String translation = event.getTranslation();
            this.cache();
            NlsEntry entry = this.m_entries.get(key);
            switch (event.getType()) {
                case 1: {
                    if (entry == null) {
                        entry = new NlsEntry(key, (INlsProject)this);
                        entry.addTranslation(event.getSource().getLanguage(), translation);
                        this.m_entries.put(entry.getKey(), entry);
                        addEvents.put(entry, new NlsProjectEvent((INlsProject)this, entry, 1));
                        break;
                    }
                    modifyEvents.put(entry, new NlsProjectEvent((INlsProject)this, entry, 4));
                    break;
                }
                case 2: {
                    if (entry != null && entry.getType() == 1) {
                        entry.addTranslation(event.getSource().getLanguage(), null);
                        boolean isEmpty = true;
                        ITranslationResource[] iTranslationResourceArray = this.getAllTranslationResources();
                        int n = iTranslationResourceArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            ITranslationResource r = iTranslationResourceArray[n3];
                            if (r.getTranslation(entry.getKey()) != null) {
                                isEmpty = false;
                                break;
                            }
                            ++n3;
                        }
                        if (isEmpty) {
                            INlsEntry e;
                            this.m_entries.remove(entry.getKey());
                            if (this.m_parent != null && (e = this.m_parent.getEntry(entry.getKey())) != null) {
                                this.m_entries.put(entry.getKey(), new InheritedNlsEntry(e, (INlsProject)this));
                            }
                            removeEvents.put(entry, new NlsProjectEvent((INlsProject)this, entry, 2));
                            modifyEvents.remove(entry);
                            break;
                        }
                        modifyEvents.put(entry, new NlsProjectEvent((INlsProject)this, entry, 4));
                    }
                    break;
                }
                case 4: {
                    if (entry == null) break;
                    if (entry.getType() == 1) {
                        entry.addTranslation(event.getSource().getLanguage(), translation);
                    }
                    modifyEvents.put(entry, new NlsProjectEvent((INlsProject)this, entry, 4));
                    break;
                }
                case 1024: {
                    this.refresh();
                    break;
                }
            }
        }
    }

    private class P_ParentListener
    implements INlsProjectListener {
        private P_ParentListener() {
        }

        @Override
        public void notifyProjectChanged(NlsProjectEvent event) {
            if (event.isMultiEvent()) {
                NlsProjectEvent[] nlsProjectEventArray = event.getChildEvents();
                int n = nlsProjectEventArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NlsProjectEvent subEvent = nlsProjectEventArray[n2];
                    this.notifyProjectChanged(subEvent);
                    ++n2;
                }
            } else {
                switch (event.getType()) {
                    case 1: {
                        AbstractNlsProject.this.handleParentRowAdded(event.getEntry());
                        break;
                    }
                    case 2: {
                        AbstractNlsProject.this.handleParentRowRemoved(event.getEntry());
                        break;
                    }
                    case 4: {
                        AbstractNlsProject.this.handleParentRowModified(event.getEntry());
                        break;
                    }
                }
            }
        }
    }

    private class P_TranslationResourceChangedListener
    implements ITranslationResourceListener {
        private P_TranslationResourceChangedListener() {
        }

        @Override
        public void translationResourceChanged(TranslationResourceEvent event) {
            AbstractNlsProject.this.handleTranlationResourceChanged(event);
        }
    }
}

