/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.ui.action;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.NlsEntryNewDialog;
import org.eclipse.scout.nls.sdk.model.workspace.NlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.ui.action.AbstractWorkspaceAction;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class NlsEntryNewAction
extends AbstractWorkspaceAction {
    private NlsEntry m_entry;
    private NlsEntry m_initialEntry;
    private INlsProject m_project;
    private final Shell m_parentShell;
    private final boolean m_showProjectList;

    public NlsEntryNewAction(Shell parentShell, INlsProject project, boolean showProjectList) {
        this(parentShell, project, null, showProjectList);
    }

    public NlsEntryNewAction(Shell parentShell, INlsProject project, NlsEntry entry, boolean showProjectList) {
        super("New Entry...", true);
        this.m_parentShell = parentShell;
        this.m_initialEntry = entry;
        this.m_project = project;
        this.m_showProjectList = showProjectList;
        this.setImageDescriptor(NlsCore.getImageDescriptor("text_add"));
        this.setEnabled(project != null && !project.isReadOnly());
    }

    @Override
    protected boolean interactWithUi() {
        if (this.m_project.isReadOnly()) {
            MessageBox box = new MessageBox(this.m_parentShell, 34);
            box.setMessage("The NLS Project is read-only. Check that you have a valid NLS Project in your workspace.");
            box.open();
            return false;
        }
        this.m_entry = this.m_initialEntry == null ? new NlsEntry("", this.m_project) : this.m_initialEntry;
        NlsEntryNewDialog dialog = new NlsEntryNewDialog(this.m_parentShell, this.m_entry, this.m_project, this.m_showProjectList);
        this.m_entry = dialog.show();
        this.m_project = dialog.getNlsProject();
        return this.m_entry != null;
    }

    @Override
    protected void execute(IProgressMonitor monitor) {
        if (this.getEntry() != null) {
            this.m_project.updateRow(this.getEntry(), monitor);
        }
    }

    public NlsEntry getEntry() {
        return this.m_entry;
    }
}

