/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.navigation;

import java.util.List;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.mobile.navigation.IBreadCrumb;
import org.eclipse.scout.rt.client.mobile.navigation.IBreadCrumbsNavigation;
import org.eclipse.scout.rt.client.mobile.ui.desktop.MobileDesktopUtility;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.IForm;

public class BreadCrumb
implements IBreadCrumb {
    private IForm m_form;
    private IBreadCrumbsNavigation m_breadCrumbsNavigation;

    public BreadCrumb(IBreadCrumbsNavigation breadCrumbsNavigation, IForm form) {
        this.m_breadCrumbsNavigation = breadCrumbsNavigation;
        this.m_form = form;
    }

    @Override
    public void activate() throws ProcessingException {
        this.autoCloseNavigationForms();
        if (this.getForm() != null) {
            IDesktop desktop = ClientJob.getCurrentSession().getDesktop();
            if (this.getForm().isFormOpen() && !desktop.isShowing(this.getForm())) {
                if (MobileDesktopUtility.isToolForm(this.getForm())) {
                    MobileDesktopUtility.openToolForm(this.getForm());
                } else {
                    MobileDesktopUtility.addFormToDesktop(this.getForm());
                }
            }
        }
    }

    private void autoCloseNavigationForms() throws ProcessingException {
        IDesktop desktop = ClientJob.getCurrentSession().getDesktop();
        List<IForm> currentNavigationForms = this.getBreadCrumbsNavigation().getCurrentNavigationForms();
        for (IForm form : currentNavigationForms) {
            if (form == desktop.getOutlineTableForm() || form == this.getForm() || this.getBreadCrumbsNavigation().containsFormInHistory(form)) continue;
            MobileDesktopUtility.closeForm(form);
        }
    }

    public IBreadCrumbsNavigation getBreadCrumbsNavigation() {
        return this.m_breadCrumbsNavigation;
    }

    @Override
    public IForm getForm() {
        return this.m_form;
    }

    public String toString() {
        String formName = this.getForm().getTitle();
        if (StringUtility.isNullOrEmpty((String)formName)) {
            formName = this.getForm().toString();
        }
        return "Form: " + formName;
    }

    @Override
    public boolean belongsTo(IForm form) {
        return this.getForm() == form;
    }
}

