/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.mobile.ui.action.ButtonWrappingAction;
import org.eclipse.scout.rt.client.mobile.ui.form.IMobileAction;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.AutoLeafPageWithNodes;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;

public class ActionButtonBarUtility {
    public static List<IMobileAction> convertButtonsToActions(List<IButton> buttons) throws ProcessingException {
        ArrayList<IMobileAction> menuList = new ArrayList<IMobileAction>(buttons.size());
        for (IButton button : buttons) {
            IMobileAction action = ActionButtonBarUtility.convertButtonToAction(button);
            if (action == null) continue;
            menuList.add(action);
        }
        return menuList;
    }

    public static IMobileAction convertButtonToAction(IButton button) throws ProcessingException {
        if (button == null) {
            return null;
        }
        ButtonWrappingAction mAction = new ButtonWrappingAction(button);
        mAction.initAction();
        return mAction;
    }

    public static void distributeRowActions(List<IMenu> menuList, List<IMenu> emptySpaceMenus, List<IMenu> rowMenuList) {
        if (emptySpaceMenus == null) {
            return;
        }
        for (IMenu emptySpaceMenu : emptySpaceMenus) {
            if (rowMenuList.size() == 0) break;
            int index = menuList.indexOf(emptySpaceMenu) + 1;
            IMenu rowMenu = rowMenuList.get(0);
            menuList.add(index, rowMenu);
            rowMenuList.remove(rowMenu);
        }
    }

    public static List<IMenu> fetchPageActions(IPage page) {
        LinkedList<IMenu> pageActions = new LinkedList<IMenu>();
        if (page.getTree() != null) {
            pageActions.addAll(page.getTree().fetchMenusForNodesInternal((Collection)CollectionUtility.arrayList((Object)page)));
            if (page instanceof AutoLeafPageWithNodes) {
                pageActions.addAll(((AutoLeafPageWithNodes)page).getTableRow().getTable().getUIFacade().fireRowPopupFromUI());
            }
        }
        return pageActions;
    }
}

