/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.basic.table.form;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.IHolder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.ITableRowForm;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.TableRowFormHeaderActionFetcher;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.ColumnFieldBuilder;
import org.eclipse.scout.rt.client.mobile.ui.form.AbstractMobileForm;
import org.eclipse.scout.rt.client.mobile.ui.form.IActionFetcher;
import org.eclipse.scout.rt.client.mobile.ui.form.fields.button.AbstractBackButton;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.basic.table.TableRowMapper;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.IFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public class TableRowForm
extends AbstractMobileForm
implements ITableRowForm {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TableRowForm.class);
    private ITable m_table;
    private ITableRow m_row;
    private IFormField m_rowField;
    private ColumnFieldBuilder m_columnFieldBuilder;
    private Map<IColumn<?>, IFormField> m_columnFields;
    private P_TableListener m_tableListener;
    private TableRowMapper m_rowMapper;

    public TableRowForm(ITableRow row) throws ProcessingException {
        this(row, null);
    }

    public TableRowForm(ITableRow row, IFormField rowField) throws ProcessingException {
        super(false);
        this.m_row = row;
        this.m_rowField = rowField;
        this.m_table = row.getTable();
        this.m_columnFields = new HashMap();
        if (this.m_rowField == null) {
            this.m_columnFieldBuilder = this.createColumnFieldBuilder();
            this.m_columnFields = this.m_columnFieldBuilder.build(this.getTable().getColumns(), row);
        }
        this.callInitializer();
        this.m_tableListener = new P_TableListener();
        this.getTable().addTableListener((TableListener)this.m_tableListener);
    }

    protected void execDisposeForm() throws ProcessingException {
        this.getTable().removeTableListener((TableListener)this.m_tableListener);
        if (this.m_columnFields != null) {
            for (IFormField formField : this.m_columnFields.values()) {
                this.m_columnFieldBuilder.fieldDisposed(formField);
            }
        }
    }

    protected ColumnFieldBuilder createColumnFieldBuilder() {
        return new ColumnFieldBuilder();
    }

    public ITable getTable() {
        return this.m_table;
    }

    public ITableRow getRow() {
        return this.m_row;
    }

    protected int getConfiguredDisplayHint() {
        return 20;
    }

    protected String getConfiguredDisplayViewId() {
        return "PAGE_DETAIL";
    }

    @Override
    protected IActionFetcher createHeaderActionFetcher() {
        return new TableRowFormHeaderActionFetcher(this, this.getTable());
    }

    @Override
    public void start() throws ProcessingException {
        this.startInternal((IFormHandler)new FormHandler());
    }

    private void handleRowDeleted() {
        try {
            this.doClose();
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    private void handleRowUpdated() {
        this.m_rowMapper.exportRowData();
    }

    @Order(value=10.0)
    public class FormHandler
    extends AbstractFormHandler {
        protected void execLoad() throws ProcessingException {
            TableRowForm.this.m_rowMapper = new TableRowMapper(TableRowForm.this.getRow());
            for (IColumn column : TableRowForm.this.m_columnFields.keySet()) {
                IFormField field = (IFormField)TableRowForm.this.m_columnFields.get(column);
                if (!(field instanceof IValueField)) continue;
                IValueField valueField = (IValueField)field;
                TableRowForm.this.m_rowMapper.addMapping(column, (IHolder)valueField);
                valueField.addPropertyChangeListener((PropertyChangeListener)new P_ValueFieldListener(column));
            }
            TableRowForm.this.m_rowMapper.exportRowData();
        }
    }

    @Order(value=10.0)
    public class MainBox
    extends AbstractGroupBox {
        protected void injectFieldsInternal(List<IFormField> fieldList) {
            if (TableRowForm.this.m_rowField != null) {
                fieldList.add(TableRowForm.this.m_rowField);
            } else {
                fieldList.add((IFormField)new P_ColumnFieldsGroupBox());
            }
            super.injectFieldsInternal(fieldList);
        }

        @Order(value=5.0)
        public class BackButton
        extends AbstractBackButton {
        }
    }

    private class P_ColumnFieldsGroupBox
    extends AbstractGroupBox {
        private P_ColumnFieldsGroupBox() {
        }

        protected void injectFieldsInternal(List<IFormField> fieldList) {
            for (IColumn column : TableRowForm.this.getTable().getColumns()) {
                IFormField field = (IFormField)TableRowForm.this.m_columnFields.get(column);
                if (field == null) continue;
                fieldList.add(field);
            }
            super.injectFieldsInternal(fieldList);
        }
    }

    private class P_TableListener
    extends TableAdapter {
        private P_TableListener() {
        }

        public void tableChanged(TableEvent e) {
            List rows = e.getRows();
            if (rows == null) {
                return;
            }
            for (ITableRow row : rows) {
                if (!TableRowForm.this.getRow().equals(row)) continue;
                switch (e.getType()) {
                    case 102: 
                    case 105: {
                        TableRowForm.this.handleRowDeleted();
                        break;
                    }
                    case 101: {
                        TableRowForm.this.handleRowUpdated();
                    }
                }
            }
        }
    }

    private class P_ValueFieldListener
    implements PropertyChangeListener {
        private IColumn<?> m_column;

        public P_ValueFieldListener(IColumn<?> column) {
            this.m_column = column;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                if (!this.m_column.isEditable()) {
                    return;
                }
                IValueField field = (IValueField)evt.getSource();
                if ("value".equals(evt.getPropertyName())) {
                    this.m_column.completeEdit(TableRowForm.this.getRow(), (IFormField)field);
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
    }
}

