/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.BooleanHolder;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;

public final class ActionUtility {
    public static <T extends IAction> List<T> visibleNormalizedActions(List<T> actionNodes) {
        if (actionNodes == null) {
            return CollectionUtility.emptyArrayList();
        }
        List<T> cleanedActions = ActionUtility.getVisibleActions(actionNodes);
        IAction prevSeparator = null;
        IAction prevAction = null;
        ListIterator<T> it = cleanedActions.listIterator();
        while (it.hasNext()) {
            IAction actionNode = (IAction)it.next();
            if (actionNode.isSeparator()) {
                if (prevAction == null || prevSeparator != null) {
                    it.remove();
                }
                prevAction = null;
                prevSeparator = actionNode;
                continue;
            }
            prevSeparator = null;
            prevAction = actionNode;
        }
        while (it.hasPrevious()) {
            IAction previous = (IAction)it.previous();
            if (!previous.isSeparator()) break;
            it.remove();
        }
        return cleanedActions;
    }

    public static <T extends IAction> List<T> getVisibleActions(List<T> actions) {
        if (actions != null) {
            ArrayList<IAction> result = new ArrayList<IAction>(actions.size());
            for (IAction a : actions) {
                if (a instanceof IActionNode) {
                    final BooleanHolder visibleHolder = new BooleanHolder(Boolean.valueOf(false));
                    a.acceptVisitor(new IActionVisitor(){

                        @Override
                        public int visit(IAction action) {
                            if (action instanceof IActionNode && ((IActionNode)action).hasChildActions()) {
                                return 1;
                            }
                            if (action.isVisible()) {
                                visibleHolder.setValue((Object)true);
                                return 0;
                            }
                            return 1;
                        }
                    });
                    if (!((Boolean)visibleHolder.getValue()).booleanValue()) continue;
                    result.add(a);
                    continue;
                }
                if (!a.isVisible()) continue;
                result.add(a);
            }
            return result;
        }
        return CollectionUtility.emptyArrayList();
    }

    public static void initActions(List<? extends IAction> actions) throws ProcessingException {
        InitActionVisitor v = new InitActionVisitor();
        for (IAction iAction : actions) {
            iAction.acceptVisitor(v);
        }
        v.handleResult();
    }

    private static class InitActionVisitor
    implements IActionVisitor {
        private ProcessingException m_firstEx;

        private InitActionVisitor() {
        }

        @Override
        public int visit(IAction action) {
            block4: {
                try {
                    action.initAction();
                }
                catch (ProcessingException e) {
                    if (this.m_firstEx == null) {
                        this.m_firstEx = e;
                    }
                }
                catch (Throwable t) {
                    if (this.m_firstEx != null) break block4;
                    this.m_firstEx = new ProcessingException("Unexpected", t);
                }
            }
            return 1;
        }

        public void handleResult() throws ProcessingException {
            if (this.m_firstEx != null) {
                throw this.m_firstEx;
            }
        }
    }
}

