/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;

public abstract class AbstractContextMenu
extends AbstractMenu
implements IContextMenu {
    private PropertyChangeListener m_menuVisibilityListener = new P_VisibilityOfMenuItemChangedListener();

    public AbstractContextMenu() {
    }

    public AbstractContextMenu(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.calculateVisibility();
    }

    @Override
    protected void execOwnerValueChanged(Object newOwnerValue) throws ProcessingException {
    }

    @Override
    public void setChildActions(List<? extends IMenu> newList) {
        this.updateChildActions(newList);
    }

    protected void updateChildActions(List<? extends IMenu> newList) {
        this.updatePropertyListeners(newList);
        super.setChildActions(newList);
        this.calculateVisibility();
    }

    private void updatePropertyListeners(List<? extends IMenu> newList) {
        this.removeScoutMenuVisibilityListenerRec(this.getChildActions());
        if (newList != null) {
            this.addScoutMenuVisibilityListenerRec(newList);
        }
    }

    protected void addScoutMenuVisibilityListenerRec(List<? extends IMenu> menus) {
        for (IMenu iMenu : menus) {
            iMenu.addPropertyChangeListener("visible", this.m_menuVisibilityListener);
            this.addScoutMenuVisibilityListenerRec(iMenu.getChildActions());
        }
    }

    protected void removeScoutMenuVisibilityListenerRec(List<? extends IMenu> menus) {
        for (IMenu iMenu : menus) {
            iMenu.removePropertyChangeListener("visible", this.m_menuVisibilityListener);
            this.removeScoutMenuVisibilityListenerRec(iMenu.getChildActions());
        }
    }

    private void calculateVisibility() {
        List visibleChildMenus = ActionUtility.visibleNormalizedActions(this.getChildActions());
        this.setVisible(CollectionUtility.hasElements(visibleChildMenus));
    }

    private class P_VisibilityOfMenuItemChangedListener
    implements PropertyChangeListener {
        private P_VisibilityOfMenuItemChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("visible".equals(evt.getPropertyName())) {
                AbstractContextMenu.this.calculateVisibility();
            }
        }
    }
}

