/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.tree.AbstractActionNode;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;

public abstract class AbstractMenu
extends AbstractActionNode<IMenu>
implements IMenu {
    private boolean m_singleSelectionAction;
    private boolean m_multiSelectionAction;
    private boolean m_emptySpaceAction;

    public AbstractMenu() {
    }

    public AbstractMenu(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=60.0)
    protected boolean getConfiguredSingleSelectionAction() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=70.0)
    protected boolean getConfiguredMultiSelectionAction() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=90.0)
    protected boolean getConfiguredEmptySpaceAction() {
        return false;
    }

    @Override
    public void handleOwnerValueChanged(Object newValue) throws ProcessingException {
        this.execOwnerValueChanged(newValue);
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execOwnerValueChanged(Object newOwnerValue) throws ProcessingException {
        if (this.hasChildActions()) {
            return;
        }
        boolean visible = false;
        if (newOwnerValue instanceof Collection) {
            Collection collectionValue = (Collection)newOwnerValue;
            if (this.isEmptySpaceAction()) {
                visible = collectionValue.isEmpty();
            } else {
                Collection<ITableRow> rows = this.convertToTableRows(collectionValue);
                boolean allEnabled = true;
                if (rows != null) {
                    for (ITableRow r : rows) {
                        if (r.isEnabled()) continue;
                        allEnabled = false;
                        break;
                    }
                    if (this.isSingleSelectionAction() && allEnabled) {
                        boolean bl = visible = collectionValue.size() == 1;
                    }
                    if (this.isMultiSelectionAction() && allEnabled) {
                        visible = collectionValue.size() > 1;
                    }
                }
            }
        } else {
            if (this.isSingleSelectionAction()) {
                boolean bl = visible = newOwnerValue != null;
            }
            if (this.isMultiSelectionAction()) {
                boolean bl = visible = newOwnerValue != null;
            }
            if (this.isEmptySpaceAction()) {
                visible = newOwnerValue == null;
            }
        }
        this.setVisible(visible);
    }

    protected Collection<ITableRow> convertToTableRows(Collection<?> input) {
        if (input == null) {
            return null;
        }
        ArrayList<ITableRow> rows = new ArrayList<ITableRow>(input.size());
        for (Object o : input) {
            if (!(o instanceof ITableRow)) continue;
            rows.add((ITableRow)o);
        }
        if (rows.size() == input.size()) {
            return rows;
        }
        return null;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setSingleSelectionAction(this.getConfiguredSingleSelectionAction());
        this.setMultiSelectionAction(this.getConfiguredMultiSelectionAction());
        this.setEmptySpaceAction(this.getConfiguredEmptySpaceAction());
        if (!(this.isSingleSelectionAction() || this.isMultiSelectionAction() || this.isEmptySpaceAction())) {
            this.setEmptySpaceAction(true);
        }
    }

    @Override
    @Deprecated
    public boolean isSingleSelectionAction() {
        return this.m_singleSelectionAction;
    }

    @Override
    @Deprecated
    public void setSingleSelectionAction(boolean b) {
        this.m_singleSelectionAction = b;
    }

    @Override
    @Deprecated
    public boolean isMultiSelectionAction() {
        return this.m_multiSelectionAction;
    }

    @Override
    @Deprecated
    public void setMultiSelectionAction(boolean b) {
        this.m_multiSelectionAction = b;
    }

    @Override
    @Deprecated
    public boolean isEmptySpaceAction() {
        return this.m_emptySpaceAction;
    }

    @Override
    @Deprecated
    public void setEmptySpaceAction(boolean b) {
        this.m_emptySpaceAction = b;
    }
}

