/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractPropertyObserverContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public class TableContextMenu
extends AbstractPropertyObserverContextMenu<ITable> {
    public TableContextMenu(ITable owner) {
        super(owner);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        ((ITable)this.getOwner()).addTableListener(new P_OwnerTableListener());
        this.handleOwnerEnabledChanged();
        this.handleOwnerValueChanged();
    }

    @Override
    protected void updateChildActions(List<? extends IMenu> newList) {
        super.updateChildActions(newList);
        this.handleOwnerEnabledChanged();
        this.handleOwnerValueChanged();
    }

    protected void handleOwnerEnabledChanged() {
        if (this.getOwner() != null) {
            final boolean enabled = ((ITable)this.getOwner()).isEnabled();
            this.acceptVisitor(new IActionVisitor(){

                @Override
                public int visit(IAction action) {
                    IMenu menu;
                    if (action instanceof IMenu && !(menu = (IMenu)action).hasChildActions() && menu.isInheritAccessibility()) {
                        menu.setEnabled(enabled);
                    }
                    return 1;
                }
            });
        }
    }

    protected void handleOwnerValueChanged() {
        if (this.getOwner() != null) {
            final List<ITableRow> ownerValue = ((ITable)this.getOwner()).getSelectedRows();
            this.acceptVisitor(new IActionVisitor(){

                @Override
                public int visit(IAction action) {
                    if (action instanceof IMenu) {
                        IMenu menu = (IMenu)action;
                        try {
                            menu.handleOwnerValueChanged(ownerValue);
                        }
                        catch (ProcessingException ex) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                        }
                    }
                    return 1;
                }
            });
        }
    }

    @Override
    protected void handleOwnerPropertyChanged(PropertyChangeEvent evt) {
        if ("enabled".equals(evt.getPropertyName())) {
            this.handleOwnerEnabledChanged();
        }
    }

    private class P_OwnerTableListener
    extends TableAdapter {
        private P_OwnerTableListener() {
        }

        @Override
        public void tableChanged(TableEvent e) {
            if (e.getType() == 103) {
                TableContextMenu.this.handleOwnerValueChanged();
            }
        }
    }
}

