/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.calendar;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.Range;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarEvent;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarItemConflict;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarListener;
import org.eclipse.scout.rt.client.ui.basic.calendar.DateTimeFormatFactory;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendarUIFacade;
import org.eclipse.scout.rt.client.ui.basic.calendar.provider.ICalendarItemProvider;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractCalendar
extends AbstractPropertyObserver
implements ICalendar {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractCalendar.class);
    private boolean m_initialized;
    private List<IMenu> m_menus;
    private List<ICalendarItemProvider> m_providers;
    private final HashMap<Class<? extends ICalendarItemProvider>, Collection<CalendarComponent>> m_componentsByProvider;
    private ICalendarUIFacade m_uiFacade;
    private int m_calendarChanging;
    private final DateTimeFormatFactory m_dateTimeFormatFactory;
    private List<CalendarEvent> m_calendarEventBuffer = new ArrayList<CalendarEvent>();
    private final EventListenerList m_listenerList = new EventListenerList();

    public AbstractCalendar() {
        this(true);
    }

    public AbstractCalendar(boolean callInitializer) {
        this.m_dateTimeFormatFactory = new DateTimeFormatFactory();
        this.m_componentsByProvider = new HashMap();
        if (callInitializer) {
            this.initConfig();
        }
    }

    protected void callInitializer() {
        if (!this.m_initialized) {
            this.initConfig();
            this.m_initialized = true;
        }
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    protected String getConfiguredTitle() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=500.0)
    protected int getConfiguredStartHour() {
        return 6;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=510.0)
    protected int getConfiguredEndHour() {
        return 19;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=520.0)
    protected boolean getConfiguredUseOverflowCells() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=530.0)
    protected boolean getConfiguredShowDisplayModeSelection() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=540.0)
    protected boolean getConfiguredMarkNoonHour() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=550.0)
    protected boolean getConfiguredMarkOutOfMonthDays() {
        return true;
    }

    private List<Class<? extends ICalendarItemProvider>> getConfiguredProducers() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, ICalendarItemProvider.class);
        List foca = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((List)filtered, ICalendarItemProvider.class);
        return ConfigurationUtility.removeReplacedClasses((List)foca);
    }

    protected List<Class<? extends IMenu>> getDeclaredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IMenu.class);
        List foca = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((List)filtered, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((List)foca);
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitCalendar() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=15.0)
    protected void execDisposeCalendar() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execFilterCalendarItems(Set<Class<? extends ICalendarItemProvider>> changedProviderTypes, Map<Class<? extends ICalendarItemProvider>, Collection<CalendarComponent>> componentsByProvider) {
    }

    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        this.setTitle(this.getConfiguredTitle());
        this.setSelectedDate(new Date());
        this.setStartHour(this.getConfiguredStartHour());
        this.setEndHour(this.getConfiguredEndHour());
        this.setUseOverflowCells(this.getConfiguredUseOverflowCells());
        this.setShowDisplayModeSelection(this.getConfiguredShowDisplayModeSelection());
        this.setMarkNoonHour(this.getConfiguredMarkNoonHour());
        this.setMarkOutOfMonthDays(this.getConfiguredMarkOutOfMonthDays());
        ArrayList<IMenu> menuList = new ArrayList<IMenu>();
        for (Class<? extends IMenu> menuClazz : this.getDeclaredMenus()) {
            try {
                IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, menuClazz);
                menuList.add(menu);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
        }
        try {
            this.injectMenusInternal(menuList);
        }
        catch (Exception e) {
            LOG.error("error occured while dynamically contributing menus.", (Throwable)e);
        }
        this.m_menus = menuList;
        ArrayList<ICalendarItemProvider> producerList = new ArrayList<ICalendarItemProvider>();
        for (Class<? extends ICalendarItemProvider> itemProviderClazz : this.getConfiguredProducers()) {
            try {
                producerList.add((ICalendarItemProvider)ConfigurationUtility.newInnerInstance((Object)this, itemProviderClazz));
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
        }
        this.m_providers = producerList;
        for (final ICalendarItemProvider p : this.m_providers) {
            p.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("items")) {
                        ArrayList<ICalendarItemProvider> modified = new ArrayList<ICalendarItemProvider>(1);
                        modified.add(p);
                        AbstractCalendar.this.updateComponentsInternal(modified);
                    } else if (e.getPropertyName().equals("loadInProgress")) {
                        AbstractCalendar.this.updateLoadInProgressInternal();
                    }
                }
            });
        }
    }

    protected void injectMenusInternal(List<IMenu> menuList) {
    }

    @Override
    public void initCalendar() throws ProcessingException {
        ActionUtility.initActions(this.m_menus);
        this.execInitCalendar();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("viewRange")) {
                    AbstractCalendar.this.updateComponentsInternal(AbstractCalendar.this.m_providers);
                }
            }
        });
        this.updateComponentsInternal(this.m_providers);
    }

    private void disposeCalendarInternal() {
        for (ICalendarItemProvider p : this.m_providers) {
            try {
                p.disposeProvider();
            }
            catch (Throwable t) {
                LOG.warn(p.getClass().getName(), t);
            }
        }
    }

    @Override
    public void disposeCalendar() {
        this.disposeCalendarInternal();
        try {
            this.execDisposeCalendar();
        }
        catch (Throwable t) {
            LOG.warn(this.getClass().getName(), t);
        }
    }

    @Override
    public String getTitle() {
        return this.propertySupport.getPropertyString("title");
    }

    @Override
    public void setTitle(String s) {
        this.propertySupport.setPropertyString("title", s);
    }

    @Override
    public int getEndHour() {
        return (Integer)this.propertySupport.getProperty("endHour");
    }

    @Override
    public void setEndHour(int hour) {
        this.propertySupport.setProperty("endHour", (Object)hour);
    }

    @Override
    public int getStartHour() {
        return (Integer)this.propertySupport.getProperty("startHour");
    }

    @Override
    public void setStartHour(int hour) {
        this.propertySupport.setProperty("startHour", (Object)hour);
    }

    @Override
    public boolean getUseOverflowCells() {
        return (Boolean)this.propertySupport.getProperty("useOverflowCells");
    }

    @Override
    public void setUseOverflowCells(boolean useOverflowCells) {
        this.propertySupport.setProperty("useOverflowCells", (Object)useOverflowCells);
    }

    @Override
    public boolean getShowDisplayModeSelection() {
        return (Boolean)this.propertySupport.getProperty("showDisplayModeSelection");
    }

    @Override
    public void setShowDisplayModeSelection(boolean showDisplayModeSelection) {
        this.propertySupport.setProperty("showDisplayModeSelection", (Object)showDisplayModeSelection);
    }

    @Override
    public boolean getMarkNoonHour() {
        return (Boolean)this.propertySupport.getProperty("markNoonHour");
    }

    @Override
    public void setMarkNoonHour(boolean markNoonHour) {
        this.propertySupport.setProperty("markNoonHour", (Object)markNoonHour);
    }

    @Override
    public boolean getMarkOutOfMonthDays() {
        return (Boolean)this.propertySupport.getProperty("markOutOfMonthDays");
    }

    @Override
    public void setMarkOutOfMonthDays(boolean markOutOfMonthDays) {
        this.propertySupport.setProperty("markOutOfMonthDays", (Object)markOutOfMonthDays);
    }

    @Override
    public boolean isLoadInProgress() {
        return this.propertySupport.getPropertyBool("loadInProgress");
    }

    @Override
    public void setLoadInProgress(boolean b) {
        this.propertySupport.setPropertyBool("loadInProgress", b);
    }

    @Override
    public boolean isCalendarChanging() {
        return this.m_calendarChanging > 0;
    }

    @Override
    public void setCalendarChanging(boolean b) {
        if (b) {
            ++this.m_calendarChanging;
            if (this.m_calendarChanging == 1) {
                this.propertySupport.setPropertiesChanging(true);
            }
        } else if (this.m_calendarChanging > 0) {
            --this.m_calendarChanging;
            if (this.m_calendarChanging == 0) {
                try {
                    this.processChangeBuffer();
                }
                finally {
                    this.propertySupport.setPropertiesChanging(false);
                }
            }
        }
    }

    private void processChangeBuffer() {
        this.m_calendarEventBuffer = new ArrayList<CalendarEvent>();
        HashSet<Integer> types = new HashSet<Integer>();
        LinkedList<CalendarEvent> coalescedEvents = new LinkedList<CalendarEvent>();
        CalendarEvent[] a = this.m_calendarEventBuffer.toArray(new CalendarEvent[0]);
        int i = a.length - 1;
        while (i >= 0) {
            switch (a[i].getType()) {
                case 20: {
                    if (types.contains(a[i].getType())) break;
                    coalescedEvents.add(0, a[i]);
                    types.add(a[i].getType());
                    break;
                }
                default: {
                    coalescedEvents.add(0, a[i]);
                }
            }
            --i;
        }
        this.fireCalendarEventBatchInternal(coalescedEvents);
    }

    @Override
    public List<IMenu> getMenus() {
        return CollectionUtility.arrayList(this.m_menus);
    }

    @Override
    public List<ICalendarItemProvider> getCalendarItemProviders() {
        return CollectionUtility.arrayList(this.m_providers);
    }

    @Override
    public int getDisplayMode() {
        return this.propertySupport.getPropertyInt("displayMode");
    }

    @Override
    public void setDisplayMode(int mode) {
        this.propertySupport.setPropertyInt("displayMode", mode);
    }

    @Override
    public boolean isDisplayCondensed() {
        return this.propertySupport.getPropertyBool("displayCondensed");
    }

    @Override
    public void setDisplayCondensed(boolean condensed) {
        this.propertySupport.setPropertyBool("displayCondensed", condensed);
    }

    @Override
    public Range<Date> getViewRange() {
        Range propValue = (Range)this.propertySupport.getProperty("viewRange");
        return new Range(propValue);
    }

    @Override
    public void setViewRange(Date minDate, Date maxDate) {
        this.setViewRangeInternal((Range<Date>)new Range((Object)minDate, (Object)maxDate));
    }

    @Override
    public void setViewRange(Range<Date> viewRange) {
        this.setViewRangeInternal((Range<Date>)new Range(viewRange));
    }

    private void setViewRangeInternal(Range<Date> viewRange) {
        this.propertySupport.setProperty("viewRange", viewRange);
    }

    @Override
    public Date getSelectedDate() {
        return (Date)this.propertySupport.getProperty("selectedDate");
    }

    @Override
    public void setSelectedDate(Date d) {
        this.propertySupport.setProperty("selectedDate", (Object)d);
    }

    @Override
    public CalendarComponent getSelectedComponent() {
        return (CalendarComponent)this.propertySupport.getProperty("selectedComponent");
    }

    @Override
    public <T extends ICalendarItem> T getSelectedItem(Class<T> c) {
        CalendarComponent comp = this.getSelectedComponent();
        if (comp != null && comp.getItem() != null && c.isAssignableFrom(comp.getItem().getClass())) {
            return (T)comp.getItem();
        }
        return null;
    }

    @Override
    public void setSelectedComponent(CalendarComponent comp) {
        comp = this.resolveComponent(comp);
        this.propertySupport.setProperty("selectedComponent", (Object)comp);
    }

    private CalendarComponent resolveComponent(CalendarComponent comp) {
        return comp;
    }

    @Override
    public DateTimeFormatFactory getDateTimeFormatFactory() {
        return this.m_dateTimeFormatFactory;
    }

    public Set<CalendarComponent> getComponents() {
        return CollectionUtility.hashSet((Collection)this.propertySupport.getPropertySet("components"));
    }

    private void updateComponentsInternal(List<ICalendarItemProvider> changedProviders) {
        Range<Date> d = this.getViewRange();
        if (d.getFrom() != null && d.getTo() != null) {
            for (ICalendarItemProvider p : changedProviders) {
                LinkedList components = new LinkedList();
                for (ICalendarItem iCalendarItem : p.getItems((Date)d.getFrom(), (Date)d.getTo())) {
                    Cell cell = new Cell();
                    p.decorateCell(cell, iCalendarItem);
                    components.add(new CalendarComponent(this, p, iCalendarItem, cell));
                }
                this.m_componentsByProvider.put(p.getClass(), components);
            }
            HashSet<Class<? extends ICalendarItemProvider>> providerTypes = new HashSet<Class<? extends ICalendarItemProvider>>(changedProviders.size());
            for (ICalendarItemProvider provider : changedProviders) {
                providerTypes.add(provider.getClass());
            }
            this.execFilterCalendarItems(providerTypes, this.m_componentsByProvider);
            TreeMap<CompositeObject, CalendarComponent> sortMap = new TreeMap<CompositeObject, CalendarComponent>();
            int index = 0;
            for (Collection collection : this.m_componentsByProvider.values()) {
                for (CalendarComponent comp : collection) {
                    sortMap.put(new CompositeObject(new Object[]{comp.getFromDate(), index++}), comp);
                }
            }
            this.propertySupport.setPropertySet("components", (Set)CollectionUtility.hashSet(sortMap.values()));
            this.setSelectedComponent(this.getSelectedComponent());
        }
    }

    @Override
    public Object getContainer() {
        return this.propertySupport.getProperty("container");
    }

    public void setContainerInternal(Object container) {
        this.propertySupport.setProperty("container", container);
    }

    public Collection<CalendarItemConflict> findConflictingItems(Map<Class<? extends ICalendarItemProvider>, Collection<CalendarComponent>> componentsByProvider, Class<?> ... providerTypes) {
        if (providerTypes != null && providerTypes.length >= 2) {
            HashMap<String, ArrayList<CalendarComponent>> classificationMap = new HashMap<String, ArrayList<CalendarComponent>>();
            int i = 0;
            while (i < providerTypes.length) {
                Collection<CalendarComponent> a = componentsByProvider.get(providerTypes[i]);
                if (a != null) {
                    for (CalendarComponent comp : a) {
                        String key = StringUtility.emptyIfNull((Object)comp.getItem().getSubject()).toLowerCase().trim();
                        ArrayList<CalendarComponent> list = (ArrayList<CalendarComponent>)classificationMap.get(key);
                        if (list == null) {
                            list = new ArrayList<CalendarComponent>();
                            classificationMap.put(key, list);
                        }
                        list.add(comp);
                    }
                }
                ++i;
            }
            ArrayList<CalendarItemConflict> conflicts = new ArrayList<CalendarItemConflict>();
            for (Map.Entry e : classificationMap.entrySet()) {
                if (((List)e.getValue()).size() < 2) continue;
                List list = (List)e.getValue();
                HashMap groups = new HashMap();
                for (CalendarComponent c : list) {
                    if (groups.containsKey(c.getProvider())) {
                        ((ArrayList)groups.get(c.getProvider())).add(c);
                        continue;
                    }
                    ArrayList<CalendarComponent> tmp = new ArrayList<CalendarComponent>();
                    tmp.add(c);
                    groups.put(c.getProvider(), tmp);
                }
                ArrayList<CalendarComponent> groupComp = new ArrayList<CalendarComponent>();
                for (ArrayList g : groups.values()) {
                    if (g.size() <= 1) continue;
                    groupComp.addAll(g);
                }
                if (groupComp.size() == 0) {
                    groupComp.add((CalendarComponent)list.get(0));
                }
                for (CalendarComponent ref : groupComp) {
                    ArrayList<CalendarComponent> matchList = new ArrayList<CalendarComponent>();
                    double matchSum = 0.0;
                    matchList.add(ref);
                    for (CalendarComponent test : list) {
                        if (ref == test || test.getProvider() == ref.getProvider() || !DateUtility.intersects((Date)test.getFromDate(), (Date)test.getToDate(), (Date)ref.getFromDate(), (Date)ref.getToDate())) continue;
                        matchList.add(test);
                        double minOfStart = Math.min(test.getFromDate().getTime(), ref.getFromDate().getTime());
                        double maxOfStart = Math.max(test.getFromDate().getTime(), ref.getFromDate().getTime());
                        double minOfEnd = Math.min(test.getToDate().getTime(), ref.getToDate().getTime());
                        double maxOfEnd = Math.max(test.getToDate().getTime(), ref.getToDate().getTime());
                        if (maxOfEnd - minOfStart > 1.0E-6) {
                            matchSum += (minOfEnd - maxOfStart) / (maxOfEnd - minOfStart);
                            continue;
                        }
                        matchSum += 1.0;
                    }
                    if (matchList.size() < 2) continue;
                    conflicts.add(new CalendarItemConflict(componentsByProvider, matchList, matchSum / (double)(matchList.size() - 1)));
                }
            }
            return conflicts;
        }
        return CollectionUtility.emptyArrayList();
    }

    private void updateLoadInProgressInternal() {
        boolean b = false;
        for (ICalendarItemProvider p : this.m_providers) {
            if (!p.isLoadInProgress()) continue;
            b = true;
            break;
        }
        this.setLoadInProgress(b);
    }

    @Override
    public void reloadCalendarItems() {
        for (ICalendarItemProvider p : this.m_providers) {
            p.reloadProvider();
        }
    }

    private List<IMenu> fireComponentPopup(CalendarComponent comp) {
        if (comp != null) {
            CalendarEvent e = new CalendarEvent(this, 30, comp);
            this.addComponentPopupMenus(e, comp);
            this.fireCalendarEventInternal(e);
            return e.getPopupMenus();
        }
        return CollectionUtility.emptyArrayList();
    }

    private void addComponentPopupMenus(CalendarEvent e, CalendarComponent comp) {
        for (IMenu menu : this.m_menus) {
            if (!menu.isSingleSelectionAction()) continue;
            menu.prepareAction();
            if (!menu.isVisible()) continue;
            e.addPopupMenu(menu);
        }
        for (IMenu menu : comp.getProvider().getMenus()) {
            if (!menu.isSingleSelectionAction()) continue;
            menu.prepareAction();
            if (!menu.isVisible()) continue;
            e.addPopupMenu(menu);
        }
    }

    private List<IMenu> fireNewPopup() {
        CalendarEvent e = new CalendarEvent(this, 31);
        this.addNewPopupMenus(e);
        this.fireCalendarEventInternal(e);
        return e.getPopupMenus();
    }

    private void addNewPopupMenus(CalendarEvent e) {
        for (IMenu menu : this.m_menus) {
            if (menu.isSingleSelectionAction()) continue;
            menu.prepareAction();
            if (!menu.isVisible()) continue;
            e.addPopupMenu(menu);
        }
        for (ICalendarItemProvider p : this.m_providers) {
            for (IMenu menu : p.getMenus()) {
                if (menu.isSingleSelectionAction()) continue;
                menu.prepareAction();
                if (!menu.isVisible()) continue;
                e.addPopupMenu(menu);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addCalendarListener(CalendarListener listener) {
        this.m_listenerList.add(CalendarListener.class, (EventListener)listener);
    }

    @Override
    public void removeCalendarListener(CalendarListener listener) {
        this.m_listenerList.remove(CalendarListener.class, (EventListener)listener);
    }

    private void fireCalendarComponentAction() {
        CalendarComponent comp = this.getSelectedComponent();
        if (comp != null) {
            try {
                comp.getProvider().onItemAction(comp.getItem());
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
            this.fireCalendarEventInternal(new CalendarEvent(this, 20, comp));
        }
    }

    private void fireCalendarEventInternal(CalendarEvent e) {
        if (this.isCalendarChanging()) {
            this.m_calendarEventBuffer.add(e);
        } else {
            EventListener[] listeners = this.m_listenerList.getListeners(CalendarListener.class);
            if (listeners != null && listeners.length > 0) {
                int i = 0;
                while (i < listeners.length) {
                    ((CalendarListener)listeners[i]).calendarChanged(e);
                    ++i;
                }
            }
        }
    }

    private void fireCalendarEventBatchInternal(List<CalendarEvent> batch) {
        if (this.isCalendarChanging()) {
            LOG.error("Illegal State: firing a event batch while calendar is changing");
        } else {
            EventListener[] listeners = this.m_listenerList.getListeners(CalendarListener.class);
            if (listeners != null && listeners.length > 0) {
                int i = 0;
                while (i < listeners.length) {
                    ((CalendarListener)listeners[i]).calendarChangedBatch(batch);
                    ++i;
                }
            }
        }
    }

    @Override
    public ICalendarUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    private class P_UIFacade
    implements ICalendarUIFacade {
        private int m_uiProcessorCount = 0;

        private P_UIFacade() {
        }

        protected void pushUIProcessor() {
            ++this.m_uiProcessorCount;
        }

        protected void popUIProcessor() {
            --this.m_uiProcessorCount;
        }

        @Override
        public boolean isUIProcessing() {
            return this.m_uiProcessorCount > 0;
        }

        @Override
        public void setSelectionFromUI(Date d, CalendarComponent comp) {
            try {
                this.pushUIProcessor();
                AbstractCalendar.this.setSelectedDate(d);
                AbstractCalendar.this.setSelectedComponent(comp);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setVisibleRangeFromUI(Range<Date> dateRange) {
            this.setVisibleRangeFromUI((Date)dateRange.getFrom(), (Date)dateRange.getTo());
        }

        @Override
        public void setVisibleRangeFromUI(Date minDate, Date maxDate) {
            try {
                this.pushUIProcessor();
                AbstractCalendar.this.setViewRange(minDate, maxDate);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireReloadFromUI() {
            try {
                this.pushUIProcessor();
                AbstractCalendar.this.reloadCalendarItems();
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public List<IMenu> fireComponentPopupFromUI() {
            try {
                this.pushUIProcessor();
                List list = AbstractCalendar.this.fireComponentPopup(AbstractCalendar.this.getSelectedComponent());
                return list;
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public List<IMenu> fireNewPopupFromUI() {
            try {
                this.pushUIProcessor();
                List list = AbstractCalendar.this.fireNewPopup();
                return list;
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireComponentActionFromUI() {
            try {
                this.pushUIProcessor();
                AbstractCalendar.this.fireCalendarComponentAction();
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireComponentMovedFromUI(CalendarComponent comp, Date newDate) {
            try {
                this.pushUIProcessor();
                comp = AbstractCalendar.this.resolveComponent(comp);
                if (comp != null) {
                    try {
                        comp.getProvider().onItemMoved(comp.getItem(), newDate);
                    }
                    catch (ProcessingException e) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                    }
                    catch (Throwable e) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", e));
                    }
                }
                AbstractCalendar.this.fireCalendarComponentAction();
            }
            finally {
                this.popUIProcessor();
            }
        }
    }
}

