/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.calendar;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar;
import org.eclipse.scout.rt.client.ui.basic.calendar.provider.ICalendarItemProvider;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarAppointment;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarTask;

public class CalendarComponent
implements Comparable<CalendarComponent> {
    private ICalendar m_calendar;
    private ICalendarItemProvider m_producer;
    private ICalendarItem m_item;
    private ICell m_cell;
    private Date m_fromDate;
    private Date m_toDate;
    private Date[] m_coveredDays;
    private boolean m_fullDay;

    protected CalendarComponent(ICalendar calendar, ICalendarItemProvider producer, ICalendarItem item, ICell cell) {
        ICalendarTask task;
        ICalendarAppointment app;
        this.m_calendar = calendar;
        this.m_producer = producer;
        this.m_item = item;
        this.m_cell = cell;
        Date d = null;
        if (this.m_item instanceof ICalendarAppointment) {
            app = (ICalendarAppointment)this.m_item;
            d = DateUtility.min((Date[])new Date[]{app.getStart(), app.getEnd()});
        }
        if (this.m_item instanceof ICalendarTask) {
            task = (ICalendarTask)this.m_item;
            d = DateUtility.min((Date[])new Date[]{task.getStart(), task.getDue(), task.getComplete()});
        }
        if (d == null) {
            d = new Date(0L);
        }
        this.m_fromDate = d;
        d = null;
        if (this.m_item instanceof ICalendarAppointment) {
            app = (ICalendarAppointment)this.m_item;
            d = DateUtility.max((Date[])new Date[]{app.getStart(), app.getEnd()});
        }
        if (this.m_item instanceof ICalendarTask) {
            task = (ICalendarTask)this.m_item;
            d = DateUtility.max((Date[])new Date[]{task.getStart(), task.getDue(), task.getComplete()});
        }
        if (d == null) {
            d = new Date(0L);
        }
        this.m_toDate = d;
        ArrayList<Date> dayList = new ArrayList<Date>();
        Calendar a = Calendar.getInstance();
        a.setTime(this.m_fromDate);
        DateUtility.truncCalendar((Calendar)a);
        Calendar b = Calendar.getInstance();
        b.setTime(this.m_toDate);
        DateUtility.truncCalendar((Calendar)b);
        while (a.compareTo(b) <= 0) {
            dayList.add(a.getTime());
            a.add(5, 1);
        }
        this.m_coveredDays = DateUtility.getCoveredDays((Date)this.m_fromDate, (Date)this.m_toDate);
        this.m_fullDay = this.m_item instanceof ICalendarAppointment ? ((ICalendarAppointment)this.m_item).isFullDay() : (this.m_item instanceof ICalendarTask ? true : true);
    }

    public ICell getCell() {
        return this.m_cell;
    }

    public ICalendarItem getItem() {
        return this.m_item;
    }

    public ICalendarItemProvider getProvider() {
        return this.m_producer;
    }

    public ICalendar getCalendar() {
        return this.m_calendar;
    }

    public Date getFromDate() {
        return this.m_fromDate;
    }

    public Date getToDate() {
        return this.m_toDate;
    }

    public String getLabel(Date day) {
        switch (this.m_calendar.getDisplayMode()) {
            case 3: {
                return this.m_cell.getText();
            }
            case 2: 
            case 4: {
                return this.m_cell.getText();
            }
            case 1: {
                return this.m_cell.getText();
            }
        }
        return this.m_cell.getText();
    }

    public String getTooltip(Date day) {
        day = DateUtility.truncDate((Date)day);
        String s = this.createDayTooltip(day);
        String s2 = this.m_cell.getTooltipText();
        if (s2 != null && s2.length() > 0) {
            s = String.valueOf(s) + "\n" + s2;
        }
        return s;
    }

    public Date[] getCoveredDays() {
        return this.m_coveredDays;
    }

    private String createDayTooltip(Date dayTruncated) {
        Date a = this.getFromDate();
        Date b = this.getToDate();
        DateFormat timeFmt = this.m_calendar.getDateTimeFormatFactory().getHourMinute();
        DateFormat dayFmt = this.m_calendar.getDateTimeFormatFactory().getDayMonth(2);
        if (this.m_coveredDays.length == 1) {
            if (this.isFullDay()) {
                return this.m_cell.getText();
            }
            if (DateUtility.equals((Date)a, (Date)b)) {
                if (DateUtility.equals((Date)a, (Date)dayTruncated)) {
                    return this.m_cell.getText();
                }
                return String.valueOf(timeFmt.format(a)) + " " + this.m_cell.getText();
            }
            return String.valueOf(timeFmt.format(a)) + "-" + timeFmt.format(b) + " " + this.m_cell.getText();
        }
        if (this.isFullDay()) {
            return String.valueOf(dayFmt.format(a)) + " - " + dayFmt.format(b) + "  " + this.m_cell.getText();
        }
        return String.valueOf(dayFmt.format(a)) + " " + timeFmt.format(a) + " - " + dayFmt.format(b) + " " + timeFmt.format(b) + "  " + this.m_cell.getText();
    }

    public boolean isFullDay() {
        return this.m_fullDay;
    }

    public boolean isDraggable() {
        return this.m_producer.isMoveItemEnabled();
    }

    @Override
    public int compareTo(CalendarComponent o) {
        String label2;
        String label1;
        if (this.m_item instanceof Comparable) {
            return ((Comparable)this.m_item).compareTo(o.getItem());
        }
        int i = this.getFromDate().compareTo(o.getFromDate());
        if (i == 0 && (i = StringUtility.compareIgnoreCase((String)(label1 = this.m_item.getSubject()), (String)(label2 = o.getItem().getSubject()))) == 0) {
            i = Integer.valueOf(this.hashCode()).compareTo(o.hashCode());
        }
        return i;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_item == null ? 0 : this.m_item.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CalendarComponent other = (CalendarComponent)obj;
        return !(this.m_item == null ? other.m_item != null : !this.m_item.equals((Object)other.m_item));
    }
}

