/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;

public class TableEvent
extends EventObject {
    public static final int TYPE_COLUMN_STRUCTURE_CHANGED = 1;
    public static final int TYPE_ROWS_INSERTED = 100;
    public static final int TYPE_ROWS_UPDATED = 101;
    public static final int TYPE_ROWS_DELETED = 102;
    public static final int TYPE_ROWS_SELECTED = 103;
    public static final int TYPE_ROW_ACTION = 104;
    public static final int TYPE_ALL_ROWS_DELETED = 105;
    public static final int TYPE_ROW_ORDER_CHANGED = 200;
    public static final int TYPE_ROW_FILTER_CHANGED = 210;
    public static final int TYPE_ROW_POPUP = 700;
    public static final int TYPE_EMPTY_SPACE_POPUP = 701;
    public static final int TYPE_HEADER_POPUP = 750;
    public static final int TYPE_ROWS_DRAG_REQUEST = 730;
    public static final int TYPE_ROW_DROP_ACTION = 740;
    public static final int TYPE_ROWS_COPY_REQUEST = 760;
    public static final int TYPE_COLUMN_ORDER_CHANGED = 770;
    public static final int TYPE_COLUMN_HEADERS_UPDATED = 780;
    public static final int TYPE_REQUEST_FOCUS = 800;
    public static final int TYPE_REQUEST_FOCUS_IN_CELL = 805;
    public static final int TYPE_ROW_CLICK = 810;
    public static final int TYPE_TABLE_POPULATED = 820;
    public static final int TYPE_SCROLL_TO_SELECTION = 830;
    private final int m_type;
    private List<? extends ITableRow> m_rows;
    private List<IMenu> m_popupMenus;
    private boolean m_consumed;
    private TransferObject m_dragObject;
    private TransferObject m_dropObject;
    private TransferObject m_copyObject;
    private Collection<? extends IColumn<?>> m_columns;
    private boolean m_sortInMemoryAllowed;

    public TableEvent(ITable source, int type) {
        this(source, type, null);
    }

    public TableEvent(ITable source, int type, List<? extends ITableRow> rows) {
        super(source);
        this.m_type = type;
        this.m_rows = CollectionUtility.arrayList(rows);
    }

    public ITable getTable() {
        return (ITable)this.getSource();
    }

    public int getType() {
        return this.m_type;
    }

    public List<ITableRow> getRows() {
        return CollectionUtility.arrayList(this.m_rows);
    }

    protected void setRows(List<? extends ITableRow> rows) {
        this.m_rows = CollectionUtility.arrayList(rows);
    }

    public int getRowCount() {
        return this.m_rows.size();
    }

    public ITableRow getFirstRow() {
        return (ITableRow)CollectionUtility.firstElement(this.m_rows);
    }

    public ITableRow getLastRow() {
        return (ITableRow)CollectionUtility.lastElement(this.m_rows);
    }

    public void addPopupMenu(IMenu menu) {
        if (menu != null) {
            if (this.m_popupMenus == null) {
                this.m_popupMenus = new ArrayList<IMenu>();
            }
            this.m_popupMenus.add(menu);
        }
    }

    public void addPopupMenus(List<IMenu> menus) {
        if (menus != null) {
            if (this.m_popupMenus == null) {
                this.m_popupMenus = new ArrayList<IMenu>();
            }
            this.m_popupMenus.addAll(menus);
        }
    }

    public List<IMenu> getPopupMenus() {
        return CollectionUtility.arrayList(this.m_popupMenus);
    }

    public int getPopupMenuCount() {
        if (this.m_popupMenus != null) {
            return this.m_popupMenus.size();
        }
        return 0;
    }

    public boolean isConsumed() {
        return this.m_consumed;
    }

    public void consume() {
        this.m_consumed = true;
    }

    public TransferObject getDragObject() {
        return this.m_dragObject;
    }

    public void setDragObject(TransferObject t) {
        this.m_dragObject = t;
    }

    public TransferObject getDropObject() {
        return this.m_dropObject;
    }

    protected void setDropObject(TransferObject t) {
        this.m_dropObject = t;
    }

    public TransferObject getCopyObject() {
        return this.m_copyObject;
    }

    protected void setCopyObject(TransferObject t) {
        this.m_copyObject = t;
    }

    public Collection<IColumn<?>> getColumns() {
        return CollectionUtility.arrayList(this.m_columns);
    }

    public IColumn getFirstColumn() {
        return (IColumn)CollectionUtility.firstElement(this.m_columns);
    }

    protected void setColumns(Collection<? extends IColumn<?>> columns) {
        this.m_columns = columns;
    }

    public boolean isSortInMemoryAllowed() {
        return this.m_sortInMemoryAllowed;
    }

    protected void setSortInMemoryAllowed(boolean b) {
        this.m_sortInMemoryAllowed = b;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(String.valueOf(this.getClass().getSimpleName()) + "[");
        try {
            Field[] f = this.getClass().getDeclaredFields();
            int i = 0;
            while (i < f.length) {
                if (Modifier.isPublic(f[i].getModifiers()) && Modifier.isStatic(f[i].getModifiers()) && f[i].getName().startsWith("TYPE_") && ((Number)f[i].get(null)).intValue() == this.m_type) {
                    buf.append(f[i].getName());
                    break;
                }
                ++i;
            }
        }
        catch (Throwable t) {
            buf.append("#" + this.m_type);
        }
        buf.append(" ");
        if (CollectionUtility.hasElements(this.m_rows) && this.getTable() != null) {
            if (this.m_rows.size() == 1) {
                buf.append("row ").append(this.m_rows.get(0));
            } else {
                buf.append("rows {");
                Iterator<? extends ITableRow> rowIt = this.m_rows.iterator();
                buf.append("" + rowIt.next());
                while (rowIt.hasNext()) {
                    buf.append(",");
                    buf.append("" + rowIt.next());
                }
                buf.append("}");
            }
        } else {
            buf.append("{}");
        }
        buf.append("]");
        return buf.toString();
    }
}

