/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columnfilter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.shared.ScoutTexts;

public class ColumnFilterMenu
extends AbstractMenu {
    private final ITable m_table;

    public ColumnFilterMenu(ITable table) {
        this.m_table = table;
    }

    @Override
    protected String getConfiguredText() {
        return ScoutTexts.get((String)"ColumnFilterMenu", (String[])new String[0]);
    }

    @Override
    protected void execInitAction() throws ProcessingException {
        this.m_table.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("contextColumn".equals(evt.getPropertyName())) {
                    ColumnFilterMenu.this.updateVisibility();
                }
            }
        });
        this.updateVisibility();
    }

    private void updateVisibility() {
        this.setVisible(this.m_table != null && this.m_table.getColumnFilterManager() != null && this.m_table.getContextColumn() != null);
    }

    @Override
    protected void execAction() throws ProcessingException {
        IColumn<?> col;
        if (this.m_table != null && this.m_table.getColumnFilterManager() != null && (col = this.m_table.getContextColumn()) != null) {
            this.m_table.getColumnFilterManager().showFilterForm(col, true);
        }
    }
}

