/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IContentAssistColumn;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;

public abstract class AbstractContentAssistColumn<VALUE_TYPE, LOOKUP_TYPE>
extends AbstractColumn<VALUE_TYPE>
implements IContentAssistColumn<VALUE_TYPE, LOOKUP_TYPE> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractContentAssistColumn.class);
    private Class<? extends ICodeType<?, LOOKUP_TYPE>> m_codeTypeClass;
    private ILookupCall<LOOKUP_TYPE> m_lookupCall;

    @ConfigProperty(value="LOOKUP_CALL")
    @Order(value=140.0)
    protected Class<? extends ILookupCall<LOOKUP_TYPE>> getConfiguredLookupCall() {
        return null;
    }

    @ConfigProperty(value="CODE_TYPE")
    @Order(value=150.0)
    protected Class<? extends ICodeType<?, LOOKUP_TYPE>> getConfiguredCodeType() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=310.0)
    protected boolean getConfiguredBrowseHierarchy() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=280.0)
    protected boolean getConfiguredBrowseAutoExpandAll() {
        return true;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=265.0)
    protected int getConfiguredBrowseMaxRowCount() {
        return 100;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    protected boolean getConfiguredActiveFilterEnabled() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=240.0)
    protected boolean getConfiguredBrowseLoadIncremental() {
        return false;
    }

    @ConfigOperation
    @Order(value=140.0)
    protected void execPrepareLookup(ILookupCall<LOOKUP_TYPE> call, ITableRow row) {
    }

    @Override
    protected void initConfig() {
        Class<ILookupCall<LOOKUP_TYPE>> lookupCallClass;
        super.initConfig();
        if (this.getConfiguredCodeType() != null) {
            this.setCodeTypeClass(this.getConfiguredCodeType());
        }
        if ((lookupCallClass = this.getConfiguredLookupCall()) != null) {
            try {
                ILookupCall<LOOKUP_TYPE> call = lookupCallClass.newInstance();
                this.setLookupCall(call);
            }
            catch (InstantiationException e) {
                LOG.warn(null, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.warn(null, (Throwable)e);
            }
        }
    }

    @Override
    public Class<? extends ICodeType<?, LOOKUP_TYPE>> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    @Override
    public void setCodeTypeClass(Class<? extends ICodeType<?, LOOKUP_TYPE>> codeTypeClass) {
        this.m_codeTypeClass = codeTypeClass;
        this.m_lookupCall = null;
        if (this.m_codeTypeClass != null) {
            this.m_lookupCall = CodeLookupCall.newInstanceByService(this.m_codeTypeClass);
        }
        this.validateColumnValues();
    }

    @Override
    public ILookupCall<LOOKUP_TYPE> getLookupCall() {
        return this.m_lookupCall;
    }

    @Override
    public void setLookupCall(ILookupCall<LOOKUP_TYPE> call) {
        this.m_lookupCall = call;
    }

    @Override
    protected VALUE_TYPE parseValueInternal(ITableRow row, Object rawValue) throws ProcessingException {
        Object validValue = null;
        if (rawValue == null) {
            validValue = null;
        } else if (this.getDataType().isAssignableFrom(rawValue.getClass())) {
            validValue = rawValue;
        } else {
            try {
                validValue = TypeCastUtility.castValue((Object)rawValue, this.getDataType());
            }
            catch (Exception e) {
                throw new ProcessingException("invalid " + this.getDataType().getSimpleName() + " value in column '" + this.getClass().getName() + "': " + rawValue + " class=" + rawValue.getClass());
            }
        }
        return (VALUE_TYPE)validValue;
    }
}

