/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.customizer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.Permission;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.ICustomColumn;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.ITableCustomizer;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBox;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.shared.security.DeleteCustomColumnPermission;

public class RemoveCustomColumnMenu
extends AbstractMenu {
    private final ITable m_table;

    public RemoveCustomColumnMenu(ITable table) {
        this.m_table = table;
    }

    @Override
    protected String getConfiguredText() {
        return ScoutTexts.get((String)"RemoveCustomColumnMenu", (String[])new String[0]);
    }

    @Override
    protected void execInitAction() throws ProcessingException {
        this.setVisiblePermission((Permission)new DeleteCustomColumnPermission());
        this.m_table.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("contextColumn".equals(evt.getPropertyName()) || "tableCustomizer".equals(evt.getPropertyName())) {
                    RemoveCustomColumnMenu.this.updateVisibility();
                }
            }
        });
        this.updateVisibility();
    }

    private void updateVisibility() {
        ITableCustomizer cst = this.m_table.getTableCustomizer();
        IColumn<?> col = this.m_table.getContextColumn();
        this.setVisible(cst != null && col instanceof ICustomColumn);
    }

    @Override
    protected void execAction() throws ProcessingException {
        if (this.m_table != null) {
            ITableCustomizer cst = this.m_table.getTableCustomizer();
            IColumn<?> col = this.m_table.getContextColumn();
            if (cst != null && col instanceof ICustomColumn && MessageBox.showDeleteConfirmationMessage(TEXTS.get((String)"Columns"), col.getHeaderCell().getText())) {
                cst.removeColumn((ICustomColumn)col);
            }
        }
    }
}

