/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.tree;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeUtility;

public class TreeEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_NODES_INSERTED = 10;
    public static final int TYPE_NODES_UPDATED = 20;
    public static final int TYPE_NODE_FILTER_CHANGED = 400;
    public static final int TYPE_NODES_DELETED = 30;
    public static final int TYPE_BEFORE_NODES_SELECTED = 35;
    public static final int TYPE_NODES_SELECTED = 40;
    public static final int TYPE_CHILD_NODE_ORDER_CHANGED = 50;
    public static final int TYPE_NODE_EXPANDED = 100;
    public static final int TYPE_NODE_COLLAPSED = 101;
    public static final int TYPE_NODE_POPUP = 700;
    public static final int TYPE_NODE_ACTION = 705;
    public static final int TYPE_NODES_DRAG_REQUEST = 730;
    public static final int TYPE_DRAG_FINISHED = 735;
    public static final int TYPE_NODE_DROP_ACTION = 740;
    public static final int TYPE_NODE_REQUEST_FOCUS = 200;
    public static final int TYPE_NODE_ENSURE_VISIBLE = 300;
    public static final int TYPE_REQUEST_FOCUS = 800;
    public static final int TYPE_NODE_CLICK = 820;
    public static final int TYPE_SCROLL_TO_SELECTION = 830;
    public static final int TYPE_NODE_CHANGED = 850;
    public static final int TYPE_NODE_DROP_TARGET_CHANGED = 860;
    private final int m_type;
    private ITreeNode m_commonParentNode;
    private Collection<? extends ITreeNode> m_nodes;
    private Collection<? extends ITreeNode> m_deselectedNodes;
    private Collection<? extends ITreeNode> m_newSelectedNodes;
    private List<IMenu> m_popupMenus;
    private boolean m_consumed;
    private TransferObject m_dragObject;
    private TransferObject m_dropObject;

    public TreeEvent(ITree source, int type) {
        super(source);
        this.m_type = type;
    }

    public TreeEvent(ITree source, int type, ITreeNode node) {
        super(source);
        this.m_type = type;
        if (node != null) {
            this.m_nodes = CollectionUtility.hashSet((Object)node);
        }
        this.m_commonParentNode = TreeUtility.calculateCommonParentNode(this.m_nodes);
    }

    public TreeEvent(ITree source, int type, Collection<? extends ITreeNode> nodes) {
        super(source);
        this.m_type = type;
        if (nodes != null) {
            this.m_nodes = nodes;
        }
        this.m_commonParentNode = TreeUtility.calculateCommonParentNode(this.m_nodes);
    }

    public TreeEvent(ITree source, int type, ITreeNode parentNode, Collection<? extends ITreeNode> childNodes) {
        super(source);
        this.m_type = type;
        if (childNodes != null) {
            this.m_nodes = childNodes;
        }
        this.m_commonParentNode = parentNode;
        if (this.m_commonParentNode == null) {
            this.m_commonParentNode = TreeUtility.calculateCommonParentNode(this.m_nodes);
        }
    }

    public ITree getTree() {
        return (ITree)this.getSource();
    }

    public int getType() {
        return this.m_type;
    }

    public ITreeNode getCommonParentNode() {
        return this.m_commonParentNode;
    }

    public ITreeNode getDeselectedNode() {
        if (CollectionUtility.hasElements(this.m_deselectedNodes)) {
            return (ITreeNode)CollectionUtility.firstElement(this.m_deselectedNodes);
        }
        return null;
    }

    public Collection<ITreeNode> getDeselectedNodes() {
        return CollectionUtility.arrayList(this.m_deselectedNodes);
    }

    protected void setDeselectedNodes(Collection<ITreeNode> deselectedNodes) {
        this.m_deselectedNodes = deselectedNodes;
    }

    public ITreeNode getNewSelectedNode() {
        if (CollectionUtility.hasElements(this.m_newSelectedNodes)) {
            return (ITreeNode)CollectionUtility.firstElement(this.m_newSelectedNodes);
        }
        return null;
    }

    public Collection<ITreeNode> getNewSelectedNodes() {
        return CollectionUtility.arrayList(this.m_newSelectedNodes);
    }

    protected void setNewSelectedNodes(Collection<ITreeNode> newSelectedNodes) {
        this.m_newSelectedNodes = newSelectedNodes;
    }

    public ITreeNode getNode() {
        if (CollectionUtility.hasElements(this.m_nodes)) {
            return (ITreeNode)CollectionUtility.firstElement(this.m_nodes);
        }
        return null;
    }

    public Collection<ITreeNode> getNodes() {
        return CollectionUtility.arrayList(this.m_nodes);
    }

    public ITreeNode getChildNode() {
        return this.getNode();
    }

    public Collection<ITreeNode> getChildNodes() {
        return this.getNodes();
    }

    public void addPopupMenu(IMenu menu) {
        if (menu != null) {
            if (this.m_popupMenus == null) {
                this.m_popupMenus = new ArrayList<IMenu>();
            }
            this.m_popupMenus.add(menu);
        }
    }

    public void addPopupMenus(List<IMenu> menus) {
        if (menus != null) {
            if (this.m_popupMenus == null) {
                this.m_popupMenus = new ArrayList<IMenu>();
            }
            this.m_popupMenus.addAll(menus);
        }
    }

    public List<IMenu> getPopupMenus() {
        return CollectionUtility.arrayList(this.m_popupMenus);
    }

    public int getPopupMenuCount() {
        if (this.m_popupMenus != null) {
            return this.m_popupMenus.size();
        }
        return 0;
    }

    public TransferObject getDragObject() {
        return this.m_dragObject;
    }

    public void setDragObject(TransferObject t) {
        this.m_dragObject = t;
    }

    public TransferObject getDropObject() {
        return this.m_dropObject;
    }

    protected void setDropObject(TransferObject t) {
        this.m_dropObject = t;
    }

    public boolean isConsumed() {
        return this.m_consumed;
    }

    public void consume() {
        this.m_consumed = true;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("TreeEvent[");
        if (CollectionUtility.hasElements(this.m_nodes) && this.getTree() != null) {
            if (this.m_nodes.size() == 1) {
                buf.append("\"" + CollectionUtility.firstElement(this.m_nodes) + "\"");
            } else {
                buf.append("{");
                Iterator<? extends ITreeNode> nodeIt = this.m_nodes.iterator();
                buf.append("\"").append(nodeIt.next()).append("\"");
                while (nodeIt.hasNext()) {
                    buf.append(",").append("\"").append(nodeIt.next()).append("\"");
                }
                buf.append("}");
            }
        } else {
            buf.append("{}");
        }
        buf.append(" ");
        try {
            Field[] f = this.getClass().getDeclaredFields();
            int i = 0;
            while (i < f.length) {
                if (Modifier.isPublic(f[i].getModifiers()) && Modifier.isStatic(f[i].getModifiers()) && f[i].getName().startsWith("TYPE_") && ((Number)f[i].get(null)).intValue() == this.m_type) {
                    buf.append(f[i].getName());
                    break;
                }
                ++i;
            }
        }
        catch (Throwable t) {
            buf.append("#" + this.m_type);
        }
        buf.append("]");
        return buf.toString();
    }
}

