/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.tree;

import java.security.Permission;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICellObserver;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.IVirtualTreeNode;

public class VirtualTreeNode
implements IVirtualTreeNode,
ICellObserver {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(VirtualTreeNode.class);
    private ITree m_tree;
    private ITreeNode m_parentNode;
    private ITreeNode m_resolvedNode;
    private boolean m_filterAccepted;
    private final Cell m_cell = new Cell(this);
    private int m_childNodeIndex;

    public final int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj == this.m_resolvedNode) {
            return true;
        }
        return super.equals(obj);
    }

    @Override
    public void initTreeNode() {
    }

    @Override
    public ITreeNode getResolvedNode() {
        return this.m_resolvedNode;
    }

    @Override
    public void setResolvedNode(ITreeNode resolvedNode) {
        this.m_resolvedNode = resolvedNode;
        if (resolvedNode instanceof AbstractTreeNode) {
            ((AbstractTreeNode)resolvedNode).setHashCode(this.hashCode());
        }
    }

    @Override
    public String getNodeId() {
        String s = this.getClass().getName();
        int i = Math.max(s.lastIndexOf(36), s.lastIndexOf(46));
        s = s.substring(i + 1);
        return s;
    }

    @Override
    public int getStatus() {
        return 0;
    }

    @Override
    public void setStatusInternal(int status) {
    }

    @Override
    public void setStatus(int status) {
    }

    @Override
    public boolean isStatusInserted() {
        return false;
    }

    @Override
    public boolean isStatusUpdated() {
        return false;
    }

    @Override
    public boolean isStatusDeleted() {
        return false;
    }

    @Override
    public boolean isStatusNonchanged() {
        return true;
    }

    @Override
    public boolean isSelectedNode() {
        return false;
    }

    @Override
    public boolean isFilterAccepted() {
        return this.m_filterAccepted;
    }

    @Override
    public void setFilterAccepted(boolean b) {
        if (this.m_filterAccepted != b) {
            this.m_filterAccepted = b;
            if (this.getParentNode() != null) {
                this.getParentNode().resetFilterCache();
            }
        }
    }

    @Override
    public void resetFilterCache() {
    }

    @Override
    public ITreeNode resolveVirtualChildNode(ITreeNode node) throws ProcessingException {
        return node;
    }

    @Override
    public final ICell getCell() {
        return this.m_cell;
    }

    @Override
    public final Cell getCellForUpdate() {
        return this.m_cell;
    }

    @Override
    public final void decorateCell() {
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void setLeafInternal(boolean b) {
    }

    @Override
    public void setLeaf(boolean b) {
    }

    @Override
    public boolean isChecked() {
        return false;
    }

    @Override
    public void setCheckedInternal(boolean b) {
    }

    @Override
    public void setChecked(boolean b) {
    }

    @Override
    public boolean isExpanded() {
        return false;
    }

    @Override
    public void setExpandedInternal(boolean b) {
    }

    @Override
    public boolean isInitialExpanded() {
        return false;
    }

    @Override
    public void setInitialExpanded(boolean b) {
    }

    @Override
    public void setExpanded(boolean b) {
    }

    @Override
    public void setVisiblePermissionInternal(Permission p) {
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isVisibleGranted() {
        return true;
    }

    @Override
    public void setVisibleInternal(boolean b) {
    }

    @Override
    public void setVisibleGrantedInternal(boolean b) {
    }

    @Override
    public void setVisiblePermission(Permission p) {
    }

    @Override
    public void setVisible(boolean b) {
    }

    @Override
    public void setVisibleGranted(boolean b) {
    }

    @Override
    public void setEnabledPermissionInternal(Permission p) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isEnabledGranted() {
        return true;
    }

    @Override
    public void setEnabledInternal(boolean b) {
    }

    @Override
    public void setEnabledGrantedInternal(boolean b) {
    }

    @Override
    public void setEnabledPermission(Permission p) {
    }

    @Override
    public void setEnabled(boolean b) {
    }

    @Override
    public void setEnabledGranted(boolean b) {
    }

    @Override
    public boolean isChildrenVolatile() {
        return false;
    }

    @Override
    public void setChildrenVolatile(boolean childrenVolatile) {
    }

    @Override
    public boolean isChildrenDirty() {
        return false;
    }

    @Override
    public void setChildrenDirty(boolean dirty) {
    }

    @Override
    public Object getPrimaryKey() {
        return null;
    }

    @Override
    public void setPrimaryKey(Object key) {
    }

    @Override
    public List<IMenu> getMenus() {
        return CollectionUtility.emptyArrayList();
    }

    @Override
    public <T extends IMenu> T getMenu(Class<T> menuType) throws ProcessingException {
        return null;
    }

    @Override
    public void setMenus(List<? extends IMenu> a) {
    }

    @Override
    public ITreeNode getParentNode() {
        return this.m_parentNode;
    }

    @Override
    public <T extends ITreeNode> T getParentNode(Class<T> type) {
        ITreeNode node = this.getParentNode();
        if (node != null && type.isAssignableFrom(node.getClass())) {
            return (T)node;
        }
        return null;
    }

    @Override
    public <T extends ITreeNode> T getParentNode(Class<T> type, int backCount) {
        ITreeNode node = this;
        while (node != null && backCount > 0) {
            node = node.getParentNode();
            --backCount;
        }
        if (backCount == 0 && node != null && type.isAssignableFrom(node.getClass())) {
            return (T)node;
        }
        return null;
    }

    @Override
    public <T extends ITreeNode> T getAncestorNode(Class<T> type) {
        ITreeNode node = this.getParentNode();
        while (node != null && !type.isAssignableFrom(node.getClass())) {
            node = node.getParentNode();
        }
        return (T)node;
    }

    @Override
    public void setParentNodeInternal(ITreeNode parent) {
        this.m_parentNode = parent;
    }

    @Override
    public int getChildNodeCount() {
        return 0;
    }

    @Override
    public void setChildNodeIndexInternal(int childNodeIndex) {
        this.m_childNodeIndex = childNodeIndex;
    }

    @Override
    public int getChildNodeIndex() {
        return this.m_childNodeIndex;
    }

    @Override
    public List<ITreeNode> getFilteredChildNodes() {
        return CollectionUtility.emptyArrayList();
    }

    @Override
    public int getTreeLevel() {
        int level = 0;
        ITreeNode parent = this.getParentNode();
        while (parent != null) {
            ++level;
            parent = parent.getParentNode();
        }
        return level;
    }

    @Override
    public ITreeNode getChildNode(int childIndex) {
        return null;
    }

    @Override
    public List<ITreeNode> getChildNodes() {
        return CollectionUtility.emptyArrayList();
    }

    public ITreeNode findParentNode(Class interfaceType) {
        ITreeNode test = this.getParentNode();
        while (test != null) {
            if (interfaceType.isInstance(test)) break;
            test = test.getParentNode();
        }
        return test;
    }

    @Override
    public void nodeAddedNotify() {
    }

    @Override
    public void nodeRemovedNotify() {
    }

    @Override
    public boolean isChildrenLoaded() {
        return true;
    }

    @Override
    public void setChildrenLoaded(boolean b) {
    }

    @Override
    public final void ensureChildrenLoaded() throws ProcessingException {
    }

    @Override
    public ITree getTree() {
        return this.m_tree;
    }

    @Override
    public void setTreeInternal(ITree tree, boolean includeSubtree) {
        this.m_tree = tree;
    }

    @Override
    public void loadChildren() throws ProcessingException {
    }

    @Override
    public void update() {
        this.getTree().updateNode(this);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.getCell() + "]";
    }

    @Override
    public void cellChanged(ICell cell, int changedBit) {
    }

    @Override
    public Object validateValue(ICell cell, Object value) throws ProcessingException {
        return value;
    }
}

