/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.bookmark;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.dnd.JavaTransferObject;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.services.common.bookmark.IBookmarkService;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuSeparator;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeVisitor;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.BookmarkFolderForm;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.BookmarkForm;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.IBookmarkForm;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.IBookmarkNode;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.view.IOpenBookmarkCommand;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.view.IPublishBookmarkCommand;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.treefield.AbstractTreeField;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBox;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.security.PublishUserBookmarkPermission;
import org.eclipse.scout.rt.shared.services.common.bookmark.AbstractPageState;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkFolder;
import org.eclipse.scout.rt.shared.services.common.bookmark.TablePageState;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.common.security.ACCESS;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractBookmarkTreeField
extends AbstractTreeField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractBookmarkTreeField.class);
    private BookmarkFolder m_bookmarkRootFolder;
    private IPublishBookmarkCommand m_publishBookmarkCommand;
    private IOpenBookmarkCommand m_openBookmarkCommand;

    public AbstractBookmarkTreeField() {
        this(true);
    }

    public AbstractBookmarkTreeField(boolean callInitializer) {
        super(callInitializer);
    }

    public BookmarkFolder getBookmarkRootFolder() {
        return this.m_bookmarkRootFolder;
    }

    public void setBookmarkRootFolder(BookmarkFolder bookmarkRootFolder) {
        this.m_bookmarkRootFolder = bookmarkRootFolder;
    }

    private static boolean isBookmarkNode(ITreeNode node) {
        return node instanceof BookmarkNode;
    }

    private static boolean isFolderNode(ITreeNode node) {
        return node instanceof FolderNode;
    }

    public void injectPublishBookmarkCommand(IPublishBookmarkCommand command) {
        this.m_publishBookmarkCommand = command;
    }

    public void injectOpenBookmarkCommand(IOpenBookmarkCommand command) {
        this.m_openBookmarkCommand = command;
    }

    private BookmarkFolder getParentBookmarkFolder(ITreeNode node) {
        BookmarkFolder folder = this.getBookmarkRootFolder();
        ITreeNode parentNode = node.getParentNode();
        if (AbstractBookmarkTreeField.isFolderNode(parentNode)) {
            folder = (BookmarkFolder)parentNode.getCell().getValue();
        }
        return folder;
    }

    @Override
    protected int getConfiguredGridW() {
        return 1;
    }

    @Override
    protected int getConfiguredGridH() {
        return 8;
    }

    @Override
    protected boolean getConfiguredAutoLoad() {
        return false;
    }

    @Override
    protected boolean getConfiguredLabelVisible() {
        return false;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    protected String getConfiguredGlobalBookmarkLabel() {
        return ScoutTexts.get((String)"GlobalBookmarks", (String[])new String[0]);
    }

    @ConfigProperty(value="TEXT")
    @Order(value=20.0)
    protected String getConfiguredPrivateBookmarkLabel() {
        return ScoutTexts.get((String)"PrivateBookmarks", (String[])new String[0]);
    }

    @ConfigProperty(value="FORM")
    @Order(value=30.0)
    protected Class<? extends IBookmarkForm> getConfiguredBookmarkForm() {
        return BookmarkForm.class;
    }

    protected Permission getDeletePermission(List<Bookmark> bookmarks) throws ProcessingException {
        return this.getDeletePermission();
    }

    protected Permission getUpdatePermission(List<Bookmark> bookmarks) throws ProcessingException {
        return this.getUpdatePermission();
    }

    protected Permission getPublishPermission(Bookmark bookmark) throws ProcessingException {
        return this.getPublishPermission();
    }

    protected Permission getDeletePermission() {
        return null;
    }

    protected Permission getUpdatePermission() {
        return null;
    }

    protected Permission getPublishPermission() {
        return new PublishUserBookmarkPermission();
    }

    public void populateTree() {
        block5: {
            try {
                try {
                    this.getTree().setTreeChanging(true);
                    this.getTree().removeAllChildNodes(this.getTree().getRootNode());
                    this.populateFolderContentRec(this.getTree().getRootNode(), this.getBookmarkRootFolder());
                }
                catch (ProcessingException e) {
                    LOG.error(null, (Throwable)e);
                    this.getTree().setTreeChanging(false);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.getTree().setTreeChanging(false);
                throw throwable;
            }
            this.getTree().setTreeChanging(false);
        }
        this.getTree().expandAll(this.getTree().getRootNode());
    }

    private void populateFolderContentRec(ITreeNode parent, BookmarkFolder newParent) throws ProcessingException {
        AbstractTreeNode newNode;
        for (BookmarkFolder newFolder : newParent.getFolders()) {
            newNode = new FolderNode();
            newNode.getCellForUpdate().setValue(newFolder);
            this.getTree().addChildNode(parent, newNode);
            this.populateFolderContentRec(newNode, newFolder);
        }
        for (Bookmark b : newParent.getBookmarks()) {
            newNode = new BookmarkNode();
            newNode.getCellForUpdate().setValue(b);
            this.getTree().addChildNode(parent, newNode);
        }
    }

    private void rebuildBookmarkModel() throws ProcessingException {
        this.getTree().visitTree(new ITreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                BookmarkFolder bmFolder = null;
                if (node == AbstractBookmarkTreeField.this.getTree().getRootNode()) {
                    bmFolder = AbstractBookmarkTreeField.this.getBookmarkRootFolder();
                } else if (AbstractBookmarkTreeField.isFolderNode(node)) {
                    bmFolder = (BookmarkFolder)node.getCell().getValue();
                }
                if (bmFolder != null) {
                    bmFolder.getFolders().clear();
                    bmFolder.getBookmarks().clear();
                    ArrayList<BookmarkFolder> folderList = new ArrayList<BookmarkFolder>();
                    for (ITreeNode n : node.getChildNodes()) {
                        if (!AbstractBookmarkTreeField.isFolderNode(n)) continue;
                        BookmarkFolder f = (BookmarkFolder)n.getCell().getValue();
                        folderList.add(f);
                    }
                    Collections.sort(folderList, new Comparator<BookmarkFolder>(){

                        @Override
                        public int compare(BookmarkFolder f1, BookmarkFolder f2) {
                            return StringUtility.compareIgnoreCase((String)f1.getTitle(), (String)f2.getTitle());
                        }
                    });
                    bmFolder.getFolders().addAll(folderList);
                    for (ITreeNode n : node.getChildNodes()) {
                        if (!AbstractBookmarkTreeField.isBookmarkNode(n)) continue;
                        bmFolder.getBookmarks().add((Bookmark)n.getCell().getValue());
                    }
                }
                return true;
            }
        });
        ((IBookmarkService)SERVICES.getService(IBookmarkService.class)).storeBookmarks();
    }

    private void refreshBookmarkModel() throws ProcessingException {
        this.getTree().visitTree(new ITreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                BookmarkFolder bmFolder = null;
                if (node == AbstractBookmarkTreeField.this.getTree().getRootNode()) {
                    bmFolder = AbstractBookmarkTreeField.this.getBookmarkRootFolder();
                } else if (AbstractBookmarkTreeField.isFolderNode(node)) {
                    bmFolder = (BookmarkFolder)node.getCell().getValue();
                }
                if (bmFolder != null) {
                    bmFolder.getFolders().clear();
                    bmFolder.getBookmarks().clear();
                    for (ITreeNode n : node.getChildNodes()) {
                        if (AbstractBookmarkTreeField.isFolderNode(n)) {
                            bmFolder.getFolders().add((BookmarkFolder)n.getCell().getValue());
                            continue;
                        }
                        if (!AbstractBookmarkTreeField.isBookmarkNode(n)) continue;
                        bmFolder.getBookmarks().add((Bookmark)n.getCell().getValue());
                    }
                }
                return true;
            }
        });
        ((IBookmarkService)SERVICES.getService(IBookmarkService.class)).storeBookmarks();
    }

    private class BookmarkNode
    extends AbstractTreeNode
    implements IBookmarkNode {
        private BookmarkNode() {
        }

        @Override
        protected boolean getConfiguredLeaf() {
            return true;
        }

        @Override
        protected void execDecorateCell(Cell cell) {
            Bookmark bm = (Bookmark)cell.getValue();
            if (bm != null) {
                if (bm.getKeyStroke() != null) {
                    cell.setText(String.valueOf(bm.getTitle()) + " [" + bm.getKeyStroke() + "]");
                } else {
                    cell.setText(bm.getTitle());
                }
                cell.setTooltipText(bm.getText());
                if (StringUtility.isNullOrEmpty((String)bm.getIconId())) {
                    cell.setIconId("bookmark");
                } else {
                    cell.setIconId(bm.getIconId());
                }
                if (bm.isNew()) {
                    cell.setFont(new FontSpec(null, 1, 0));
                }
            }
        }

        @Override
        public Bookmark getBookmark() {
            BookmarkNode node = this;
            return (Bookmark)node.getCell().getValue();
        }

        @Override
        public BookmarkFolder getParentFolder() {
            BookmarkNode node = this;
            return (BookmarkFolder)node.getParentNode().getCell().getValue();
        }

        @Order(value=100.0)
        public class ApplyToSearchMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"BookmarksApplyToCurrentSearch", (String[])new String[0]);
            }

            @Override
            protected void execAction() throws ProcessingException {
                IForm searchForm;
                BookmarkNode node = BookmarkNode.this;
                Bookmark bm = (Bookmark)node.getCell().getValue();
                IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
                Boolean success = null;
                if (desktop != null && (searchForm = desktop.getPageSearchForm()) != null) {
                    for (AbstractPageState state : bm.getPath()) {
                        if (!(state instanceof TablePageState)) continue;
                        TablePageState tablePageState = (TablePageState)state;
                        try {
                            searchForm.setXML(tablePageState.getSearchFormState());
                            searchForm.doSaveWithoutMarkerChange();
                            success = true;
                            break;
                        }
                        catch (ProcessingException e) {
                            success = false;
                        }
                    }
                }
                if (success != null && !success.booleanValue()) {
                    MessageBox.showOkMessage(null, null, ScoutTexts.get((String)"ApplyBookmarkToSearchFailedMessage", (String[])new String[0]));
                }
            }
        }

        @Order(value=70.0)
        public class DeleteMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"DeleteBookmarkMenu", (String[])new String[0]);
            }

            @Override
            protected String getConfiguredKeyStroke() {
                return "delete";
            }

            @Override
            protected boolean getConfiguredMultiSelectionAction() {
                return true;
            }

            @Override
            protected void execPrepareAction() throws ProcessingException {
                ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>();
                ITree tree = BookmarkNode.this.getTree();
                for (ITreeNode node : tree.getSelectedNodes()) {
                    if (!AbstractBookmarkTreeField.isBookmarkNode(node)) continue;
                    bookmarks.add((Bookmark)node.getCell().getValue());
                }
                this.setEnabledPermission(AbstractBookmarkTreeField.this.getDeletePermission(bookmarks));
            }

            @Override
            protected void execAction() throws ProcessingException {
                ArrayList<String> items = new ArrayList<String>();
                ArrayList<ITreeNode> filteredNodes = new ArrayList<ITreeNode>();
                ITree tree = BookmarkNode.this.getTree();
                for (ITreeNode node : tree.getSelectedNodes()) {
                    if (!AbstractBookmarkTreeField.isBookmarkNode(node)) continue;
                    items.add(node.getCell().getText());
                    filteredNodes.add(node);
                }
                if (items.size() <= 1 || MessageBox.showDeleteConfirmationMessage(items.toArray(new String[0]))) {
                    for (ITreeNode node : filteredNodes) {
                        tree.removeNode(node);
                    }
                    AbstractBookmarkTreeField.this.rebuildBookmarkModel();
                }
            }
        }

        @Order(value=50.0)
        public class EditMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"EditBookmarkMenu", (String[])new String[0]);
            }

            @Override
            protected void execOwnerValueChanged(Object newOwnerValue) throws ProcessingException {
                super.execOwnerValueChanged(newOwnerValue);
            }

            @Override
            protected void execPrepareAction() throws ProcessingException {
                ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>();
                ITree tree = BookmarkNode.this.getTree();
                for (ITreeNode node : tree.getSelectedNodes()) {
                    if (!AbstractBookmarkTreeField.isBookmarkNode(node)) continue;
                    bookmarks.add((Bookmark)node.getCell().getValue());
                }
                this.setEnabledPermission(AbstractBookmarkTreeField.this.getUpdatePermission(bookmarks));
            }

            @Override
            protected void execAction() throws ProcessingException {
                BookmarkNode node = BookmarkNode.this;
                Bookmark bm = (Bookmark)node.getCell().getValue();
                IBookmarkForm form = null;
                if (AbstractBookmarkTreeField.this.getConfiguredBookmarkForm() != null) {
                    try {
                        form = AbstractBookmarkTreeField.this.getConfiguredBookmarkForm().newInstance();
                    }
                    catch (Exception e) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException(this.getClass().getSimpleName(), (Throwable)e));
                    }
                }
                if (form == null) {
                    form = new BookmarkForm();
                }
                form.setBookmark(bm);
                form.setBookmarkRootFolder(AbstractBookmarkTreeField.this.getBookmarkRootFolder());
                BookmarkFolder oldBmFolder = AbstractBookmarkTreeField.this.getParentBookmarkFolder(BookmarkNode.this);
                boolean oldIsNew = bm.isNew();
                if (oldBmFolder != form.getBookmarkRootFolder()) {
                    form.setFolder(oldBmFolder);
                }
                form.startModify();
                form.waitFor();
                if (form.isFormStored()) {
                    BookmarkFolder newBmFolder;
                    ITree tree = BookmarkNode.this.getTree();
                    bm.setTitle(form.getBookmark().getTitle());
                    bm.setKeyStroke(form.getBookmark().getKeyStroke());
                    bm.setKind(form.getBookmark().getKind());
                    bm.setIconId(form.getBookmark().getIconId());
                    BookmarkFolder bookmarkFolder = newBmFolder = form.getFolder() != null ? form.getFolder() : form.getBookmarkRootFolder();
                    if (!CompareUtility.equals((Object)oldBmFolder, (Object)newBmFolder)) {
                        final AtomicReference<ITreeNode> newContainerNode = new AtomicReference<ITreeNode>(BookmarkNode.this.getTree().getRootNode());
                        tree.visitTree(new ITreeVisitor(){

                            @Override
                            public boolean visit(ITreeNode n) {
                                if (AbstractBookmarkTreeField.isFolderNode(n) && newBmFolder.equals(n.getCell().getValue())) {
                                    newContainerNode.set(n);
                                    return false;
                                }
                                return true;
                            }
                        });
                        tree.removeNode(node);
                        tree.addChildNode(newContainerNode.get(), node);
                        AbstractBookmarkTreeField.this.rebuildBookmarkModel();
                    } else {
                        tree.updateNode(node);
                        AbstractBookmarkTreeField.this.refreshBookmarkModel();
                    }
                } else if (oldIsNew != form.getBookmark().isNew()) {
                    AbstractBookmarkTreeField.this.refreshBookmarkModel();
                }
            }
        }

        @Order(value=40.0)
        public class OpenMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"ActivateBookmarkMenu", (String[])new String[0]);
            }

            @Override
            protected void execAction() throws ProcessingException {
                BookmarkNode node = BookmarkNode.this;
                Bookmark bm = (Bookmark)node.getCell().getValue();
                if (AbstractBookmarkTreeField.this.m_openBookmarkCommand != null) {
                    AbstractBookmarkTreeField.this.m_openBookmarkCommand.openBookmark(bm);
                } else {
                    ClientSyncJob.getCurrentSession().getDesktop().activateBookmark(bm, false);
                }
            }
        }

        @Order(value=90.0)
        public class PublishMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"BookmarksPublishMenu", (String[])new String[0]);
            }

            @Override
            protected void execPrepareAction() throws ProcessingException {
                Bookmark bookmark = null;
                ITreeNode selectedNode = BookmarkNode.this.getTree().getSelectedNode();
                if (AbstractBookmarkTreeField.isBookmarkNode(selectedNode)) {
                    bookmark = (Bookmark)selectedNode.getCell().getValue();
                }
                this.setVisiblePermission(AbstractBookmarkTreeField.this.getPublishPermission(bookmark));
            }

            @Override
            protected void execAction() throws ProcessingException {
                if (AbstractBookmarkTreeField.this.m_publishBookmarkCommand != null) {
                    BookmarkNode node = BookmarkNode.this;
                    Bookmark bm = (Bookmark)node.getCell().getValue();
                    BookmarkFolder spoolFolder = new BookmarkFolder();
                    spoolFolder.getBookmarks().add(bm);
                    AbstractBookmarkTreeField.this.m_publishBookmarkCommand.publishBookmark(spoolFolder);
                }
            }
        }

        @Order(value=80.0)
        public class SeparatorMenu1
        extends MenuSeparator {
        }

        @Order(value=60.0)
        public class UpdateWithCurrentMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"UpdateBookmarkMenu", (String[])new String[0]);
            }

            @Override
            protected void execPrepareAction() throws ProcessingException {
                ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>();
                ITree tree = BookmarkNode.this.getTree();
                for (ITreeNode node : tree.getSelectedNodes()) {
                    if (!AbstractBookmarkTreeField.isBookmarkNode(node)) continue;
                    bookmarks.add((Bookmark)node.getCell().getValue());
                }
                this.setEnabledPermission(AbstractBookmarkTreeField.this.getDeletePermission(bookmarks));
            }

            @Override
            protected void execAction() throws ProcessingException {
                BookmarkNode node = BookmarkNode.this;
                Bookmark bm = (Bookmark)node.getCell().getValue();
                IBookmarkService service = (IBookmarkService)SERVICES.getService(IBookmarkService.class);
                service.updateBookmark(bm);
                service.storeBookmarks();
            }
        }
    }

    private class FolderNode
    extends AbstractTreeNode {
        private FolderNode() {
        }

        @Override
        protected void execDecorateCell(Cell cell) {
            BookmarkFolder bmFolder = (BookmarkFolder)this.getCell().getValue();
            String title = bmFolder.getTitle();
            if ("[INBOX]".equals(title)) {
                title = AbstractBookmarkTreeField.this.getConfiguredGlobalBookmarkLabel();
            }
            cell.setText(title);
            cell.setIconId("tree_node");
        }

        private boolean isProtected() {
            FolderNode node = this;
            BookmarkFolder bmFolder = (BookmarkFolder)node.getCell().getValue();
            return "[INBOX]".equals(bmFolder.getTitle()) || "[SPOOL]".equals(bmFolder.getTitle());
        }

        @Order(value=40.0)
        public class DeleteMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"DeleteFolderMenu", (String[])new String[0]);
            }

            @Override
            protected String getConfiguredKeyStroke() {
                return "delete";
            }

            @Override
            protected boolean getConfiguredMultiSelectionAction() {
                return true;
            }

            @Override
            protected void execPrepareAction() throws ProcessingException {
                this.setEnabled(!FolderNode.this.isProtected());
                this.setVisiblePermission(AbstractBookmarkTreeField.this.getDeletePermission());
                this.setText(this.getConfiguredText());
                for (ITreeNode node : FolderNode.this.getTree().getSelectedNodes()) {
                    if (node instanceof FolderNode) continue;
                    this.setText(ScoutTexts.get((String)"DeleteMenu", (String[])new String[0]));
                }
            }

            @Override
            protected void execAction() throws ProcessingException {
                ITree tree = FolderNode.this.getTree();
                HashSet<ITreeNode> folders = new HashSet<ITreeNode>();
                HashSet<ITreeNode> bookmarks = new HashSet<ITreeNode>();
                for (ITreeNode node : tree.getSelectedNodes()) {
                    this.addNodeFoldersToSet(folders, node);
                    this.addNodeBookmarksToSet(bookmarks, node);
                }
                ArrayList<String> names = new ArrayList<String>();
                for (ITreeNode folder : folders) {
                    names.add(((BookmarkFolder)folder.getCell().getValue()).getTitle());
                }
                for (ITreeNode bookmark : bookmarks) {
                    ArrayList<Bookmark> check = new ArrayList<Bookmark>();
                    check.add((Bookmark)bookmark.getCell().getValue());
                    if (!ACCESS.check((Permission)AbstractBookmarkTreeField.this.getDeletePermission(check))) continue;
                    names.add(((Bookmark)bookmark.getCell().getValue()).getTitle());
                }
                if (MessageBox.showDeleteConfirmationMessage(names.toArray(new String[names.size()]))) {
                    for (ITreeNode bookmark : bookmarks) {
                        tree.removeNode(bookmark);
                    }
                    for (ITreeNode bookmark : folders) {
                        tree.removeNode(bookmark);
                    }
                    AbstractBookmarkTreeField.this.refreshBookmarkModel();
                }
            }

            private void addNodeBookmarksToSet(Set<ITreeNode> items, ITreeNode node) {
                if (AbstractBookmarkTreeField.isFolderNode(node)) {
                    for (ITreeNode child : node.getChildNodes()) {
                        this.addNodeBookmarksToSet(items, child);
                    }
                } else if (AbstractBookmarkTreeField.isBookmarkNode(node)) {
                    items.add(node);
                }
            }

            private void addNodeFoldersToSet(Set<ITreeNode> items, ITreeNode node) {
                if (AbstractBookmarkTreeField.isFolderNode(node)) {
                    items.add(node);
                    for (ITreeNode child : node.getChildNodes()) {
                        this.addNodeFoldersToSet(items, child);
                    }
                }
            }
        }

        @Order(value=30.0)
        public class RenameMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"RenameBookmarkFolderMenu", (String[])new String[0]);
            }

            @Override
            protected void execPrepareAction() throws ProcessingException {
                this.setEnabled(!FolderNode.this.isProtected());
                this.setVisiblePermission(AbstractBookmarkTreeField.this.getUpdatePermission());
            }

            @Override
            protected void execAction() throws ProcessingException {
                FolderNode node = FolderNode.this;
                BookmarkFolder bmFolder = (BookmarkFolder)node.getCell().getValue();
                BookmarkFolderForm form = new BookmarkFolderForm();
                form.getNameField().setValue(bmFolder.getTitle());
                form.startModify();
                form.waitFor();
                if (form.isFormStored()) {
                    bmFolder.setTitle((String)form.getNameField().getValue());
                    FolderNode.this.getTree().updateNode(node);
                    AbstractBookmarkTreeField.this.refreshBookmarkModel();
                }
            }
        }
    }

    @Order(value=10.0)
    public class Tree
    extends AbstractTree {
        @Override
        protected boolean getConfiguredMultiSelect() {
            return true;
        }

        @Override
        protected boolean getConfiguredDragEnabled() {
            return true;
        }

        @Override
        protected int getConfiguredDragType() {
            return 2;
        }

        @Override
        protected int getConfiguredDropType() {
            return 2;
        }

        @Override
        protected void execNodeAction(ITreeNode node) throws ProcessingException {
            if (AbstractBookmarkTreeField.isBookmarkNode(node)) {
                Bookmark bm = (Bookmark)node.getCell().getValue();
                ClientSyncJob.getCurrentSession().getDesktop().activateBookmark(bm, false);
            }
        }

        @Override
        protected TransferObject execDrag(Collection<ITreeNode> nodes) throws ProcessingException {
            if (ACCESS.check((Permission)AbstractBookmarkTreeField.this.getUpdatePermission())) {
                return new JavaTransferObject(nodes);
            }
            return null;
        }

        @Override
        protected void execDrop(ITreeNode dropNode, TransferObject transfer) {
            if (transfer instanceof JavaTransferObject) {
                block19: {
                    try {
                        try {
                            AbstractBookmarkTreeField.this.getTree().setTreeChanging(true);
                            List elements = ((JavaTransferObject)transfer).getLocalObjectAsList(ITreeNode.class);
                            if (CollectionUtility.hasElements((Collection)elements)) {
                                boolean updateTree = false;
                                HashSet<ITreeNode> draggedFolders = new HashSet<ITreeNode>();
                                for (ITreeNode source : elements) {
                                    if (source == dropNode || source.getTree() != AbstractBookmarkTreeField.this.getTree()) continue;
                                    ITreeNode target = dropNode;
                                    if (AbstractBookmarkTreeField.isFolderNode(source) && AbstractBookmarkTreeField.isBookmarkNode(target)) {
                                        target = target.getParentNode();
                                    }
                                    if (AbstractBookmarkTreeField.isBookmarkNode(source) && AbstractBookmarkTreeField.isFolderNode(target)) {
                                        AbstractBookmarkTreeField.this.getTree().removeNode(source);
                                        AbstractBookmarkTreeField.this.getTree().addChildNode(target, source);
                                        updateTree = true;
                                        continue;
                                    }
                                    if (AbstractBookmarkTreeField.isBookmarkNode(source) && AbstractBookmarkTreeField.isBookmarkNode(target)) {
                                        AbstractBookmarkTreeField.this.getTree().removeNode(source);
                                        int pos = target.getChildNodeIndex();
                                        AbstractBookmarkTreeField.this.getTree().addChildNode(pos, target.getParentNode(), source);
                                        continue;
                                    }
                                    if (AbstractBookmarkTreeField.isFolderNode(source) && target == null) {
                                        AbstractBookmarkTreeField.this.getTree().removeNode(source);
                                        AbstractBookmarkTreeField.this.getTree().addChildNode(AbstractBookmarkTreeField.this.getTree().getRootNode(), source);
                                        continue;
                                    }
                                    if (!AbstractBookmarkTreeField.isFolderNode(source) || !AbstractBookmarkTreeField.isFolderNode(target)) continue;
                                    boolean parentWasDragged = false;
                                    for (ITreeNode parent : draggedFolders) {
                                        if (!AbstractBookmarkTreeField.this.getTree().isAncestorNodeOf(parent, source)) continue;
                                        parentWasDragged = true;
                                        draggedFolders.add(source);
                                    }
                                    if (parentWasDragged) continue;
                                    if (AbstractBookmarkTreeField.this.getTree().isAncestorNodeOf(source, target)) {
                                        ITreeNode sourceParent = source.getParentNode();
                                        if (sourceParent == null) continue;
                                        int dragPos = source.getChildNodeIndex();
                                        ITreeNode targetAncestor = target;
                                        ITreeNode targetAncestorWalkThrough = target;
                                        while (targetAncestorWalkThrough.getParentNode() != source) {
                                            if (!elements.contains(targetAncestor.getParentNode())) {
                                                targetAncestor = targetAncestorWalkThrough.getParentNode();
                                            }
                                            targetAncestorWalkThrough = targetAncestorWalkThrough.getParentNode();
                                        }
                                        AbstractBookmarkTreeField.this.getTree().removeNode(targetAncestor);
                                        AbstractBookmarkTreeField.this.getTree().removeNode(source);
                                        AbstractBookmarkTreeField.this.getTree().addChildNode(dragPos, sourceParent, targetAncestor);
                                        AbstractBookmarkTreeField.this.getTree().addChildNode(target, source);
                                        continue;
                                    }
                                    AbstractBookmarkTreeField.this.getTree().removeNode(source);
                                    AbstractBookmarkTreeField.this.getTree().addChildNode(target, source);
                                }
                                if (updateTree) {
                                    AbstractBookmarkTreeField.this.refreshBookmarkModel();
                                }
                            }
                        }
                        catch (ProcessingException e) {
                            e.printStackTrace();
                            AbstractBookmarkTreeField.this.getTree().setTreeChanging(false);
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        AbstractBookmarkTreeField.this.getTree().setTreeChanging(false);
                        throw throwable;
                    }
                    AbstractBookmarkTreeField.this.getTree().setTreeChanging(false);
                }
                try {
                    AbstractBookmarkTreeField.this.rebuildBookmarkModel();
                }
                catch (ProcessingException e) {
                    LOG.error(null, (Throwable)e);
                }
            }
        }

        private void addNewFolder(ITreeNode parentNode) throws ProcessingException {
            if (parentNode == null) {
                parentNode = this.getRootNode();
            }
            BookmarkFolderForm form = new BookmarkFolderForm();
            form.startModify();
            form.waitFor();
            if (form.isFormStored()) {
                FolderNode newNode = new FolderNode();
                BookmarkFolder bmFolder = new BookmarkFolder();
                bmFolder.setTitle((String)form.getNameField().getValue());
                newNode.getCellForUpdate().setValue(bmFolder);
                ITreeNode lastFolderNode = null;
                for (ITreeNode tmp : parentNode.getChildNodes()) {
                    if (!AbstractBookmarkTreeField.isFolderNode(tmp)) break;
                    lastFolderNode = tmp;
                }
                int pos = lastFolderNode != null ? lastFolderNode.getChildNodeIndex() + 1 : 0;
                AbstractBookmarkTreeField.this.getTree().addChildNode(pos, parentNode, newNode);
                AbstractBookmarkTreeField.this.rebuildBookmarkModel();
            }
        }

        @Order(value=11.0)
        public class NewChildFolderMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"NewBookmarkFolderMenu", (String[])new String[0]);
            }

            @Override
            protected void execPrepareAction() throws ProcessingException {
                ITreeNode node = Tree.this.getSelectedNode();
                this.setVisible(!AbstractBookmarkTreeField.isBookmarkNode(node));
                this.setVisiblePermission(AbstractBookmarkTreeField.this.getUpdatePermission());
            }

            @Override
            protected void execAction() throws ProcessingException {
                Tree.this.addNewFolder(Tree.this.getSelectedNode());
            }
        }

        @Order(value=10.0)
        public class NewRootFolderMenu
        extends AbstractMenu {
            @Override
            protected String getConfiguredText() {
                return ScoutTexts.get((String)"NewBookmarkFolderMenu", (String[])new String[0]);
            }

            @Override
            protected boolean getConfiguredSingleSelectionAction() {
                return false;
            }

            @Override
            protected boolean getConfiguredEmptySpaceAction() {
                return true;
            }

            @Override
            protected void execInitAction() throws ProcessingException {
                this.setVisiblePermission(AbstractBookmarkTreeField.this.getUpdatePermission());
            }

            @Override
            protected void execAction() throws ProcessingException {
                Tree.this.addNewFolder(null);
            }
        }

        @Order(value=20.0)
        public class Separator1Menu
        extends MenuSeparator {
            @Override
            protected void execPrepareAction() throws ProcessingException {
                ITreeNode node = Tree.this.getSelectedNode();
                this.setVisible(!AbstractBookmarkTreeField.isBookmarkNode(node));
                this.setVisiblePermission(AbstractBookmarkTreeField.this.getUpdatePermission());
            }
        }
    }
}

