/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.view.AbstractViewButton;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;

public abstract class AbstractOutlineViewButton
extends AbstractViewButton {
    private final IDesktop m_desktop;
    private final IOutline m_outline;

    public AbstractOutlineViewButton(IDesktop desktop, Class<? extends IOutline> outlineType) {
        super(false);
        this.m_desktop = desktop;
        IOutline outline = null;
        for (IOutline o : desktop.getAvailableOutlines()) {
            if (o.getClass() != outlineType) continue;
            outline = o;
            break;
        }
        this.m_outline = outline;
        if (this.m_desktop == null) {
            throw new IllegalArgumentException("Desktop can not be null");
        }
        if (this.m_outline == null) {
            throw new IllegalArgumentException("the outline type " + outlineType.getName() + " is not registered in the desktop");
        }
        this.callInitializer();
    }

    @Override
    protected void execInitAction() {
        this.setVisible(this.m_outline.isVisible());
        this.setEnabled(this.m_outline.isEnabled());
        this.setText(this.m_outline.getTitle());
        this.setIconId(this.m_outline.getIconId());
        this.setSelected(this.m_desktop.getOutline() == this.m_outline);
        this.m_desktop.addDesktopListener(new DesktopListener(){

            @Override
            public void desktopChanged(DesktopEvent e) {
                switch (e.getType()) {
                    case 200: {
                        AbstractOutlineViewButton.this.setSelected(e.getOutline() == AbstractOutlineViewButton.this.m_outline);
                    }
                }
            }
        });
        this.m_outline.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String n = e.getPropertyName();
                Object v = e.getNewValue();
                if (n.equals("visible")) {
                    AbstractOutlineViewButton.this.setVisible((Boolean)v);
                } else if (n.equals("enabled")) {
                    AbstractOutlineViewButton.this.setEnabled((Boolean)v);
                } else if (n.equals("title")) {
                    AbstractOutlineViewButton.this.setText((String)v);
                } else if (n.equals("iconId")) {
                    AbstractOutlineViewButton.this.setIconId((String)v);
                }
            }
        });
    }

    @Override
    protected void doActionInternal() throws ProcessingException {
        if (!this.isSelected()) {
            super.doActionInternal();
        }
    }

    @Override
    protected boolean getConfiguredToggleAction() {
        return true;
    }

    @Override
    protected final boolean getConfiguredEnabled() {
        return super.getConfiguredEnabled();
    }

    @Override
    protected final String getConfiguredIconId() {
        return super.getConfiguredIconId();
    }

    @Override
    protected final String getConfiguredText() {
        return super.getConfiguredText();
    }

    @Override
    protected final boolean getConfiguredVisible() {
        return super.getConfiguredVisible();
    }

    @Override
    protected void execAction() throws ProcessingException {
        if (this.isSelected()) {
            if (this.m_desktop.getOutline() != null && this.m_desktop.getOutline() == this.m_outline) {
                ITreeNode newSelectedNode;
                if (this.m_outline.isRootNodeVisible()) {
                    newSelectedNode = this.m_outline.getRootPage();
                } else {
                    newSelectedNode = this.m_outline.getSelectedNode();
                    while (newSelectedNode != null && newSelectedNode.getParentNode() != this.m_outline.getRootPage()) {
                        newSelectedNode = newSelectedNode.getParentNode();
                    }
                }
                this.m_outline.selectNode(newSelectedNode);
                if (this.m_outline.isRootNodeVisible()) {
                    this.m_outline.collapseAll(this.m_outline.getRootPage());
                    if (this.m_outline.getRootPage() instanceof AbstractPage && ((AbstractPage)this.m_outline.getRootPage()).isInitialExpanded()) {
                        this.m_outline.setNodeExpanded(this.m_outline.getRootPage(), true);
                    }
                } else {
                    for (IPage root : this.m_outline.getRootPage().getChildPages()) {
                        this.m_outline.collapseAll(root);
                    }
                    for (IPage root : this.m_outline.getRootPage().getChildPages()) {
                        if (!(root instanceof AbstractPage) || !((AbstractPage)root).isInitialExpanded()) continue;
                        this.m_outline.setNodeExpanded(root, true);
                    }
                }
            } else {
                this.m_desktop.setOutline(this.m_outline);
            }
        }
    }
}

