/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.commons.BeanUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.annotations.InjectFieldTo;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.Replace;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.IFormFieldInjection;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;

public class DefaultFormFieldInjection
implements IFormFieldInjection {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DefaultFormFieldInjection.class);
    private final Map<IFormField, Set<Class<? extends IFormField>>> m_replacingFormFieldsByContainer = new HashMap<IFormField, Set<Class<? extends IFormField>>>();
    private final Map<Class<?>, Class<? extends IFormField>> m_replacementMapping = new HashMap();
    private final ArrayList<Class<? extends IFormField>> m_injectedFieldList = new ArrayList();
    private final Object m_enclosingContext;
    private Set<Class<? extends IFormField>> m_injectingFields;
    private Set<Class<? extends IFormField>> m_replacingFields;

    public DefaultFormFieldInjection(Object enclosingContext) {
        this.m_enclosingContext = enclosingContext;
    }

    public void addField(Class<? extends IFormField> fieldClass) {
        if (fieldClass == null) {
            throw new IllegalArgumentException("fieldClass must not be null");
        }
        Replace replace = fieldClass.getAnnotation(Replace.class);
        InjectFieldTo injectFieldTo = fieldClass.getAnnotation(InjectFieldTo.class);
        if (replace == null && injectFieldTo == null) {
            LOG.warn("Ignoring field [" + fieldClass + "] since neither @" + InjectFieldTo.class.getSimpleName() + " nor @" + Replace.class.getSimpleName() + " is declared.");
            return;
        }
        if (replace != null && injectFieldTo != null) {
            LOG.warn("@" + InjectFieldTo.class.getSimpleName() + " annotation is ignored since @" + Replace.class.getSimpleName() + " is available as well on class [" + fieldClass + "]. You should remove one of both annotations.");
        } else if (injectFieldTo != null && !ICompositeField.class.isAssignableFrom(injectFieldTo.value())) {
            LOG.warn("Ignoring field [" + fieldClass + "] since it is not injected into an " + ICompositeField.class.getSimpleName() + ", but @" + InjectFieldTo.class.getSimpleName() + "(" + injectFieldTo.value() + ")");
            return;
        }
        this.m_injectedFieldList.add(fieldClass);
        this.m_injectingFields = null;
        this.m_replacingFields = null;
    }

    public void addFields(Class<? extends IFormField>[] fieldClasses) {
        Class<? extends IFormField>[] classArray = fieldClasses;
        int n = fieldClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends IFormField> c = classArray[n2];
            this.addField(c);
            ++n2;
        }
    }

    public Map<Class<?>, Class<? extends IFormField>> getReplacementMapping() {
        if (this.m_replacementMapping.isEmpty()) {
            return null;
        }
        return this.m_replacementMapping;
    }

    private void ensurePrepared() {
        if (this.m_injectingFields == null || this.m_replacingFields == null) {
            this.prepare();
        }
    }

    private void prepare() {
        this.m_injectingFields = new HashSet<Class<? extends IFormField>>();
        this.m_replacingFields = new HashSet<Class<? extends IFormField>>();
        for (Class<? extends IFormField> f : this.m_injectedFieldList) {
            if (f.isAnnotationPresent(Replace.class)) {
                this.m_replacingFields.add(f);
                continue;
            }
            if (!f.isAnnotationPresent(InjectFieldTo.class)) continue;
            this.m_injectingFields.add(f);
        }
        if (!this.m_replacingFields.isEmpty()) {
            this.m_replacingFields = ConfigurationUtility.getReplacingLeafClasses(new ArrayList<Class<? extends IFormField>>(this.m_replacingFields));
        }
        if (!this.m_injectingFields.isEmpty() && !this.m_replacingFields.isEmpty()) {
            HashSet<Class<? extends IFormField>> replacingInjectedFields = new HashSet<Class<? extends IFormField>>();
            for (Class<? extends IFormField> replacingField : this.m_replacingFields) {
                Iterator<Class<? extends IFormField>> it = this.m_injectingFields.iterator();
                while (it.hasNext()) {
                    Class<? extends IFormField> injectedField = it.next();
                    if (!injectedField.isAssignableFrom(replacingField)) continue;
                    it.remove();
                    replacingInjectedFields.add(replacingField);
                }
            }
            this.m_replacingFields.removeAll(replacingInjectedFields);
            this.m_injectingFields.addAll(replacingInjectedFields);
        }
    }

    @Override
    public void filterFields(IFormField container, List<Class<? extends IFormField>> fieldList) {
        if (container == null || fieldList == null || fieldList.isEmpty()) {
            return;
        }
        this.ensurePrepared();
        if (this.m_replacingFields.isEmpty()) {
            return;
        }
        HashSet<Class<? extends IFormField>> replacingFields = new HashSet<Class<? extends IFormField>>();
        Iterator<Class<? extends IFormField>> it = fieldList.iterator();
        block0: while (it.hasNext()) {
            Class<? extends IFormField> field = it.next();
            for (Class<? extends IFormField> replacingField : this.m_replacingFields) {
                if (!field.isAssignableFrom(replacingField)) continue;
                replacingFields.add(replacingField);
                it.remove();
                continue block0;
            }
        }
        if (!replacingFields.isEmpty()) {
            this.m_replacingFormFieldsByContainer.put(container, replacingFields);
        }
    }

    @Override
    public void injectFields(IFormField container, List<IFormField> fieldList) {
        if (container == null || fieldList == null || this.m_injectedFieldList.isEmpty()) {
            return;
        }
        this.ensurePrepared();
        Set<Class<? extends IFormField>> replacingFields = this.m_replacingFormFieldsByContainer.remove(container);
        if (replacingFields != null) {
            for (Class<? extends IFormField> replacingField : replacingFields) {
                Order order = this.getOrder(replacingField);
                this.createAndInsertField(container, fieldList, replacingField, order);
                this.addReplacementMappings(replacingField);
            }
        }
        Iterator<Class<? extends IFormField>> iterator = this.m_injectingFields.iterator();
        while (iterator.hasNext()) {
            Class<? extends IFormField> injectedField;
            Class<? extends IFormField> tmpClass = injectedField = iterator.next();
            while (tmpClass.isAnnotationPresent(Replace.class)) {
                tmpClass = tmpClass.getSuperclass();
            }
            if (tmpClass.getAnnotation(InjectFieldTo.class).value() != container.getClass()) continue;
            Order order = this.getOrder(injectedField);
            this.createAndInsertField(container, fieldList, injectedField, order);
            this.addReplacementMappings(injectedField);
        }
    }

    private void addReplacementMappings(Class<? extends IFormField> field) {
        Class<? extends IFormField> tmpClass = field;
        while (tmpClass.isAnnotationPresent(Replace.class)) {
            tmpClass = tmpClass.getSuperclass();
            this.m_replacementMapping.put(tmpClass, field);
        }
    }

    private void createAndInsertField(IFormField container, List<IFormField> list, Class<? extends IFormField> fieldClass, Order order) {
        for (IFormField f : list) {
            if (f.getClass() != fieldClass) continue;
            return;
        }
        try {
            IFormField f;
            f = this.newInnerInstance(container, fieldClass);
            if (order != null) {
                double orderValue = order.value();
                int i = 0;
                int n = list.size();
                while (i < n) {
                    Class<?> existingClazz = list.get(i).getClass();
                    Order existingClazzOrder = this.getOrder(existingClazz);
                    if (existingClazzOrder != null && orderValue < existingClazzOrder.value()) {
                        list.add(i, f);
                        return;
                    }
                    ++i;
                }
            }
            list.add(f);
        }
        catch (Exception e) {
            LOG.error("exception while injecting a field", (Throwable)e);
        }
    }

    private Order getOrder(Class<?> c) {
        Order order = c.getAnnotation(Order.class);
        while (order == null && c.isAnnotationPresent(Replace.class)) {
            c = c.getSuperclass();
            order = c.getAnnotation(Order.class);
        }
        return order;
    }

    private <T> T newInnerInstance(IFormField container, Class<T> fieldClass) throws Exception {
        try {
            Object t = BeanUtility.createInstance(fieldClass, (Object[])new Object[]{this.m_enclosingContext, container});
            if (t != null) {
                return (T)t;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return (T)ConfigurationUtility.newInnerInstance((Object)this.m_enclosingContext, fieldClass);
    }
}

