/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.groupbox;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.keystroke.DefaultFormEnterKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.DefaultFormEscapeKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractCompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBoxBodyGrid;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBoxUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.GroupBoxProcessButtonGrid;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.VerticalSmartGroupBoxBodyGrid;

@ClassId(value="6a093505-c2b1-4df2-84d6-e799f91e6e7c")
public abstract class AbstractGroupBox
extends AbstractCompositeField
implements IGroupBox {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractGroupBox.class);
    private IGroupBoxUIFacade m_uiFacade;
    private boolean m_mainBoxFlag = false;
    private int m_gridColumnCountHint;
    private boolean m_scrollable;
    private List<IFormField> m_controlFields;
    private List<IGroupBox> m_groupBoxes;
    private List<IButton> m_customButtons;
    private List<IButton> m_systemButtons;
    private IGroupBoxBodyGrid m_bodyGrid;
    private GroupBoxProcessButtonGrid m_customProcessButtonGrid;
    private GroupBoxProcessButtonGrid m_systemProcessButtonGrid;

    public AbstractGroupBox() {
        this(true);
    }

    public AbstractGroupBox(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected boolean getConfiguredGridUseUiHeight() {
        return true;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=200.0)
    protected int getConfiguredGridColumnCount() {
        return -1;
    }

    @ConfigProperty(value="GROUP_BOX_BODY_GRID")
    @Order(value=210.0)
    protected Class<? extends IGroupBoxBodyGrid> getConfiguredBodyGrid() {
        return VerticalSmartGroupBoxBodyGrid.class;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=230.0)
    protected boolean getConfiguredBorderVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=231.0)
    protected boolean getConfiguredExpandable() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=232.0)
    protected boolean getConfiguredExpanded() {
        return true;
    }

    @ConfigProperty(value="BORDER_DECORATION")
    @Order(value=233.0)
    protected String getConfiguredBorderDecoration() {
        return "auto";
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=240.0)
    protected String getConfiguredBackgroundImageName() {
        return null;
    }

    @ConfigProperty(value="HORIZONTAL_ALIGNMENT")
    @Order(value=250.0)
    protected int getConfiguredBackgroundImageHorizontalAlignment() {
        return 0;
    }

    @ConfigProperty(value="VERTICAL_ALIGNMENT")
    @Order(value=260.0)
    protected int getConfiguredBackgroundImageVerticalAlignment() {
        return 0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    protected boolean getConfiguredScrollable() {
        return false;
    }

    @Override
    protected int getConfiguredGridW() {
        return 0;
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        Class<? extends IGroupBoxBodyGrid> bodyGridClazz = this.getConfiguredBodyGrid();
        if (bodyGridClazz != null) {
            try {
                IGroupBoxBodyGrid bodyGrid = bodyGridClazz.newInstance();
                this.setBodyGrid(bodyGrid);
            }
            catch (InstantiationException e) {
                LOG.warn(null, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.warn(null, (Throwable)e);
            }
        }
        this.m_customProcessButtonGrid = new GroupBoxProcessButtonGrid(this, true, false);
        this.m_systemProcessButtonGrid = new GroupBoxProcessButtonGrid(this, false, true);
        super.initConfig();
        ArrayList<IFormField> controlList = new ArrayList<IFormField>();
        ArrayList<IGroupBox> groupList = new ArrayList<IGroupBox>();
        ArrayList<IButton> customButtonList = new ArrayList<IButton>();
        ArrayList<IButton> systemButtonList = new ArrayList<IButton>();
        for (IFormField field : this.getFields()) {
            if (field instanceof IGroupBox) {
                groupList.add((IGroupBox)field);
                controlList.add(field);
                continue;
            }
            if (field instanceof IButton) {
                IButton b = (IButton)field;
                if (b.isProcessButton()) {
                    if (b.getSystemType() != 0) {
                        systemButtonList.add((IButton)field);
                        continue;
                    }
                    customButtonList.add((IButton)field);
                    continue;
                }
                controlList.add(field);
                continue;
            }
            controlList.add(field);
        }
        this.m_controlFields = controlList;
        this.m_groupBoxes = groupList;
        this.m_customButtons = customButtonList;
        this.m_systemButtons = systemButtonList;
        this.setExpandable(this.getConfiguredExpandable());
        this.setExpanded(this.getConfiguredExpanded());
        this.setBorderVisible(this.getConfiguredBorderVisible());
        this.setBorderDecoration(this.getConfiguredBorderDecoration());
        this.setGridColumnCountHint(this.getConfiguredGridColumnCount());
        this.setBackgroundImageName(this.getConfiguredBackgroundImageName());
        this.setBackgroundImageHorizontalAlignment(this.getConfiguredBackgroundImageHorizontalAlignment());
        this.setBackgroundImageVerticalAlignment(this.getConfiguredBackgroundImageVerticalAlignment());
        this.setScrollable(this.getConfiguredScrollable());
    }

    @Override
    public List<IKeyStroke> getContributedKeyStrokes() {
        ArrayList<IKeyStroke> list = new ArrayList<IKeyStroke>(2);
        if (this.isMainBox() && this.getForm() != null && this.getForm().getOuterForm() == null) {
            boolean hasEnter = false;
            boolean hasEscape = false;
            for (IKeyStroke ks : this.getLocalKeyStrokes()) {
                if ("enter".equalsIgnoreCase(ks.getKeyStroke())) {
                    hasEnter = true;
                }
                if (!"escape".equalsIgnoreCase(ks.getKeyStroke())) continue;
                hasEscape = true;
            }
            if (!hasEnter) {
                try {
                    DefaultFormEnterKeyStroke enterKeyStroke = new DefaultFormEnterKeyStroke(this.getForm());
                    enterKeyStroke.initAction();
                    list.add(enterKeyStroke);
                }
                catch (ProcessingException e) {
                    LOG.error("could not initialize enter key stroke.", (Throwable)e);
                }
            }
            if (!hasEscape) {
                try {
                    DefaultFormEscapeKeyStroke escKeyStroke = new DefaultFormEscapeKeyStroke(this.getForm());
                    escKeyStroke.initAction();
                    list.add(escKeyStroke);
                }
                catch (ProcessingException e) {
                    LOG.error("could not initialize esc key stroke.", (Throwable)e);
                }
            }
        }
        return list;
    }

    @Override
    public void rebuildFieldGrid() {
        this.m_bodyGrid.validate(this);
        this.m_customProcessButtonGrid.validate();
        this.m_systemProcessButtonGrid.validate();
        if (this.isInitialized() && this.getForm() != null) {
            this.getForm().structureChanged(this);
        }
    }

    @Override
    public boolean isMainBox() {
        return this.m_mainBoxFlag;
    }

    @Override
    public void setMainBox(boolean b) {
        this.m_mainBoxFlag = b;
    }

    @Override
    public int getGroupBoxIndex(IGroupBox groupBox) {
        return this.m_groupBoxes.indexOf(groupBox);
    }

    @Override
    public int getCustomProcessButtonCount() {
        return this.m_customButtons.size();
    }

    @Override
    public int getGroupBoxCount() {
        return this.m_groupBoxes.size();
    }

    @Override
    public int getSystemProcessButtonCount() {
        return this.m_systemButtons.size();
    }

    @Override
    public List<IGroupBox> getGroupBoxes() {
        return CollectionUtility.arrayList(this.m_groupBoxes);
    }

    @Override
    public List<IFormField> getControlFields() {
        return CollectionUtility.arrayList(this.m_controlFields);
    }

    @Override
    public List<IButton> getCustomProcessButtons() {
        return CollectionUtility.arrayList(this.m_customButtons);
    }

    @Override
    public List<IButton> getSystemProcessButtons() {
        return CollectionUtility.arrayList(this.m_systemButtons);
    }

    public void setBodyGrid(IGroupBoxBodyGrid bodyGrid) {
        this.m_bodyGrid = bodyGrid;
    }

    @Override
    public IGroupBoxBodyGrid getBodyGrid() {
        return this.m_bodyGrid;
    }

    @Override
    public final int getGridColumnCount() {
        return this.m_bodyGrid.getGridColumnCount();
    }

    @Override
    public final int getGridRowCount() {
        return this.m_bodyGrid.getGridRowCount();
    }

    @Override
    public void setGridColumnCountHint(int c) {
        this.m_gridColumnCountHint = c;
        if (this.isInitialized()) {
            this.rebuildFieldGrid();
        }
    }

    @Override
    public int getGridColumnCountHint() {
        return this.m_gridColumnCountHint;
    }

    @Override
    public boolean isScrollable() {
        return this.m_scrollable;
    }

    @Override
    public void setScrollable(boolean scrollable) {
        if (this.m_scrollable != scrollable) {
            this.m_scrollable = scrollable;
            if (this.m_scrollable) {
                GridData gd = this.getGridDataHints();
                if (gd.weightY <= 0.0) {
                    gd.weightY = 1.0;
                    this.setGridDataHints(gd);
                }
            }
        }
    }

    @Override
    protected void handleFieldVisibilityChanged() {
        super.handleFieldVisibilityChanged();
        if (this.isInitialized()) {
            this.rebuildFieldGrid();
        }
    }

    @Override
    public boolean isBorderVisible() {
        return this.propertySupport.getPropertyBool("borderVisible");
    }

    @Override
    public void setBorderVisible(boolean b) {
        this.propertySupport.setPropertyBool("borderVisible", b);
    }

    @Override
    public String getBorderDecoration() {
        return this.propertySupport.getPropertyString("borderDecoration");
    }

    @Override
    public void setBorderDecoration(String s) {
        this.propertySupport.setPropertyString("borderDecoration", s);
    }

    @Override
    public boolean isExpandable() {
        return this.propertySupport.getPropertyBool("expandable");
    }

    @Override
    public void setExpandable(boolean b) {
        this.propertySupport.setPropertyBool("expandable", b);
    }

    @Override
    public boolean isExpanded() {
        return this.propertySupport.getPropertyBool("expanded");
    }

    @Override
    public void setExpanded(boolean b) {
        this.propertySupport.setPropertyBool("expanded", b);
    }

    @Override
    public IGroupBoxUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public void setBackgroundImageName(String imageName) {
        this.propertySupport.setPropertyString("backgroundImageName", imageName);
    }

    @Override
    public String getBackgroundImageName() {
        return this.propertySupport.getPropertyString("backgroundImageName");
    }

    @Override
    public void setBackgroundImageVerticalAlignment(int a) {
        this.propertySupport.setPropertyInt("backgroundImageVerticalAlignment", a);
    }

    @Override
    public int getBackgroundImageVerticalAlignment() {
        return this.propertySupport.getPropertyInt("backgroundImageVerticalAlignment");
    }

    @Override
    public void setBackgroundImageHorizontalAlignment(int a) {
        this.propertySupport.setPropertyInt("backgroundImageHorizontalAlignment", a);
    }

    @Override
    public int getBackgroundImageHorizontalAlignment() {
        return this.propertySupport.getPropertyInt("backgroundImageHorizontalAlignment");
    }

    private class P_UIFacade
    implements IGroupBoxUIFacade {
        private P_UIFacade() {
        }

        @Override
        public void setExpandedFromUI(boolean expanded) {
            AbstractGroupBox.this.setExpanded(expanded);
        }
    }
}

