/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.imagebox;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.form.fields.imagebox.IImageField;
import org.eclipse.scout.rt.shared.data.basic.BoundsSpec;

public class ImageFieldEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    private int m_type;
    private List<IMenu> m_popupMenus;
    private BoundsSpec m_rect;
    public static final int TYPE_ZOOM_RECTANGLE = 10;
    public static final int TYPE_AUTO_FIT = 20;
    public static final int TYPE_POPUP = 30;

    public ImageFieldEvent(IImageField source, int type) {
        super(source);
        this.m_type = type;
    }

    public ImageFieldEvent(IImageField source, int type, BoundsSpec r) {
        super(source);
        this.m_type = type;
        this.m_rect = r;
    }

    public int getType() {
        return this.m_type;
    }

    public IImageField getImageField() {
        return (IImageField)this.getSource();
    }

    public void addPopupMenu(IMenu menu) {
        if (menu != null) {
            if (this.m_popupMenus == null) {
                this.m_popupMenus = new ArrayList<IMenu>();
            }
            this.m_popupMenus.add(menu);
        }
    }

    public void addPopupMenus(List<? extends IMenu> menus) {
        if (menus != null) {
            if (this.m_popupMenus == null) {
                this.m_popupMenus = new ArrayList<IMenu>();
            }
            this.m_popupMenus.addAll(CollectionUtility.arrayListWithoutNullElements(menus));
        }
    }

    public List<IMenu> getPopupMenus() {
        return CollectionUtility.arrayList(this.m_popupMenus);
    }

    public int getPopupMenuCount() {
        return CollectionUtility.size(this.m_popupMenus);
    }

    public BoundsSpec getZoomRectangle() {
        return this.m_rect;
    }
}

