/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.sequencebox.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.internal.GridDataBuilder;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;

public class SequenceBoxGrid {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SequenceBoxGrid.class);
    private ISequenceBox m_rangeBox = null;
    private List<IFormField> m_fields;
    private int m_gridColumns;
    private int m_gridRows;

    public SequenceBoxGrid(ISequenceBox rangeBox) {
        this.m_rangeBox = rangeBox;
    }

    public void validate() {
        this.m_gridColumns = 0;
        this.m_gridRows = 0;
        ArrayList<IFormField> list = new ArrayList<IFormField>();
        for (IFormField f : this.m_rangeBox.getFields()) {
            if (f.isVisible()) {
                list.add(f);
                continue;
            }
            GridData data = GridDataBuilder.createFromHints(f, 1);
            f.setGridDataInternal(data);
        }
        this.layoutStatic(list);
    }

    private void layoutStatic(List<IFormField> fields) {
        int x = 0;
        for (IFormField field : fields) {
            GridData data = GridDataBuilder.createFromHints(field, 1);
            data.x = x;
            data.y = 0;
            if (data.weightX < 0.0) {
                data.weightX = field instanceof IButton ? 0.0 : (double)data.w;
            }
            field.setGridDataInternal(data);
            x += data.w;
            this.m_gridRows = Math.max(this.m_gridRows, data.h);
        }
        this.m_gridColumns = x;
    }

    public int getGridColumnCount() {
        return this.m_gridColumns;
    }

    public int getGridRowCount() {
        return this.m_gridRows;
    }
}

