/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.treebox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.services.lookup.FormFieldProvisioningContext;
import org.eclipse.scout.rt.client.services.lookup.ILookupCallProvisioningService;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNodeBuilder;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNodeFilter;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeVisitor;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.AbstractTreeBoxFilterBox;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.ActiveOrCheckedNodesFilter;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.CheckedNodesFilter;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.ITreeBox;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractValueFieldData;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

@ClassId(value="5648579d-1968-47be-a0c9-a8c846d2caf4")
public abstract class AbstractTreeBox<T>
extends AbstractValueField<Set<T>>
implements ITreeBox<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractTreeBox.class);
    private ITree m_tree;
    private ILookupCall<T> m_lookupCall;
    private Class<? extends ICodeType<?, T>> m_codeTypeClass;
    private boolean m_valueTreeSyncActive;
    private boolean m_autoExpandAll;
    private boolean m_autoCheckChildNodes;
    private boolean m_loadIncremental;
    private ITreeNodeFilter m_activeNodesFilter;
    private ITreeNodeFilter m_checkedNodesFilter;
    private List<IFormField> m_fields;

    public AbstractTreeBox() {
        this(true);
    }

    public AbstractTreeBox(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigOperation
    @Order(value=240.0)
    protected void execLoadChildNodes(ITreeNode parentNode) throws ProcessingException {
        List<ITreeNode> children = this.isLoadIncremental() ? this.callChildLookup(parentNode) : this.callCompleteTreeLookup();
        this.m_tree.removeAllChildNodes(parentNode);
        this.m_tree.addChildNodes(parentNode, children);
        parentNode.setChildrenLoaded(true);
    }

    @ConfigProperty(value="LOOKUP_CALL")
    @Order(value=240.0)
    @ValidationRule(value="lookupCall")
    protected Class<? extends ILookupCall<T>> getConfiguredLookupCall() {
        return null;
    }

    @ConfigProperty(value="CODE_TYPE")
    @Order(value=250.0)
    @ValidationRule(value="codeType")
    protected Class<? extends ICodeType<?, T>> getConfiguredCodeType() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=230.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=260.0)
    protected boolean getConfiguredAutoLoad() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    protected boolean getConfiguredLoadIncremental() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=280.0)
    protected boolean getConfiguredAutoExpandAll() {
        return false;
    }

    @Override
    @Order(value=210.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredAutoAddDefaultMenus() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=290.0)
    protected boolean getConfiguredFilterActiveNodes() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=300.0)
    protected boolean getConfiguredFilterCheckedNodes() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=310.0)
    protected boolean getConfiguredAutoCheckChildNodes() {
        return false;
    }

    @Override
    protected double getConfiguredGridWeightY() {
        return 1.0;
    }

    private List<Class<? extends IFormField>> getConfiguredFields() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IFormField.class);
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation((List)filtered, IFormField.class);
    }

    @ConfigOperation
    @Order(value=230.0)
    protected void execPrepareLookup(ILookupCall<T> call, ITreeNode parent) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=240.0)
    protected void execFilterLookupResult(ILookupCall<T> call, List<ILookupRow<T>> result) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=250.0)
    protected void execFilterNewNode(ITreeNode newNode, int treeLevel) throws ProcessingException {
    }

    private Class<? extends ITree> getConfiguredTree() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List f = ConfigurationUtility.filterClasses((Class[])dca, ITree.class);
        if (f.size() == 1) {
            return (Class)CollectionUtility.firstElement((List)f);
        }
        for (Class c : f) {
            if (c.getDeclaringClass() == AbstractTreeBox.class) continue;
            return c;
        }
        return null;
    }

    @Override
    protected void execChangedMasterValue(Object newMasterValue) throws ProcessingException {
        this.setValue(null);
        this.loadRootNode();
    }

    @Override
    protected void initConfig() {
        this.m_fields = CollectionUtility.emptyArrayList();
        super.initConfig();
        this.setFilterActiveNodes(this.getConfiguredFilterActiveNodes());
        this.setFilterActiveNodesValue(TriState.TRUE);
        this.setFilterCheckedNodes(this.getConfiguredFilterCheckedNodes());
        this.setFilterCheckedNodesValue(this.getConfiguredFilterCheckedNodes());
        this.setAutoExpandAll(this.getConfiguredAutoExpandAll());
        this.setAutoCheckChildNodes(this.getConfiguredAutoCheckChildNodes());
        this.setLoadIncremental(this.getConfiguredLoadIncremental());
        try {
            this.m_tree = (ITree)ConfigurationUtility.newInnerInstance((Object)this, this.getConfiguredTree());
            if (this.m_tree instanceof AbstractTree) {
                ((AbstractTree)this.m_tree).setContainerInternal(this);
            }
            this.m_tree.setRootNode(this.getTreeNodeBuilder().createTreeNode((ILookupRow<T>)new LookupRow(null, "Root"), 0, false));
            this.m_tree.setAutoDiscardOnDelete(false);
            this.updateActiveNodesFilter();
            this.updateCheckedNodesFilter();
            this.m_tree.addTreeListener(new TreeAdapter(){

                @Override
                public void treeChanged(TreeEvent e) {
                    switch (e.getType()) {
                        case 40: {
                            if (AbstractTreeBox.this.getTree().isCheckable()) break;
                            AbstractTreeBox.this.syncTreeToValue();
                            break;
                        }
                        case 20: {
                            if (!AbstractTreeBox.this.getTree().isCheckable()) break;
                            if (AbstractTreeBox.this.isAutoCheckChildNodes() && e.getNodes() != null) {
                                for (ITreeNode node : e.getNodes()) {
                                    AbstractTreeBox.this.execAutoCheckChildNodes(node, node.isChecked());
                                }
                            }
                            AbstractTreeBox.this.syncTreeToValue();
                        }
                    }
                }
            });
            this.m_tree.setEnabled(this.isEnabled());
            if (this.getConfiguredIconId() != null) {
                this.m_tree.setIconId(this.getConfiguredIconId());
            }
        }
        catch (Exception e) {
            LOG.warn(null, (Throwable)e);
        }
        if (this.getConfiguredLookupCall() != null) {
            try {
                ILookupCall<T> call = this.getConfiguredLookupCall().newInstance();
                this.setLookupCall(call);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
        }
        if (this.getConfiguredCodeType() != null) {
            this.setCodeTypeClass(this.getConfiguredCodeType());
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (AbstractTreeBox.this.m_tree != null) {
                    String name = e.getPropertyName();
                    if ("enabled".equals(name)) {
                        AbstractTreeBox.this.m_tree.setEnabled(AbstractTreeBox.this.isEnabled());
                    } else if ("filterCheckedNodesValue".equals(name)) {
                        AbstractTreeBox.this.updateCheckedNodesFilter();
                    } else if ("filterActiveNodesValue".equals(name)) {
                        AbstractTreeBox.this.updateActiveNodesFilter();
                    }
                }
            }
        });
        ArrayList<IFormField> fieldList = new ArrayList<IFormField>();
        for (Class<IFormField> fieldClazz : this.getConfiguredFields()) {
            try {
                fieldList.add((IFormField)ConfigurationUtility.newInnerInstance((Object)this, fieldClazz));
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("field: " + fieldClazz.getName(), t));
            }
        }
        for (IFormField f : fieldList) {
            f.setParentFieldInternal(this);
        }
        this.m_fields = fieldList;
    }

    @Override
    protected void initFieldInternal() throws ProcessingException {
        this.getTree().initTree();
        if (this.getConfiguredAutoLoad()) {
            try {
                this.setValueChangeTriggerEnabled(false);
                this.loadRootNode();
            }
            finally {
                this.setValueChangeTriggerEnabled(true);
            }
        }
        super.initFieldInternal();
    }

    @Override
    protected void disposeFieldInternal() {
        super.disposeFieldInternal();
        this.getTree().disposeTree();
    }

    public TreeBoxFilterBox getTreeBoxFilterBox() {
        return this.getFieldByClass((Class)TreeBoxFilterBox.class);
    }

    @Override
    public final ITree getTree() {
        return this.m_tree;
    }

    @Override
    public void loadRootNode() throws ProcessingException {
        this.loadChildNodes(this.m_tree.getRootNode());
    }

    @Override
    public final void loadChildNodes(ITreeNode parentNode) throws ProcessingException {
        if (this.m_tree != null) {
            try {
                this.m_valueTreeSyncActive = true;
                this.m_tree.setTreeChanging(true);
                this.execLoadChildNodes(parentNode);
                if (!this.isLoadIncremental()) {
                    ITreeVisitor v = new ITreeVisitor(){

                        @Override
                        public boolean visit(ITreeNode node) {
                            if (node.getChildNodeCount() == 0) {
                                node.setLeafInternal(true);
                            } else {
                                node.setLeafInternal(false);
                            }
                            return true;
                        }
                    };
                    this.getTree().visitNode(this.getTree().getRootNode(), v);
                }
                if (this.isAutoExpandAll()) {
                    this.m_tree.expandAll(parentNode);
                }
            }
            finally {
                this.m_tree.setTreeChanging(false);
                this.m_valueTreeSyncActive = false;
            }
            this.syncValueToTree();
        }
    }

    public AbstractTreeNodeBuilder<T> getTreeNodeBuilder() {
        return new P_TreeNodeBuilder();
    }

    private void prepareLookupCall(ILookupCall<T> call, ITreeNode parent) throws ProcessingException {
        this.prepareLookupCallInternal(call, parent);
        this.execPrepareLookup(call, parent);
    }

    private void prepareLookupCallInternal(ILookupCall<T> call, ITreeNode parent) {
        if (parent != null) {
            call.setRec(parent.getPrimaryKey());
        } else {
            call.setRec(null);
        }
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
    }

    @Override
    public final ILookupCall<T> getLookupCall() {
        return this.m_lookupCall;
    }

    @Override
    public void setLookupCall(ILookupCall<T> call) {
        this.m_lookupCall = call;
    }

    @Override
    public Class<? extends ICodeType<?, T>> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    @Override
    public void setCodeTypeClass(Class<? extends ICodeType<?, T>> codeTypeClass) {
        this.m_codeTypeClass = codeTypeClass;
        this.m_lookupCall = null;
        if (this.m_codeTypeClass != null) {
            this.m_lookupCall = CodeLookupCall.newInstanceByService(this.m_codeTypeClass);
        }
    }

    @Override
    public List<ITreeNode> callChildLookup(ITreeNode parentNode) throws ProcessingException {
        List<ILookupRow<T>> data = null;
        ILookupCall<T> call = this.getLookupCall();
        if (call != null) {
            call = ((ILookupCallProvisioningService)SERVICES.getService(ILookupCallProvisioningService.class)).newClonedInstance(call, new FormFieldProvisioningContext(this));
            this.prepareLookupCall(call, parentNode);
            data = call.getDataByRec();
            data = this.filterLookupResult(call, data);
            ArrayList<ITreeNode> subTree = new ArrayList<ITreeNode>(this.getTreeNodeBuilder().createTreeNodes(data, 0, false));
            this.filterNewNodesRec(subTree, parentNode != null ? parentNode.getTreeLevel() + 1 : 0);
            return subTree;
        }
        return CollectionUtility.emptyArrayList();
    }

    @Override
    public List<ITreeNode> callCompleteTreeLookup() throws ProcessingException {
        List<ILookupRow<T>> data = null;
        ILookupCall<T> call = this.getLookupCall();
        if (call != null) {
            call = ((ILookupCallProvisioningService)SERVICES.getService(ILookupCallProvisioningService.class)).newClonedInstance(call, new FormFieldProvisioningContext(this));
            this.prepareLookupCall(call, null);
            data = call.getDataByAll();
            data = this.filterLookupResult(call, data);
            if (data != null && data.size() > 1000) {
                LOG.warn("TreeBox " + this.getClass().getSimpleName() + " has loadIncremental=false but produced more than 1000 rows; check if this is intended.");
            }
            List<ITreeNode> subTree = this.getTreeNodeBuilder().createTreeNodes(data, 0, true);
            this.filterNewNodesRec(subTree, 0);
            return subTree;
        }
        return CollectionUtility.emptyArrayList();
    }

    private List<? extends ILookupRow<T>> filterLookupResult(ILookupCall<T> call, List<? extends ILookupRow<T>> data) throws ProcessingException {
        ArrayList result = CollectionUtility.arrayList(data);
        this.execFilterLookupResult(call, result);
        Iterator resultIt = result.iterator();
        while (resultIt.hasNext()) {
            ILookupRow row = (ILookupRow)resultIt.next();
            if (row == null) {
                resultIt.remove();
                continue;
            }
            if (row.getKey() != null) continue;
            LOG.warn("The key of a lookup row may not be null. Row has been removed for tree box '" + this.getClass().getName() + "'.");
            resultIt.remove();
        }
        return result;
    }

    private void filterNewNodesRec(List<ITreeNode> nodes, int level) throws ProcessingException {
        if (nodes != null) {
            for (ITreeNode node : nodes) {
                if (node == null) continue;
                this.execFilterNewNode(node, level);
                this.filterNewNodesRec(node.getChildNodes(), level + 1);
            }
        }
    }

    @Override
    protected void valueChangedInternal() {
        super.valueChangedInternal();
        this.syncValueToTree();
    }

    @Override
    protected String formatValueInternal(Set<T> validValue) {
        if (validValue == null || validValue.size() == 0) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        List<ITreeNode> nodes = this.getTree().findNodes(validValue);
        if (nodes != null && !nodes.isEmpty()) {
            Iterator nodeIt = nodes.iterator();
            b.append(((ITreeNode)nodeIt.next()).getCell().getText());
            while (nodeIt.hasNext()) {
                b.append(", ").append(((ITreeNode)nodeIt.next()).getCell().getText());
            }
        }
        return b.toString();
    }

    @Override
    protected final Set<T> validateValueInternal(Set<T> rawValue0) throws ProcessingException {
        HashSet rawValue = CollectionUtility.hashSetWithoutNullElements(rawValue0);
        return this.doValidateValueInternal(rawValue);
    }

    protected Set<T> doValidateValueInternal(Set<T> rawValue) throws ProcessingException {
        if (CollectionUtility.isEmpty(rawValue)) {
            return rawValue;
        }
        ITree tree = this.getTree();
        if (tree != null && (tree.isCheckable() && !tree.isMultiCheck() || !tree.isCheckable() && !tree.isMultiSelect()) && rawValue.size() > 1) {
            LOG.warn(String.valueOf(this.getClass().getName()) + " only accepts a single value. Got " + rawValue.toString() + ". Using only first value.");
            return CollectionUtility.hashSet((Object)CollectionUtility.firstElement(rawValue));
        }
        return rawValue;
    }

    @Override
    public boolean isContentValid() {
        boolean valid = super.isContentValid();
        if (valid && this.isMandatory() && (this.getValue() == null || this.getValue().isEmpty())) {
            return false;
        }
        return valid;
    }

    @Override
    public Set<T> getValue() {
        return CollectionUtility.hashSet((Collection)((Collection)super.getValue()));
    }

    @Override
    public Set<T> getInitValue() {
        return CollectionUtility.hashSet((Collection)((Collection)super.getInitValue()));
    }

    @Override
    public T getSingleValue() {
        return (T)CollectionUtility.firstElement((Collection)((Collection)super.getValue()));
    }

    @Override
    public void setSingleValue(T value) {
        HashSet<T> valueSet = new HashSet<T>();
        if (value != null) {
            valueSet.add(value);
        }
        this.setValue(valueSet);
    }

    @Override
    public int getCheckedKeyCount() {
        Set keys = (Set)super.getValue();
        if (keys != null) {
            return keys.size();
        }
        return 0;
    }

    @Override
    public T getCheckedKey() {
        Set<T> a = this.getCheckedKeys();
        if (a != null && a.size() > 0) {
            return (T)CollectionUtility.firstElement(a);
        }
        return null;
    }

    @Override
    public Set<T> getCheckedKeys() {
        return this.getValue();
    }

    @Override
    @Deprecated
    public ILookupRow getCheckedLookupRow() {
        return (ILookupRow)CollectionUtility.firstElement(this.getCheckedLookupRows());
    }

    @Override
    @Deprecated
    public Set<ILookupRow> getCheckedLookupRows() {
        Set<ITreeNode> treeNodes = this.getTree().getCheckedNodes();
        if (treeNodes == null || treeNodes.isEmpty()) {
            return CollectionUtility.hashSet((Object[])new ILookupRow[0]);
        }
        HashSet<ILookupRow> lookupRows = new HashSet<ILookupRow>(treeNodes.size());
        for (ITreeNode node : treeNodes) {
            if (node == null) continue;
            ICell cell = node.getCell();
            ITreeNode parentNode = node.getParentNode();
            lookupRows.add((ILookupRow)new LookupRow(node.getPrimaryKey(), cell.getText(), cell.getIconId(), cell.getTooltipText(), cell.getBackgroundColor(), cell.getForegroundColor(), cell.getFont(), cell.isEnabled(), parentNode != null ? parentNode.getPrimaryKey() : null, this.isNodeActive(node)));
        }
        return lookupRows;
    }

    @Override
    public void checkKey(T key) {
        HashSet<T> keySet = new HashSet<T>();
        if (key != null) {
            keySet.add(key);
        }
        this.checkKeys(keySet);
    }

    @Override
    public void checkKeys(Set<T> keys) {
        this.setValue(CollectionUtility.hashSetWithoutNullElements(keys));
    }

    @Override
    public void uncheckAllKeys() {
        this.checkKeys(null);
    }

    @Override
    public Set<T> getUncheckedKeys() {
        HashSet<T> set = new HashSet<T>();
        Set<T> a = this.getInitValue();
        if (a != null) {
            set.addAll(a);
        }
        if ((a = this.getCheckedKeys()) != null) {
            set.removeAll(a);
        }
        return set;
    }

    @Override
    public void checkAllKeys() {
        final HashSet keySet = new HashSet();
        ITreeVisitor v = new ITreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                if (node.getPrimaryKey() != null) {
                    keySet.add(node.getPrimaryKey());
                }
                return true;
            }
        };
        this.m_tree.visitNode(this.m_tree.getRootNode(), v);
        this.checkKeys(keySet);
    }

    @Override
    public void exportFormFieldData(AbstractFormFieldData target) throws ProcessingException {
        AbstractValueFieldData v = (AbstractValueFieldData)target;
        Object value = this.getValue();
        if (CollectionUtility.isEmpty((Collection)value)) {
            v.setValue(null);
        } else {
            v.setValue((Object)CollectionUtility.hashSet((Collection)this.getValue()));
        }
    }

    @Override
    public boolean isLoadIncremental() {
        return this.m_loadIncremental;
    }

    @Override
    public void setLoadIncremental(boolean b) {
        this.m_loadIncremental = b;
    }

    @Override
    public boolean isAutoExpandAll() {
        return this.m_autoExpandAll;
    }

    @Override
    public void setAutoExpandAll(boolean b) {
        this.m_autoExpandAll = b;
    }

    @Override
    public boolean isAutoCheckChildNodes() {
        return this.m_autoCheckChildNodes;
    }

    @Override
    public void setAutoCheckChildNodes(boolean b) {
        this.m_autoCheckChildNodes = b;
    }

    @Override
    public boolean isNodeActive(ITreeNode node) {
        if (node instanceof P_InternalTreeNode) {
            return ((P_InternalTreeNode)node).isActive();
        }
        return false;
    }

    @Override
    public boolean isFilterActiveNodes() {
        return this.propertySupport.getPropertyBool("filterActiveNodes");
    }

    @Override
    public void setFilterActiveNodes(boolean b) {
        this.propertySupport.setPropertyBool("filterActiveNodes", b);
    }

    @Override
    public boolean getFilterCheckedNodesValue() {
        return this.propertySupport.getPropertyBool("filterCheckedNodesValue");
    }

    @Override
    public void setFilterCheckedNodesValue(boolean b) {
        this.propertySupport.setPropertyBool("filterCheckedNodesValue", b);
    }

    @Override
    public boolean isFilterCheckedNodes() {
        return this.propertySupport.getPropertyBool("filterCheckedNodes");
    }

    @Override
    public void setFilterCheckedNodes(boolean b) {
        this.propertySupport.setPropertyBool("filterCheckedNodes", b);
    }

    @Override
    public TriState getFilterActiveNodesValue() {
        return (TriState)this.propertySupport.getProperty("filterActiveNodesValue");
    }

    @Override
    public void setFilterActiveNodesValue(TriState t) {
        if (t == null) {
            t = TriState.TRUE;
        }
        this.propertySupport.setProperty("filterActiveNodesValue", (Object)t);
    }

    private void updateActiveNodesFilter() {
        try {
            this.m_tree.setTreeChanging(true);
            if (this.m_activeNodesFilter != null) {
                this.m_tree.removeNodeFilter(this.m_activeNodesFilter);
                this.m_activeNodesFilter = null;
            }
            this.m_activeNodesFilter = new ActiveOrCheckedNodesFilter(this, this.getFilterActiveNodesValue());
            this.m_tree.addNodeFilter(this.m_activeNodesFilter);
        }
        finally {
            this.m_tree.setTreeChanging(false);
        }
    }

    private void updateCheckedNodesFilter() {
        try {
            this.m_tree.setTreeChanging(true);
            if (this.m_checkedNodesFilter != null) {
                this.m_tree.removeNodeFilter(this.m_checkedNodesFilter);
                this.m_checkedNodesFilter = null;
            }
            if (this.getFilterCheckedNodesValue()) {
                this.m_checkedNodesFilter = new CheckedNodesFilter();
                this.m_tree.addNodeFilter(this.m_checkedNodesFilter);
            }
        }
        finally {
            this.m_tree.setTreeChanging(false);
        }
    }

    private void syncValueToTree() {
        if (this.m_valueTreeSyncActive) {
            return;
        }
        try {
            this.m_valueTreeSyncActive = true;
            this.getTree().setTreeChanging(true);
            Set<T> checkedKeys = this.getCheckedKeys();
            List<ITreeNode> checkedNodes = this.m_tree.findNodes(checkedKeys);
            this.getTree().visitTree(new ITreeVisitor(){

                @Override
                public boolean visit(ITreeNode node) {
                    node.setChecked(false);
                    return true;
                }
            });
            for (ITreeNode node : checkedNodes) {
                node.setChecked(true);
            }
            if (!this.getTree().isCheckable()) {
                this.getTree().selectNodes(checkedNodes, false);
            }
        }
        finally {
            this.getTree().setTreeChanging(false);
            this.m_valueTreeSyncActive = false;
        }
    }

    protected void execAutoCheckChildNodes(ITreeNode node, boolean value) {
        for (ITreeNode childNode : node.getFilteredChildNodes()) {
            if (childNode.isEnabled() && childNode.isVisible()) {
                childNode.setChecked(value);
            }
            this.execAutoCheckChildNodes(childNode, value);
        }
    }

    private void syncTreeToValue() {
        if (this.m_valueTreeSyncActive) {
            return;
        }
        try {
            this.m_valueTreeSyncActive = true;
            this.getTree().setTreeChanging(true);
            Set<ITreeNode> checkedNodes = this.getTree().isCheckable() ? this.m_tree.getCheckedNodes() : this.m_tree.getSelectedNodes();
            HashSet<Object> checkedKeys = new HashSet<Object>();
            for (ITreeNode checkedNode : checkedNodes) {
                checkedKeys.add(checkedNode.getPrimaryKey());
            }
            this.checkKeys(checkedKeys);
            if (!this.getTree().isCheckable()) {
                this.getTree().visitTree(new ITreeVisitor(){

                    @Override
                    public boolean visit(ITreeNode node) {
                        node.setChecked(node.isSelectedNode());
                        return true;
                    }
                });
            }
        }
        finally {
            this.getTree().setTreeChanging(false);
            this.m_valueTreeSyncActive = false;
        }
        if (!this.m_tree.getUIFacade().isUIProcessing()) {
            this.updateActiveNodesFilter();
        }
        this.updateCheckedNodesFilter();
    }

    public <F extends IFormField> F getFieldByClass(final Class<F> c) {
        final Holder found = new Holder(IFormField.class);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (field.getClass() == c) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (F)((IFormField)found.getValue());
    }

    @Override
    public IFormField getFieldById(final String id) {
        final Holder found = new Holder(IFormField.class);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (field.getFieldId().equals(id)) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (IFormField)found.getValue();
    }

    public <X extends IFormField> X getFieldById(final String id, final Class<X> type) {
        final Holder found = new Holder(type);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (type.isAssignableFrom(field.getClass()) && field.getFieldId().equals(id)) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (X)((IFormField)found.getValue());
    }

    @Override
    public int getFieldCount() {
        return this.m_fields.size();
    }

    @Override
    public int getFieldIndex(IFormField f) {
        return this.m_fields.indexOf(f);
    }

    @Override
    public List<IFormField> getFields() {
        return CollectionUtility.arrayList(this.m_fields);
    }

    @Override
    public boolean visitFields(IFormFieldVisitor visitor, int startLevel) {
        if (!visitor.visitField(this, startLevel, 0)) {
            return false;
        }
        int index = 0;
        for (IFormField field : this.m_fields) {
            if (field instanceof ICompositeField ? !((ICompositeField)field).visitFields(visitor, startLevel + 1) : !visitor.visitField(field, startLevel, index)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    @Override
    public final int getGridColumnCount() {
        return 1;
    }

    @Override
    public final int getGridRowCount() {
        return 1;
    }

    @Override
    public void rebuildFieldGrid() {
    }

    @Order(value=10000.0)
    public class DefaultTreeBoxTree
    extends AbstractTree {
        @Override
        protected boolean getConfiguredMultiSelect() {
            return false;
        }

        @Override
        protected boolean getConfiguredCheckable() {
            return true;
        }

        @Override
        protected boolean getConfiguredRootNodeVisible() {
            return false;
        }
    }

    private class P_InternalTreeNode
    extends AbstractTreeNode {
        private boolean m_active;

        private P_InternalTreeNode() {
        }

        public boolean isActive() {
            return this.m_active;
        }

        public void setActive(boolean b) {
            this.m_active = b;
        }

        @Override
        public void loadChildren() throws ProcessingException {
            if (AbstractTreeBox.this.isLoadIncremental()) {
                AbstractTreeBox.this.loadChildNodes(this);
            } else {
                this.setChildrenLoaded(true);
            }
        }
    }

    private class P_TreeNodeBuilder
    extends AbstractTreeNodeBuilder<T> {
        private P_TreeNodeBuilder() {
        }

        @Override
        protected ITreeNode createEmptyTreeNode() throws ProcessingException {
            return new P_InternalTreeNode();
        }

        @Override
        public ITreeNode createTreeNode(ILookupRow<T> lookupRow, int nodeStatus, boolean markChildrenLoaded) throws ProcessingException {
            P_InternalTreeNode treeNode = (P_InternalTreeNode)super.createTreeNode(lookupRow, nodeStatus, markChildrenLoaded);
            treeNode.setActive(lookupRow.isActive());
            return treeNode;
        }
    }

    @Order(value=1.0)
    public class TreeBoxFilterBox
    extends AbstractTreeBoxFilterBox {
        @Override
        protected ITreeBox getTreeBox() {
            return AbstractTreeBox.this;
        }
    }
}

