/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.outline;

import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.ProcessingStatus;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.AbstractOutlineTableField;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutlineTableForm;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;

public class DefaultOutlineTableForm
extends AbstractForm
implements IOutlineTableForm {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DefaultOutlineTableForm.class);

    @Override
    protected boolean getConfiguredAskIfNeedSave() {
        return false;
    }

    @Override
    protected int getConfiguredDisplayHint() {
        return 20;
    }

    @Override
    protected String getConfiguredDisplayViewId() {
        return "PAGE_TABLE";
    }

    @Override
    public ITable getCurrentTable() {
        return this.getOutlineTableField().getTable();
    }

    @Override
    public void setCurrentTable(ITable table) {
        this.getOutlineTableField().installTable(table);
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.OutlineTableField getOutlineTableField() {
        return this.getFieldByClass(MainBox.OutlineTableField.class);
    }

    public void startView() throws ProcessingException {
        this.setAutoAddRemoveOnDesktop(false);
        this.startInternal(new ViewHandler());
        ClientSyncJob.getCurrentSession().getDesktop().setOutlineTableForm(this);
    }

    @Order(value=10.0)
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected boolean getConfiguredBorderVisible() {
            return false;
        }

        @Override
        protected int getConfiguredGridColumnCount() {
            return 2;
        }

        @Order(value=10.0)
        public class OutlineTableField
        extends AbstractOutlineTableField {
            @Override
            protected int getConfiguredGridW() {
                return 2;
            }

            @Override
            protected int getConfiguredGridH() {
                return 2;
            }

            @Override
            protected boolean getConfiguredTableStatusVisible() {
                return true;
            }

            @Override
            protected void execUpdateTableStatus() {
                IPageWithTable tablePage;
                if (!this.isTableStatusVisible()) {
                    return;
                }
                IOutline outline = DefaultOutlineTableForm.this.getDesktop().getOutline();
                IProcessingStatus populateStatus = null;
                if (outline != null && outline.getActivePage() != null) {
                    IPage activePage = outline.getActivePage();
                    populateStatus = activePage.getPagePopulateStatus();
                }
                this.setTablePopulateStatus(populateStatus);
                ProcessingStatus selectionStatus = null;
                if (!(outline == null || !(outline.getActivePage() instanceof IPageWithTable) || (tablePage = (IPageWithTable)outline.getActivePage()).isSearchActive() && tablePage.getSearchFilter() != null && !tablePage.getSearchFilter().isCompleted() && tablePage.isSearchRequired() || populateStatus != null && populateStatus.getSeverity() == 2)) {
                    selectionStatus = new ProcessingStatus(this.createDefaultTableStatus(), 1);
                }
                this.setTableSelectionStatus((IProcessingStatus)selectionStatus);
            }

            @Override
            protected void execTableTitleChanged() {
                IDesktop desktop = ClientSyncJob.getCurrentSession().getDesktop();
                ITreeNode node = null;
                if (this.getTable() != null && desktop.getOutline() != null) {
                    node = desktop.getOutline().getSelectedNode();
                }
                if (node != null) {
                    DefaultOutlineTableForm.this.setTitle(desktop.getOutline().getPathText(node));
                    DefaultOutlineTableForm.this.setIconId(node.getCell().getIconId());
                } else {
                    DefaultOutlineTableForm.this.setTitle(null);
                    DefaultOutlineTableForm.this.setIconId(null);
                }
            }
        }
    }

    @Order(value=10.0)
    public class ViewHandler
    extends AbstractFormHandler {
    }
}

