/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.profiler;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;

public final class DesktopProfiler {
    private static DesktopProfiler instance = new DesktopProfiler();
    private boolean m_enabled = false;
    private Object m_listLock = new Object();
    private final List<WeakReference<ITree>> m_trees = new ArrayList<WeakReference<ITree>>();
    private final List<WeakReference<ITable>> m_tables;
    private final List<WeakReference<ITreeNode>> m_treeNodes = new ArrayList<WeakReference<ITreeNode>>();
    private final List<WeakReference<ITableRow>> m_tableRows;
    private final List<WeakReference<IForm>> m_forms;
    private final List<WeakReference<IFormField>> m_formFields;
    private final List<WeakReference<Object>> m_objects;

    public static DesktopProfiler getInstance() {
        return instance;
    }

    private DesktopProfiler() {
        this.m_tables = new ArrayList<WeakReference<ITable>>();
        this.m_tableRows = new ArrayList<WeakReference<ITableRow>>();
        this.m_forms = new ArrayList<WeakReference<IForm>>();
        this.m_formFields = new ArrayList<WeakReference<IFormField>>();
        this.m_objects = new ArrayList<WeakReference<Object>>();
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTree(ITree tree) {
        if (!this.m_enabled) {
            return;
        }
        Object object = this.m_listLock;
        synchronized (object) {
            this.m_trees.add(new WeakReference<ITree>(tree));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTreeNode(ITreeNode node) {
        if (!this.m_enabled) {
            return;
        }
        Object object = this.m_listLock;
        synchronized (object) {
            this.m_treeNodes.add(new WeakReference<ITreeNode>(node));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTable(ITable table) {
        if (!this.m_enabled) {
            return;
        }
        Object object = this.m_listLock;
        synchronized (object) {
            this.m_tables.add(new WeakReference<ITable>(table));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTableRow(ITableRow row) {
        if (!this.m_enabled) {
            return;
        }
        Object object = this.m_listLock;
        synchronized (object) {
            this.m_tableRows.add(new WeakReference<ITableRow>(row));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForm(IForm form) {
        if (!this.m_enabled) {
            return;
        }
        Object object = this.m_listLock;
        synchronized (object) {
            this.m_forms.add(new WeakReference<IForm>(form));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFormField(IFormField formField) {
        if (!this.m_enabled) {
            return;
        }
        Object object = this.m_listLock;
        synchronized (object) {
            this.m_formFields.add(new WeakReference<IFormField>(formField));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObject(Object o) {
        if (!this.m_enabled) {
            return;
        }
        Object object = this.m_listLock;
        synchronized (object) {
            this.m_objects.add(new WeakReference<Object>(o));
        }
    }

    public void dump() {
        this.dump(System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(OutputStream o) {
        System.gc();
        if (!this.m_enabled) {
            return;
        }
        PrintWriter out = new PrintWriter(o, true);
        try {
            try {
                Object object = this.m_listLock;
                synchronized (object) {
                    this.manageListsWithoutLocking();
                    NumberFormat fmt = NumberFormat.getIntegerInstance(LocaleThreadLocal.get());
                    out.println("Max memory:   " + fmt.format(Runtime.getRuntime().maxMemory()));
                    out.println("Total memory: " + fmt.format(Runtime.getRuntime().totalMemory()));
                    out.println("Free memory:  " + fmt.format(Runtime.getRuntime().freeMemory()));
                    out.println("(Used memory):" + fmt.format(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
                    out.println();
                    this.dumpWeakList(out, "TREE", this.m_trees);
                    this.dumpWeakList(out, "TREE NODE", this.m_trees);
                    this.dumpWeakList(out, "TABLE", this.m_tables);
                    this.dumpWeakList(out, "TABLE ROW", this.m_tableRows);
                    this.dumpWeakList(out, "FORM", this.m_forms);
                    this.dumpWeakList(out, "FORM FIELD", this.m_formFields);
                    this.dumpWeakList(out, "VARIOUS", this.m_objects);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (o != System.out) {
                    out.close();
                }
            }
        }
        finally {
            if (o != System.out) {
                out.close();
            }
        }
    }

    private <T> void dumpWeakList(PrintWriter out, String title, List<WeakReference<T>> weakList) {
        HashMap typesMap = new HashMap();
        for (WeakReference<T> ref : weakList) {
            Object o = ref.get();
            if (o == null) continue;
            Integer n = (Integer)typesMap.get(o.getClass());
            typesMap.put(o.getClass(), n != null ? n + 1 : 1);
        }
        TreeMap<String, Integer> sortMap = new TreeMap<String, Integer>();
        for (Map.Entry entry : typesMap.entrySet()) {
            sortMap.put(((Class)entry.getKey()).getName(), (Integer)entry.getValue());
        }
        out.println(title);
        for (Map.Entry entry : sortMap.entrySet()) {
            out.println(" " + (String)entry.getKey() + " " + entry.getValue());
        }
    }

    private void manageListsWithoutLocking() {
        WeakReference<Object> ref;
        Iterator<WeakReference<Object>> it = this.m_treeNodes.iterator();
        while (it.hasNext()) {
            ref = it.next();
            if (ref.get() != null) continue;
            it.remove();
        }
        it = this.m_tableRows.iterator();
        while (it.hasNext()) {
            ref = it.next();
            if (ref.get() != null) continue;
            it.remove();
        }
    }
}

