/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.extension.client;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.rt.extension.client.internal.AbstractExtensionManager;
import org.eclipse.scout.rt.extension.client.ui.action.menu.internal.MenuExtensionManager;
import org.eclipse.scout.rt.extension.client.ui.desktop.internal.DesktopExtensionManager;
import org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.internal.PageExtensionManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.scout.rt.extension.client";
    private static Activator plugin;
    private final Map<Class<? extends AbstractExtensionManager>, AbstractExtensionManager> m_extensionManagers = new HashMap<Class<? extends AbstractExtensionManager>, AbstractExtensionManager>();

    public static Activator getDefault() {
        return plugin;
    }

    private void addExtensionManager(AbstractExtensionManager em) {
        this.m_extensionManagers.put(em.getClass(), em);
    }

    private <T> T getExtensionManager(Class<T> type) {
        return type.cast(this.m_extensionManagers.get(type));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        IExtensionRegistry extensionRegistry = this.getExtensionRegistry(context);
        this.addExtensionManager(new PageExtensionManager(extensionRegistry));
        this.addExtensionManager(new MenuExtensionManager(extensionRegistry));
        this.addExtensionManager(new DesktopExtensionManager(extensionRegistry));
        context.addBundleListener((BundleListener)new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getType() == 2 && event.getBundle().equals(Activator.this.getBundle())) {
                    new Job("Initialize Scout client extensions"){

                        protected IStatus run(IProgressMonitor monitor) {
                            for (AbstractExtensionManager em : Activator.this.m_extensionManagers.values()) {
                                em.start();
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        Iterator<AbstractExtensionManager> it = this.m_extensionManagers.values().iterator();
        while (it.hasNext()) {
            AbstractExtensionManager em = it.next();
            it.remove();
            em.stop();
        }
        plugin = null;
        super.stop(context);
    }

    public PageExtensionManager getPagesExtensionManager() {
        return this.getExtensionManager(PageExtensionManager.class);
    }

    public MenuExtensionManager getMenuExtensionManager() {
        return this.getExtensionManager(MenuExtensionManager.class);
    }

    public DesktopExtensionManager getDesktopExtensionManager() {
        return this.getExtensionManager(DesktopExtensionManager.class);
    }

    private IExtensionRegistry getExtensionRegistry(BundleContext context) {
        ServiceReference ref = context.getServiceReference(IExtensionRegistry.class.getName());
        IExtensionRegistry reg = (IExtensionRegistry)context.getService(ref);
        context.ungetService(ref);
        return reg;
    }
}

