/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.extension.client.ui.action.menu.internal;

import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.extension.client.ui.action.menu.IMenuExtensionFilter;
import org.eclipse.scout.rt.extension.client.ui.action.menu.IMenuModifier;
import org.eclipse.scout.rt.extension.client.ui.action.menu.internal.AbstractMenuExtension;

public class MenuModificationExtension
extends AbstractMenuExtension {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(MenuModificationExtension.class);
    private final Class<? extends IMenuModifier<? extends IMenu>> m_menuModifier;

    public MenuModificationExtension(Class<? extends IMenu> menuClass, IMenuExtensionFilter filter, Class<? extends IMenuModifier<? extends IMenu>> menuModifier) {
        super(menuClass, filter);
        if (menuModifier == null) {
            throw new IllegalArgumentException("menuModifier must not be null");
        }
        Class menuModifierMenuType = TypeCastUtility.getGenericsParameterClass(menuModifier, IMenuModifier.class);
        if (menuModifierMenuType == null) {
            LOG.warn("could not determine generic type parameter of menu modifier '" + menuModifier.getName() + ";");
        } else if (!menuModifierMenuType.isAssignableFrom(menuClass)) {
            throw new IllegalArgumentException("menuClass must be assignalbe to the generic type of given menuModifier. [menuClass: '" + menuClass.getName() + "', generic type on menuModifier: '" + menuModifierMenuType.getName() + "'");
        }
        this.m_menuModifier = menuModifier;
    }

    public Class<? extends IMenuModifier<? extends IMenu>> getMenuModifier() {
        return this.m_menuModifier;
    }

    @Override
    public boolean accept(Object anchor, Object container, IMenu menu) {
        if (!this.getMenuClass().isInstance(menu)) {
            return false;
        }
        return super.accept(anchor, container, menu);
    }

    public <T extends IMenu> IMenuModifier<T> createMenuModifier() throws ProcessingException {
        try {
            return this.m_menuModifier.newInstance();
        }
        catch (Exception e) {
            throw new ProcessingException("Error while instantiating menu modifier", (Throwable)e);
        }
    }
}

