/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.extension.client.ui.desktop.internal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.desktop.IDesktopExtension;
import org.eclipse.scout.rt.extension.client.internal.AbstractExtensionManager;
import org.eclipse.scout.rt.extension.client.internal.IExtensionProcessor;
import org.osgi.framework.Bundle;

public class DesktopExtensionManager
extends AbstractExtensionManager {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DesktopExtensionManager.class);
    public static final String EXTENSION_POINT_ID = "org.eclipse.scout.rt.extension.client.desktopExtensions";
    public static final String DESKTOP_EXTENSION_ELEMENT = "desktopExtension";
    private final List<Class<? extends IDesktopExtension>> m_desktopExtensionTypes = new LinkedList<Class<? extends IDesktopExtension>>();

    public DesktopExtensionManager(IExtensionRegistry extensionRegistry) {
        super(extensionRegistry, EXTENSION_POINT_ID);
        this.initExtensionProcessors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IDesktopExtension> getDesktopExtensions() {
        Object object = this.getLock();
        synchronized (object) {
            this.ensureStarted();
            ArrayList<IDesktopExtension> desktopExtensions = new ArrayList<IDesktopExtension>(this.m_desktopExtensionTypes.size());
            for (Class<? extends IDesktopExtension> type : this.m_desktopExtensionTypes) {
                try {
                    IDesktopExtension desktopExtension = type.newInstance();
                    desktopExtensions.add(desktopExtension);
                }
                catch (Exception e) {
                    LOG.warn("Exception while instantiating new object of type [" + type.getName() + "]", (Throwable)e);
                }
            }
            return desktopExtensions;
        }
    }

    private void initExtensionProcessors() {
        this.addExtensionProcessor(DESKTOP_EXTENSION_ELEMENT, new IExtensionProcessor<Class<? extends IDesktopExtension>>(){

            @Override
            public Class<? extends IDesktopExtension> processConfigurationElement(Bundle contributor, IConfigurationElement element) throws Exception {
                Class<IDesktopExtension> desktopExtension = DesktopExtensionManager.loadClass(contributor, IDesktopExtension.class, element.getAttribute("class"));
                DesktopExtensionManager.this.m_desktopExtensionTypes.add(desktopExtension);
                return desktopExtension;
            }
        });
    }

    @Override
    protected void removeContributions(Set<Object> contributions) {
        this.m_desktopExtensionTypes.removeAll(contributions);
    }
}

