/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.scout.commons.Base64Utility;
import org.eclipse.scout.commons.EncryptionUtility;
import org.eclipse.scout.commons.SoapHandlingUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.security.SimplePrincipal;
import org.eclipse.scout.rt.server.commons.servletfilter.FilterConfigInjection;
import org.eclipse.scout.rt.server.commons.servletfilter.security.SecureHttpServletRequestWrapper;
import org.eclipse.scout.rt.server.internal.Activator;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SoapWsseJaasFilter
implements Filter {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SoapWsseJaasFilter.class);
    private static final byte[] tripleDesKey;
    private SAXParserFactory m_saxParserFactory;
    private FilterConfigInjection m_injection;

    static {
        String key = Activator.getDefault().getBundle().getBundleContext().getProperty("scout.ajax.token.key");
        if (key == null) {
            tripleDesKey = null;
        } else {
            tripleDesKey = new byte[24];
            try {
                byte[] keyBytes = key.getBytes("UTF-8");
                System.arraycopy(keyBytes, 0, tripleDesKey, 0, Math.min(keyBytes.length, tripleDesKey.length));
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("reading property 'scout.ajax.token.key'", (Throwable)e);
            }
        }
    }

    public void init(FilterConfig config0) throws ServletException {
        this.m_injection = new FilterConfigInjection(config0, this.getClass());
        try {
            this.m_saxParserFactory = SoapHandlingUtility.createSaxParserFactory();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        this.m_saxParserFactory = null;
        this.m_injection = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Subject subject;
        if (this.isSubjectSet()) {
            chain.doFilter(request, response);
            return;
        }
        FilterConfigInjection.FilterConfig config = this.m_injection.getConfig(request);
        if (!config.isActive()) {
            chain.doFilter(request, response);
            return;
        }
        ServletInputStream httpIn = request.getInputStream();
        ByteArrayOutputStream cacheOut = new ByteArrayOutputStream();
        try {
            subject = this.parseSubject((InputStream)httpIn, cacheOut);
        }
        catch (Throwable t) {
            LOG.warn("WS-Security check", t);
            ((HttpServletResponse)response).sendError(403);
            return;
        }
        final ByteArrayInputStream cacheIn = new ByteArrayInputStream(cacheOut.toByteArray());
        cacheOut = null;
        HttpServletRequestWrapper replayRequest = new HttpServletRequestWrapper((HttpServletRequest)request){

            public ServletInputStream getInputStream() throws IOException {
                return new ServletInputStream(){

                    public int read() throws IOException {
                        return cacheIn.read();
                    }
                };
            }
        };
        this.continueChainWithPrincipal(subject, (HttpServletRequest)replayRequest, (HttpServletResponse)response, chain);
    }

    private void continueChainWithPrincipal(Subject subject, final HttpServletRequest req, final HttpServletResponse res, final FilterChain chain) throws IOException, ServletException {
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    Principal principal = Subject.getSubject(AccessController.getContext()).getPrincipals().iterator().next();
                    SecureHttpServletRequestWrapper secureReq = new SecureHttpServletRequestWrapper(req, principal);
                    chain.doFilter((ServletRequest)secureReq, (ServletResponse)res);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t);
        }
    }

    protected Subject parseSubject(final InputStream httpIn, final ByteArrayOutputStream cacheOut) throws Exception {
        InputStream filterIn = new InputStream(){

            @Override
            public int read() throws IOException {
                int ch = httpIn.read();
                if (ch < 0) {
                    return ch;
                }
                cacheOut.write(ch);
                return ch;
            }

            @Override
            public int read(byte[] b) throws IOException {
                int n = httpIn.read(b);
                if (n <= 0) {
                    return n;
                }
                cacheOut.write(b, 0, n);
                return n;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int n = httpIn.read(b, off, len);
                if (n <= 0) {
                    return n;
                }
                cacheOut.write(b, off, n);
                return n;
            }
        };
        WSSEUserTokenHandler handler = new WSSEUserTokenHandler();
        SoapHandlingUtility.createSaxParser((SAXParserFactory)this.m_saxParserFactory).parse(new InputSource(filterIn), (DefaultHandler)handler);
        return this.createSubject(this.cleanString(handler.user), this.cleanString(handler.tokenRaw), this.cleanString(handler.tokenEncoding));
    }

    protected Subject createSubject(String user, String tokenRaw, String tokenEncoding) throws Exception {
        if (user == null || tokenRaw == null) {
            LOG.error("Ajax back-end call contains no ws-security token. Check if the config.ini of the /rap and the /ajax webapp contains the property 'scout.ajax.token.key'.");
            throw new SecurityException("SOAP header contains no ws-security token");
        }
        byte[] token = Base64Utility.decode((String)tokenRaw);
        String msg = new String(EncryptionUtility.decrypt((byte[])token, (byte[])tripleDesKey), "UTF-8");
        String[] tupel = msg.split(":", 2);
        long timestamp = Long.parseLong(tupel[0]);
        String userRef = tupel[1];
        if (timestamp < 0L || userRef == null || !userRef.equals(user)) {
            throw new SecurityException("SOAP header contains no ws-security token");
        }
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new SimplePrincipal(user));
        subject.setReadOnly();
        return subject;
    }

    private boolean isSubjectSet() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null) {
            return false;
        }
        if (subject.getPrincipals().size() == 0) {
            return false;
        }
        String name = subject.getPrincipals().iterator().next().getName();
        return StringUtility.hasText((String)name);
    }

    private String cleanString(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        if (s.equalsIgnoreCase("null")) {
            return null;
        }
        return s;
    }

    private static class WSSEUserTokenHandler
    extends DefaultHandler {
        public String user;
        public String tokenEncoding;
        public String tokenRaw;
        private boolean insideEnvelope;
        private boolean insideHeader;
        private boolean insideSecurity;
        private boolean insideUsernameToken;
        private boolean insideUsername;
        private boolean insidePasswort;
        private boolean done;

        private WSSEUserTokenHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qNameText, Attributes attributes) throws SAXException {
            if (this.done) {
                return;
            }
            QName qname = new QName(namespaceURI, localName);
            if (SoapHandlingUtility.SOAPENV_ENVELOPE_ELEMENT.equals(qname)) {
                this.insideEnvelope = true;
                return;
            }
            if (SoapHandlingUtility.SOAPENV_HEADER_ELEMENT.equals(qname)) {
                this.insideHeader = true;
                return;
            }
            if (SoapHandlingUtility.WSSE_SECURITY_ELEMENT.equals(qname)) {
                this.insideSecurity = true;
                return;
            }
            if (SoapHandlingUtility.WSSE_USERNAME_TOKEN_ELEMENT.equals(qname)) {
                this.insideUsernameToken = true;
                return;
            }
            if (SoapHandlingUtility.WSSE_USERNAME_ELEMENT.equals(qname)) {
                this.insideUsername = true;
                return;
            }
            if (SoapHandlingUtility.WSSE_PASSWORD_ELEMENT.equals(qname)) {
                this.insidePasswort = true;
                this.tokenEncoding = attributes.getValue("", "Type");
                return;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.done) {
                return;
            }
            if (this.insideEnvelope && this.insideHeader && this.insideSecurity && this.insideUsernameToken) {
                if (this.insideUsername) {
                    this.user = new String(ch, start, length);
                }
                if (this.insidePasswort) {
                    this.tokenRaw = new String(ch, start, length);
                }
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qNameText) throws SAXException {
            if (this.done) {
                return;
            }
            QName qname = new QName(namespaceURI, localName);
            if (SoapHandlingUtility.SOAPENV_ENVELOPE_ELEMENT.equals(qname)) {
                this.insideEnvelope = false;
                this.done = true;
                return;
            }
            if (SoapHandlingUtility.SOAPENV_HEADER_ELEMENT.equals(qname)) {
                this.insideHeader = false;
                return;
            }
            if (SoapHandlingUtility.WSSE_SECURITY_ELEMENT.equals(qname)) {
                this.insideSecurity = false;
                return;
            }
            if (SoapHandlingUtility.WSSE_USERNAME_TOKEN_ELEMENT.equals(qname)) {
                this.insideUsernameToken = false;
                return;
            }
            if (SoapHandlingUtility.WSSE_USERNAME_ELEMENT.equals(qname)) {
                this.insideUsername = false;
                return;
            }
            if (SoapHandlingUtility.WSSE_PASSWORD_ELEMENT.equals(qname)) {
                this.insidePasswort = false;
                return;
            }
        }
    }
}

