/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.admin.html.widget.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.server.admin.html.AbstractHtmlAction;
import org.eclipse.scout.rt.server.admin.html.widget.table.HtmlComponent;
import org.eclipse.scout.rt.server.admin.html.widget.table.SortInfo;
import org.eclipse.scout.rt.server.admin.html.widget.table.VirtualRow;

public class HtmlTable
extends HtmlComponent {
    private String m_tableId;
    private SortInfo m_sortInfo;
    private List<VirtualRow> m_rows;
    private int m_temporaryColumn;

    public HtmlTable(HtmlComponent other, String tableId, SortInfo sortInfo) {
        super(other);
        this.m_tableId = tableId;
        this.m_sortInfo = sortInfo;
        this.m_rows = new ArrayList<VirtualRow>();
    }

    @Override
    public void tableHeaderCell(String content) {
        this.out.print("<th>");
        final int columnIndex = this.m_temporaryColumn++;
        String sortId = this.m_sortInfo.getColumnIndex() == columnIndex ? (this.m_sortInfo.isAscending() ? String.valueOf(this.m_tableId) + ".sortCol." + columnIndex + ".down" : String.valueOf(this.m_tableId) + ".sortCol." + columnIndex + ".up") : String.valueOf(this.m_tableId) + ".sortCol." + columnIndex;
        this.startLinkAction(new AbstractHtmlAction(sortId){
            private static final long serialVersionUID = -4385730186131757304L;

            @Override
            public void run() {
                if (HtmlTable.this.m_sortInfo.getColumnIndex() == columnIndex) {
                    HtmlTable.this.m_sortInfo.setAscending(!HtmlTable.this.m_sortInfo.isAscending());
                } else {
                    HtmlTable.this.m_sortInfo.setColumnIndex(columnIndex);
                    HtmlTable.this.m_sortInfo.setAscending(true);
                }
            }
        });
        if (this.m_sortInfo.getColumnIndex() == columnIndex) {
            this.out.print("<b>");
        }
        if (!StringUtility.hasText((String)content)) {
            this.out.print("&nbsp;");
        } else {
            this.print(content);
        }
        if (this.m_sortInfo.getColumnIndex() == columnIndex) {
            this.out.print("</b>");
        }
        this.endLinkAction();
        this.out.print("</th>");
    }

    public VirtualRow addVirtualRow() {
        VirtualRow v = new VirtualRow(this);
        this.m_rows.add(v);
        return v;
    }

    public void appendVirtualRows() {
        VirtualRow[] virtualRowArray = this.getSortedRows();
        int n = virtualRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            VirtualRow row = virtualRowArray[n2];
            this.append(row);
            ++n2;
        }
    }

    private VirtualRow[] getSortedRows() {
        TreeMap<CompositeObject, VirtualRow> sortMap = new TreeMap<CompositeObject, VirtualRow>();
        int rowIndex = 0;
        for (VirtualRow row : this.m_rows) {
            sortMap.put(new CompositeObject(new Object[]{row.getCellAt(this.m_sortInfo.getColumnIndex()), rowIndex}), row);
            ++rowIndex;
        }
        VirtualRow[] result = new VirtualRow[this.m_rows.size()];
        if (this.m_sortInfo.getColumnIndex() >= 0 && !this.m_sortInfo.isAscending()) {
            int i = this.m_rows.size() - 1;
            Iterator iterator = sortMap.values().iterator();
            while (iterator.hasNext()) {
                VirtualRow row;
                result[i] = row = (VirtualRow)iterator.next();
                --i;
            }
        } else {
            int i = 0;
            Iterator iterator = sortMap.values().iterator();
            while (iterator.hasNext()) {
                VirtualRow row;
                result[i] = row = (VirtualRow)iterator.next();
                ++i;
            }
        }
        return result;
    }
}

