/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.clustersync;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.AbstractServerSession;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotification;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationListener;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationMessage;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterSynchronizationService;
import org.eclipse.scout.rt.server.services.common.clustersync.IPubSubMessageService;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.ServiceRegistration;

public class ClusterSynchronizationService
extends AbstractService
implements IClusterSynchronizationService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ClusterSynchronizationService.class);
    private final List<IClusterNotificationListener> m_distributedNotificationListener = new ArrayList<IClusterNotificationListener>();
    private static final String QUEUE_NAME = "scoutNotificationQueue";
    private IPubSubMessageService m_pubSubMessageService;
    private String m_nodeId;
    private boolean m_enabled;

    public void initializeService(ServiceRegistration registration) {
        super.initializeService(registration);
        this.m_pubSubMessageService = (IPubSubMessageService)SERVICES.getService(IPubSubMessageService.class);
        this.m_nodeId = UUID.randomUUID().toString();
    }

    @Override
    public boolean enable() {
        if (this.m_pubSubMessageService != null) {
            this.m_enabled = this.m_pubSubMessageService.subscribe(QUEUE_NAME);
        }
        return this.m_enabled;
    }

    @Override
    public boolean disable() {
        boolean unregisterSuccessful = this.m_pubSubMessageService.unsubsribe(QUEUE_NAME);
        if (unregisterSuccessful) {
            this.m_enabled = false;
        }
        return unregisterSuccessful;
    }

    @Override
    public boolean isEnabled() {
        return this.m_enabled;
    }

    @Override
    public void publishNotification(IClusterNotification notification) {
        if (this.m_enabled) {
            this.m_pubSubMessageService.publishNotification(notification);
        }
    }

    @Override
    public void processNotification(IClusterNotificationMessage notification) {
        if (notification.getOriginNode() != null && !notification.getOriginNode().equals(this.m_nodeId)) {
            AbstractServerSession session = this.getBackendSession();
            P_NotificationProcessinJob notificationProcessJob = new P_NotificationProcessinJob("NotificationProcessingJob", session, notification, this.m_distributedNotificationListener);
            notificationProcessJob.runNow((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private AbstractServerSession getBackendSession() {
        return new AbstractServerSession(true){
            private static final long serialVersionUID = 1L;
        };
    }

    @Override
    public void addListener(IClusterNotificationListener listener) {
        this.m_distributedNotificationListener.add(listener);
    }

    @Override
    public void removeListener(IClusterNotificationListener listener) {
        this.m_distributedNotificationListener.remove(listener);
    }

    @Override
    public String getNodeId() {
        return this.m_nodeId;
    }

    private class P_NotificationProcessinJob
    extends ServerJob {
        IClusterNotificationMessage m_distributedNotification;
        List<IClusterNotificationListener> m_distributedNotificationListener;

        public P_NotificationProcessinJob(String name, IServerSession serverSession, IClusterNotificationMessage notification, List<IClusterNotificationListener> listener) {
            super(name, serverSession);
            this.m_distributedNotification = notification;
            this.m_distributedNotificationListener = listener;
        }

        @Override
        protected IStatus runTransaction(IProgressMonitor monitor) throws Exception {
            for (IClusterNotificationListener listener : this.m_distributedNotificationListener) {
                listener.onNotification(this.m_distributedNotification);
            }
            return Status.OK_STATUS;
        }
    }
}

