/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.code;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotification;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationListener;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationMessage;
import org.eclipse.scout.rt.server.services.common.code.CodeService;
import org.eclipse.scout.rt.server.services.common.code.IClusterSyncCodeService;
import org.eclipse.scout.rt.server.services.common.code.UnloadCodeTypeCacheClusterNotification;
import org.eclipse.scout.service.SERVICES;

public class UnloadCodeTypeCacheNodeNotificationListener
implements IClusterNotificationListener {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(CodeService.class);

    @Override
    public void onNotification(IClusterNotificationMessage notification) {
        if (this.accept(notification.getNotification())) {
            UnloadCodeTypeCacheClusterNotification n = (UnloadCodeTypeCacheClusterNotification)((Object)notification);
            try {
                ((IClusterSyncCodeService)SERVICES.getService(IClusterSyncCodeService.class)).reloadCodeTypesNoFire(n.getTypes());
            }
            catch (ProcessingException e) {
                LOG.error("Unable to reload CodeTypes", (Throwable)e);
            }
        }
    }

    private boolean accept(IClusterNotification notification) {
        return notification instanceof UnloadCodeTypeCacheClusterNotification;
    }
}

