/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.data.model.IDataModel;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;

public abstract class AbstractDataModel
implements IDataModel,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractDataModel.class);
    private boolean m_calledInitializer;
    private List<IDataModelAttribute> m_attributes;
    private List<IDataModelEntity> m_entities;

    public AbstractDataModel() {
        this(true);
    }

    public AbstractDataModel(boolean callInitializer) {
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected void callInitializer() {
        if (!this.m_calledInitializer) {
            this.m_calledInitializer = true;
            this.initConfig();
        }
    }

    protected List<IDataModelAttribute> createAttributes() {
        Class[] all = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])all, IDataModelAttribute.class);
        List sortedAndFiltered = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((List)filtered, IDataModelAttribute.class);
        ArrayList<IDataModelAttribute> attributes = new ArrayList<IDataModelAttribute>(sortedAndFiltered.size());
        for (Class attributeClazz : sortedAndFiltered) {
            try {
                attributes.add((IDataModelAttribute)ConfigurationUtility.newInnerInstance((Object)this, (Class)attributeClazz));
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
        }
        return attributes;
    }

    protected List<IDataModelEntity> createEntities() {
        Class[] all = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])all, IDataModelEntity.class);
        List sortedAndFiltered = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((List)filtered, IDataModelEntity.class);
        ArrayList<IDataModelEntity> entities = new ArrayList<IDataModelEntity>(sortedAndFiltered.size());
        for (Class dataModelEntityClazz : sortedAndFiltered) {
            try {
                entities.add((IDataModelEntity)ConfigurationUtility.newInnerInstance((Object)this, (Class)dataModelEntityClazz));
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
        }
        return entities;
    }

    protected void initConfig() {
        this.m_attributes = this.createAttributes();
        for (IDataModelAttribute a : this.m_attributes) {
            a.setParentEntity(null);
        }
        this.m_entities = this.createEntities();
        HashMap<Class<? extends IDataModelEntity>, IDataModelEntity> instanceMap = new HashMap<Class<? extends IDataModelEntity>, IDataModelEntity>();
        for (IDataModelEntity e : this.m_entities) {
            e.setParentEntity(null);
            instanceMap.put(e.getClass(), e);
        }
        for (IDataModelEntity e : this.m_entities) {
            e.initializeChildEntities(instanceMap);
        }
    }

    @Override
    public void init() {
        for (IDataModelEntity e : this.getEntities()) {
            try {
                e.initEntity();
            }
            catch (Throwable t) {
                LOG.error("entity " + e, t);
            }
        }
        for (IDataModelAttribute a : this.getAttributes()) {
            try {
                a.initAttribute();
            }
            catch (Throwable t) {
                LOG.error("attribute " + a, t);
            }
        }
    }

    @Override
    public List<IDataModelAttribute> getAttributes() {
        return CollectionUtility.arrayList(this.m_attributes);
    }

    @Override
    public List<IDataModelEntity> getEntities() {
        return CollectionUtility.arrayList(this.m_entities);
    }

    @Override
    public IDataModelAttribute getAttribute(Class<? extends IDataModelAttribute> attributeClazz) {
        for (IDataModelAttribute attribute : this.m_attributes) {
            if (attribute.getClass() != attributeClazz) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public IDataModelEntity getEntity(Class<? extends IDataModelEntity> entityClazz) {
        for (IDataModelEntity entity : this.m_entities) {
            if (entity.getClass() != entityClazz) continue;
            return entity;
        }
        return null;
    }
}

