/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.MatrixUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.IntegerHolder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.code.AbstractCode;
import org.eclipse.scout.rt.shared.services.common.code.CodeRow;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeRow;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.code.ICodeVisitor;
import org.eclipse.scout.rt.shared.services.common.code.MutableCode;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractCodeTypeWithGeneric<CODE_TYPE_ID, CODE_ID, CODE extends ICode<CODE_ID>>
implements ICodeType<CODE_TYPE_ID, CODE_ID>,
Serializable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractCodeTypeWithGeneric.class);
    private static final long serialVersionUID = 1L;
    private boolean m_initialized;
    private String m_text;
    private String m_iconId;
    private boolean m_hierarchy;
    private int m_maxLevel;
    private transient Map<CODE_ID, CODE> m_rootCodeMap = new HashMap<CODE_ID, CODE>();
    private List<CODE> m_rootCodeList = new ArrayList<CODE>();

    public AbstractCodeTypeWithGeneric() {
        this(true);
    }

    public AbstractCodeTypeWithGeneric(boolean callInitializer) {
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected void callInitializer() {
        if (!this.m_initialized) {
            this.initConfig();
            this.m_initialized = true;
        }
    }

    public AbstractCodeTypeWithGeneric(String label, boolean hierarchy) {
        this.m_text = label;
        this.m_hierarchy = hierarchy;
    }

    protected final List<Class<? extends CODE>> getConfiguredCodes() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, ICode.class);
        List sortFilteredClassesByOrderAnnotation = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((List)filtered, ICode.class);
        ArrayList<Class<CODE>> result = new ArrayList<Class<CODE>>();
        for (Class codeClazz : sortFilteredClassesByOrderAnnotation) {
            result.add(codeClazz);
        }
        return result;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=20.0)
    protected boolean getConfiguredIsHierarchy() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=30.0)
    protected int getConfiguredMaxLevel() {
        return Integer.MAX_VALUE;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=40.0)
    protected String getConfiguredText() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=10.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @Deprecated
    @Order(value=110.0)
    protected String getConfiguredDoc() {
        return null;
    }

    @ConfigProperty(value="CODE_ROW")
    @Order(value=120.0)
    protected Class<? extends ICodeRow<CODE_ID>> getConfiguredCodeRowType() {
        return CodeRow.class;
    }

    @ConfigOperation
    @Order(value=1.0)
    protected List<? extends CODE> execCreateCodes() throws ProcessingException {
        ArrayList<ICode> list = new ArrayList<ICode>();
        for (Class<CODE> codeClazz : this.getConfiguredCodes()) {
            try {
                ICode code = (ICode)ConfigurationUtility.newInnerInstance((Object)this, codeClazz);
                list.add(code);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
        }
        return list;
    }

    @ConfigOperation
    @Order(value=2.0)
    protected CODE execCreateCode(ICodeRow<CODE_ID> newRow) throws ProcessingException {
        Class codeClazz = TypeCastUtility.getGenericsParameterClass(this.getClass(), AbstractCodeTypeWithGeneric.class, (int)2);
        if (!Modifier.isAbstract(codeClazz.getModifiers()) && !Modifier.isInterface(codeClazz.getModifiers())) {
            Class<ICodeRow<CODE_ID>> codeRowClazz = this.getConfiguredCodeRowType();
            try {
                Constructor ctor = codeClazz.getConstructor(codeRowClazz);
                return (CODE)((ICode)ctor.newInstance(newRow));
            }
            catch (Exception e) {
                throw new ProcessingException("Could not create a new instance of code row! Override the execCreateCode mehtod.", (Throwable)e);
            }
        }
        if (codeClazz.isAssignableFrom(MutableCode.class)) {
            return (CODE)new MutableCode<CODE_ID>(newRow);
        }
        return null;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected List<? extends ICodeRow<CODE_ID>> execLoadCodes(Class<? extends ICodeRow<CODE_ID>> codeRowType) throws ProcessingException {
        return null;
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execOverwriteCode(ICodeRow<CODE_ID> oldCode, ICodeRow<CODE_ID> newCode) throws ProcessingException {
        if (newCode instanceof CodeRow) {
            CodeRow editableRow = (CodeRow)newCode;
            if (editableRow.getBackgroundColor() == null) {
                editableRow.setBackgroundColor(oldCode.getBackgroundColor());
            }
            if (editableRow.getFont() == null) {
                editableRow.setFont(oldCode.getFont());
            }
            if (editableRow.getForegroundColor() == null) {
                editableRow.setForegroundColor(oldCode.getForegroundColor());
            }
            if (editableRow.getIconId() == null) {
                editableRow.setIconId(oldCode.getIconId());
            }
            if (editableRow.getExtKey() == null) {
                editableRow.setExtKey(oldCode.getExtKey());
            }
            if (editableRow.getValue() == null) {
                editableRow.setValue(oldCode.getValue());
            }
        }
    }

    protected void initConfig() {
        this.m_text = this.getConfiguredText();
        this.m_iconId = this.getConfiguredIconId();
        this.m_hierarchy = this.getConfiguredIsHierarchy();
        this.m_maxLevel = this.getConfiguredMaxLevel();
        try {
            this.loadCodes();
        }
        catch (ProcessingException e) {
            e.addContextMessage(String.valueOf(ScoutTexts.get("CodeTypeInit", new String[0])) + " " + this.m_text);
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    @Deprecated
    public static void sortData(Object[][] data, int ... sortColumns) {
        MatrixUtility.sort((Object[][])data, (int[])sortColumns);
    }

    @Deprecated
    public static CodeRow[] createCodeRowArray(Object[][] data) {
        return AbstractCodeTypeWithGeneric.createCodeRowArray(data, data != null && data.length > 0 ? data[0].length : 0);
    }

    @Deprecated
    public static CodeRow[] createCodeRowArray(Object[][] data, int maxColumnIndex) {
        if (data == null || data.length == 0) {
            return new CodeRow[0];
        }
        CodeRow[] a = new CodeRow[data.length];
        int i = 0;
        while (i < data.length) {
            a[i] = new CodeRow(data[i], maxColumnIndex);
            ++i;
        }
        return a;
    }

    @Override
    public abstract CODE_TYPE_ID getId();

    @Override
    public String getText() {
        return this.m_text;
    }

    @Override
    public String getIconId() {
        return this.m_iconId;
    }

    @Override
    public boolean isHierarchy() {
        return this.m_hierarchy;
    }

    @Override
    public int getMaxLevel() {
        return this.m_maxLevel;
    }

    public CODE getCode(CODE_ID id) {
        ICode<CODE_ID> c = (ICode<CODE_ID>)this.m_rootCodeMap.get(id);
        if (c == null) {
            for (ICode childCode : this.m_rootCodeList) {
                c = childCode.getChildCode(id);
                if (c == null) continue;
                return (CODE)c;
            }
        }
        return (CODE)c;
    }

    public CODE getCodeByExtKey(Object extKey) {
        ICode c = null;
        for (ICode childCode : this.m_rootCodeList) {
            c = extKey.equals(childCode.getExtKey()) ? childCode : childCode.getChildCodeByExtKey(extKey);
            if (c == null) continue;
            return (CODE)c;
        }
        return (CODE)c;
    }

    @Override
    public int getCodeIndex(final CODE_ID id) {
        final IntegerHolder result = new IntegerHolder(Integer.valueOf(-1));
        ICodeVisitor v = new ICodeVisitor<ICode<CODE_ID>>(){
            private int index = 0;

            @Override
            public boolean visit(ICode<CODE_ID> code, int treeLevel) {
                if (CompareUtility.equals(code.getId(), (Object)id)) {
                    result.setValue((Object)this.index);
                } else {
                    ++this.index;
                }
                return (Integer)result.getValue() < 0;
            }
        };
        this.visit(v, false);
        return (Integer)result.getValue();
    }

    @Override
    public int getCodeIndex(final ICode<CODE_ID> c) {
        final IntegerHolder result = new IntegerHolder(Integer.valueOf(-1));
        ICodeVisitor v = new ICodeVisitor<ICode<CODE_ID>>(){
            private int index = 0;

            @Override
            public boolean visit(ICode<CODE_ID> code, int treeLevel) {
                if (code == c) {
                    result.setValue((Object)this.index);
                } else {
                    ++this.index;
                }
                return (Integer)result.getValue() < 0;
            }
        };
        this.visit(v, false);
        return (Integer)result.getValue();
    }

    @Override
    public List<? extends CODE> getCodes() {
        return this.getCodes(true);
    }

    @Override
    public List<? extends CODE> getCodes(boolean activeOnly) {
        ArrayList<CODE> list = new ArrayList<CODE>(this.m_rootCodeList);
        if (activeOnly) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                ICode code = (ICode)it.next();
                if (code.isActive()) continue;
                it.remove();
            }
        }
        return list;
    }

    protected void loadCodes() throws ProcessingException {
        List<ICodeRow<CODE_ID>> result;
        this.m_rootCodeMap = new HashMap<CODE_ID, CODE>();
        this.m_rootCodeList = new ArrayList<CODE>();
        ArrayList<ICode> allCodesOrdered = new ArrayList<ICode>();
        HashMap<ICode, ICode> codeToParentCodeMap = new HashMap<ICode, ICode>();
        HashMap idToCodeMap = new HashMap();
        List<CODE> createdList = this.execCreateCodes();
        if (createdList != null) {
            for (ICode code : createdList) {
                allCodesOrdered.add(code);
                idToCodeMap.put(code.getId(), code);
                codeToParentCodeMap.put(code, null);
            }
        }
        if ((result = this.execLoadCodes(this.getConfiguredCodeRowType())) != null && result.size() > 0) {
            HashMap codeToParentIdMap = new HashMap();
            for (ICodeRow<CODE_ID> newRow : result) {
                CODE newCode;
                ICode existingCode = (ICode)idToCodeMap.get(newRow.getKey());
                if (existingCode != null) {
                    this.execOverwriteCode(existingCode.toCodeRow(), newRow);
                }
                if ((newCode = this.execCreateCode(newRow)) != null) {
                    if (existingCode != null) {
                        allCodesOrdered.remove(existingCode);
                        idToCodeMap.remove(existingCode.getId());
                        codeToParentCodeMap.remove(existingCode);
                    }
                    allCodesOrdered.add((ICode)newCode);
                    idToCodeMap.put(newCode.getId(), (ICode<Object>)newCode);
                    Object parentId = newRow.getParentKey();
                    codeToParentIdMap.put(newCode, parentId);
                    continue;
                }
                if (existingCode == null) continue;
                allCodesOrdered.remove(existingCode);
                allCodesOrdered.add(existingCode);
            }
            for (Map.Entry e : codeToParentIdMap.entrySet()) {
                ICode code = (ICode)e.getKey();
                Object parentId = e.getValue();
                ICode parentCode = null;
                if (parentId != null && (parentCode = (ICode)idToCodeMap.get(parentId)) == null) {
                    LOG.warn("parent code for " + code + " not found: id=" + parentId);
                }
                codeToParentCodeMap.put(code, parentCode);
            }
        }
        for (ICode code : allCodesOrdered) {
            ICode parentCode = (ICode)codeToParentCodeMap.get(code);
            if (parentCode != null) {
                parentCode.addChildCodeInternal(-1, code);
                continue;
            }
            this.addRootCodeInternal(-1, code);
        }
        this.visit(new ICodeVisitor<ICode<CODE_ID>>(){

            @Override
            public boolean visit(ICode<CODE_ID> code, int treeLevel) {
                if (code.getParentCode() != null && !code.getParentCode().isActive() && code.isActive() && code instanceof AbstractCode) {
                    ((AbstractCode)code).setActiveInternal(false);
                }
                return true;
            }
        }, false);
    }

    protected void addRootCodeInternal(int index, CODE code) {
        if (code == null) {
            return;
        }
        int oldIndex = this.removeRootCodeInternal(code.getId());
        if (oldIndex >= 0 && index < 0) {
            index = oldIndex;
        }
        code.setCodeTypeInternal(this);
        code.setParentCodeInternal(null);
        this.m_rootCodeMap.put(code.getId(), code);
        if (index < 0) {
            this.m_rootCodeList.add(code);
        } else {
            this.m_rootCodeList.add(Math.min(index, this.m_rootCodeList.size()), code);
        }
    }

    protected int removeRootCodeInternal(CODE_ID codeId) {
        ICode droppedCode = (ICode)this.m_rootCodeMap.get(codeId);
        if (droppedCode == null) {
            return -1;
        }
        int index = -1;
        if (this.m_rootCodeList != null) {
            Iterator<CODE> it = this.m_rootCodeList.iterator();
            while (it.hasNext()) {
                ++index;
                ICode candidateCode = (ICode)it.next();
                if (candidateCode != droppedCode) continue;
                it.remove();
                break;
            }
        }
        droppedCode.setCodeTypeInternal(null);
        droppedCode.setParentCodeInternal(null);
        return index;
    }

    public String toString() {
        return "CodeType[id=" + this.getId() + ", label=" + this.getText() + "]";
    }

    @Override
    public <T extends ICode<CODE_ID>> boolean visit(ICodeVisitor<T> visitor) {
        return this.visit(visitor, true);
    }

    @Override
    public <T extends ICode<CODE_ID>> boolean visit(ICodeVisitor<T> visitor, boolean activeOnly) {
        for (ICode code : this.getCodes(activeOnly)) {
            if (!visitor.visit(code, 0)) {
                return false;
            }
            if (code.visit(visitor, 1, activeOnly)) continue;
            return false;
        }
        return true;
    }

    protected Object readResolve() throws ObjectStreamException {
        this.m_rootCodeMap = new HashMap<CODE_ID, CODE>();
        if (this.m_rootCodeList == null) {
            this.m_rootCodeList = new ArrayList<CODE>();
        } else {
            for (ICode code : this.m_rootCodeList) {
                this.m_rootCodeMap.put(code.getId(), code);
                code.setParentCodeInternal(null);
                code.setCodeTypeInternal(this);
            }
        }
        return this;
    }

    public String classId() {
        return ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass());
    }
}

