/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.exceptionhandler;

import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.AbstractService;

@Priority(value=-2.0f)
public class LogExceptionHandlerService
extends AbstractService
implements IExceptionHandlerService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(LogExceptionHandlerService.class);

    @Override
    public void handleException(ProcessingException pe) {
        if (pe.isInterruption()) {
            return;
        }
        IProcessingStatus s = pe.getStatus();
        int logLevel = 1;
        if (pe instanceof VetoException) {
            logLevel = 3;
        } else {
            switch (s.getSeverity()) {
                case 1: {
                    logLevel = 3;
                    break;
                }
                case 2: {
                    logLevel = 2;
                    break;
                }
                case 4: {
                    logLevel = 1;
                    break;
                }
                case 16: {
                    logLevel = 1;
                }
            }
        }
        this.differentiatedLog(LogExceptionHandlerService.class.getName(), logLevel, s.toString(), (Throwable)pe);
    }

    void differentiatedLog(String fqcn, int level, String m, Throwable t) {
        switch (level) {
            case 5: {
                LOG.trace(m, t);
                break;
            }
            case 4: {
                LOG.debug(m, t);
                break;
            }
            case 3: {
                LOG.info(m, t);
                break;
            }
            case 2: {
                LOG.warn(m, t);
                break;
            }
            case 1: {
                LOG.error(m, t);
            }
        }
    }
}

