/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.gen.extract;

import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.spec.client.AbstractTypeSpecTest;
import org.eclipse.scout.rt.spec.client.gen.extract.AbstractNamedTextExtractor;
import org.eclipse.scout.rt.spec.client.out.mediawiki.MediawikiUtility;

public class LinkableTypeExtractor<T>
extends AbstractNamedTextExtractor<T> {
    public static final String LINKS_TAG_NAME = "links";
    private Class m_supertype;
    private boolean m_assumeAllSubtypesDocumented;

    public LinkableTypeExtractor() {
        this(Object.class, false);
    }

    public LinkableTypeExtractor(Class supertype, boolean assumeAllSubtypesDocumented) {
        super(TEXTS.get((String)"org.eclipse.scout.rt.spec.type"));
        this.m_supertype = supertype;
        this.m_assumeAllSubtypesDocumented = assumeAllSubtypesDocumented;
    }

    @Override
    public String getText(T o) {
        Class<?> type = o.getClass();
        return this.getText(type);
    }

    @Override
    public String getText(Class type) {
        Class hierarchyType = type;
        StringBuilder specType = new StringBuilder();
        while (hierarchyType != null) {
            if (AbstractTypeSpecTest.isDocType(hierarchyType, this.m_supertype, this.m_assumeAllSubtypesDocumented)) {
                String name = TEXTS.getWithFallback((String)(String.valueOf(ConfigurationUtility.getAnnotatedClassIdWithFallback(hierarchyType)) + "_name"), (String)hierarchyType.getSimpleName());
                specType.append(MediawikiUtility.createLink("c_" + ConfigurationUtility.getAnnotatedClassIdWithFallback(hierarchyType), name));
                break;
            }
            hierarchyType = hierarchyType.getSuperclass();
        }
        if (specType.length() == 0) {
            specType.append(type.getSimpleName());
        }
        return specType.toString();
    }
}

