/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.out.mediawiki;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.spec.client.SpecIOUtility;
import org.eclipse.scout.rt.spec.client.out.ILinkTarget;

public class MediawikiLinkTargetManager {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(MediawikiLinkTargetManager.class);
    private final File m_propertyFile;

    public MediawikiLinkTargetManager(File propertyFile) {
        this.m_propertyFile = propertyFile;
    }

    public void writeLinks(Collection<? extends ILinkTarget> links) throws ProcessingException {
        Properties p = new Properties();
        for (ILinkTarget iLinkTarget : links) {
            p.put(iLinkTarget.getTargetId(), iLinkTarget.getTargetIdWithFileName());
        }
        this.storeProperties(p);
    }

    public Properties readLinks() throws ProcessingException {
        return SpecIOUtility.loadProperties(this.m_propertyFile);
    }

    private void storeProperties(Properties p) throws ProcessingException {
        OutputStreamWriter writer = null;
        try {
            try {
                writer = new FileWriter(this.m_propertyFile, true);
                p.store(writer, "");
            }
            catch (IOException e) {
                throw new ProcessingException("Error storing properties", (Throwable)e);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

