/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.testing.client.runner;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.testing.commons.ScoutAssert;
import org.eclipse.scout.rt.testing.shared.Activator;
import org.eclipse.scout.rt.testing.shared.TestingUtility;
import org.eclipse.scout.rt.testing.shared.services.common.exceptionhandler.WrappingProcessingRuntimeExceptionHandlerService;
import org.junit.runners.model.Statement;
import org.osgi.framework.Bundle;

public class ScoutClientJobWrapperStatement
extends Statement {
    private final IClientSession m_clientSession;
    private final Statement m_statement;

    public ScoutClientJobWrapperStatement(IClientSession clientSession, Statement statement) {
        this.m_clientSession = clientSession;
        this.m_statement = statement;
    }

    public void evaluate() throws Throwable {
        if (ClientJob.getCurrentSession() != null) {
            this.doEvaluate();
        } else {
            ClientSyncJob job = new ClientSyncJob("JUnit Client Job Runner", this.m_clientSession){

                protected void runVoid(IProgressMonitor monitor) throws Throwable {
                    ScoutClientJobWrapperStatement.this.doEvaluate();
                }
            };
            job.schedule();
            job.join();
            ScoutAssert.jobSuccessfullyCompleted((JobEx)job);
        }
    }

    private void doEvaluate() throws Throwable {
        List serviceReg = null;
        try {
            WrappingProcessingRuntimeExceptionHandlerService handler = new WrappingProcessingRuntimeExceptionHandlerService();
            serviceReg = TestingUtility.registerServices((Bundle)Activator.getDefault().getBundle(), (int)1000, (Object[])new Object[]{handler});
            this.m_statement.evaluate();
        }
        catch (Throwable throwable) {
            if (serviceReg != null) {
                TestingUtility.unregisterServices(serviceReg);
            }
            throw throwable;
        }
        if (serviceReg != null) {
            TestingUtility.unregisterServices((List)serviceReg);
        }
    }
}

