/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.ui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.dnd.TextTransferObject;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.testing.shared.TestingUtility;
import org.eclipse.scout.rt.testing.shared.WaitCondition;
import org.eclipse.scout.rt.testing.ui.swing.Activator;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.ColorUtility;
import org.eclipse.scout.rt.ui.swing.basic.ISwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.dnd.TextTransferable;
import org.eclipse.scout.rt.ui.swing.icons.CheckboxIcon;
import org.eclipse.scout.testing.client.AbstractGuiMock;
import org.eclipse.scout.testing.client.IGuiMock;
import org.eclipse.scout.testing.client.robot.JavaRobot;

public class SwingMock
extends AbstractGuiMock {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingMock.class);
    private final JavaRobot m_bot = new JavaRobot();
    private int m_treeNodeToExpandIconGap;

    public SwingMock(IClientSession session) {
        super(session);
    }

    public void initializeMock() {
    }

    public void shutdownMock() {
    }

    public void beforeTest() {
    }

    public void afterTest() {
    }

    public IGuiMock.GuiStrategy getStrategy() {
        return IGuiMock.GuiStrategy.Swing;
    }

    public int getTreeNodeToExpandIconGap() {
        if (this.m_treeNodeToExpandIconGap <= 0) {
            String s = Activator.getDefault().getBundle().getBundleContext().getProperty("IGuiMock.treeNodeToExpandIconGap");
            if (s == null) {
                LOG.warn("Missing config.ini property 'IGuiMock.treeNodeToExpandIconGap'; using default value of 4");
                s = "4";
            }
            this.m_treeNodeToExpandIconGap = Integer.parseInt(s);
        }
        return this.m_treeNodeToExpandIconGap;
    }

    public void setTreeNodeToExpandIconGap(int treeNodeToExpandIconGap) {
        this.m_treeNodeToExpandIconGap = treeNodeToExpandIconGap;
    }

    public void waitForIdle() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        int pass = 0;
        while (pass < 2) {
            this.m_bot.sleep(80);
            this.syncExec(new WaitCondition<Object>(){

                public Object run() throws Throwable {
                    return null;
                }
            });
            ClientSyncJob idleJob = new ClientSyncJob("Check for idle", this.getClientSession()){

                protected void runVoid(IProgressMonitor m) throws Throwable {
                }
            };
            idleJob.setSystem(true);
            final CountDownLatch idleJobScheduledSignal = new CountDownLatch(1);
            JobChangeAdapter listener = new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    idleJobScheduledSignal.countDown();
                }
            };
            try {
                idleJob.addJobChangeListener((IJobChangeListener)listener);
                idleJob.schedule();
                try {
                    idleJobScheduledSignal.await();
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("Interrupted");
                }
            }
            finally {
                idleJob.removeJobChangeListener((IJobChangeListener)listener);
            }
            ++pass;
        }
    }

    public void waitForActiveWindow(final String title) {
        this.waitUntil(new WaitCondition<Object>(){

            public Object run() {
                if (SwingMock.this.isWindowActive(title)) {
                    return true;
                }
                return null;
            }
        });
        this.waitForIdle();
    }

    public void waitForOpenWindow(final String title) {
        this.waitUntil(new WaitCondition<Object>(){

            public Object run() {
                if (SwingMock.this.isWindowOpen(title)) {
                    return true;
                }
                return null;
            }
        });
        this.waitForIdle();
    }

    public int getSleepDelay() {
        return this.m_bot.getAutoDelay();
    }

    public void setSleepDelay(int sleepDelay) {
        this.m_bot.setAutoDelay(sleepDelay);
    }

    public void sleep() {
        this.sleep(this.getSleepDelay());
    }

    public void sleep(int millis) {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        this.m_bot.sleep(millis);
        this.waitForIdle();
    }

    public boolean isWindowActive(final String title) {
        return this.syncExec(new WaitCondition<Boolean>(){

            public Boolean run() throws Throwable {
                for (Window w : SwingMock.this.findWindows(title)) {
                    if (!w.isActive()) continue;
                    return true;
                }
                JInternalFrame f = SwingMock.this.findInternalFrame(title);
                if (f != null) {
                    return f.isSelected();
                }
                return false;
            }
        });
    }

    public boolean isWindowOpen(final String title) {
        return this.syncExec(new WaitCondition<Boolean>(){

            public Boolean run() throws Throwable {
                for (Window w : SwingMock.this.findWindows(title)) {
                    if (!w.isVisible()) continue;
                    return true;
                }
                JInternalFrame f = SwingMock.this.findInternalFrame(title);
                if (f != null) {
                    return f.isVisible();
                }
                return false;
            }
        });
    }

    public void activateWindow(final String title) {
        this.waitForOpenWindow(title);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                Window w = SwingMock.this.findWindow(title);
                if (w != null) {
                    w.requestFocusInWindow();
                    return null;
                }
                JInternalFrame f = SwingMock.this.findInternalFrame(title);
                if (f != null) {
                    f.requestFocusInWindow();
                    f.setSelected(true);
                    return null;
                }
                throw new IllegalStateException("There is no view with title " + title);
            }
        });
        this.waitForIdle();
    }

    public void clickOnPushButton(String text) {
        final JComponent c = this.waitForPushButtonWithLabel(text);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                Point p = c.getLocationOnScreen();
                SwingMock.this.gotoPoint(p.x + c.getWidth() / 2, p.y + c.getHeight() / 2);
                SwingMock.this.clickLeft();
                return null;
            }
        });
        this.waitForIdle();
    }

    public void gotoField(IGuiMock.FieldType type, int fieldIndex) {
        final JComponent c = this.waitForIndexedField(type, fieldIndex);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                Point p = c.getLocationOnScreen();
                SwingMock.this.gotoPoint(p.x + c.getWidth() / 2, p.y + c.getHeight() / 2);
                return null;
            }
        });
    }

    public void gotoScoutField(String name) {
        this.gotoScoutField(name, 0.5, 0.5);
    }

    public void gotoScoutField(String name, final double x, final double y) {
        if (x < 0.0 || x > 1.0) {
            throw new IllegalArgumentException("x should be in [0, 1] range.");
        }
        if (y < 0.0 || y > 1.0) {
            throw new IllegalArgumentException("y should be in [0, 1] range.");
        }
        final JComponent c = this.waitForScoutField(name);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                Point p = c.getLocationOnScreen();
                SwingMock.this.gotoPoint(p.x + (int)(x * (double)c.getWidth()), p.y + (int)(y * (double)c.getHeight()));
                return null;
            }
        });
    }

    public void gotoTable(int tableIndex, final int rowIndex, final int columnIndex) {
        final JTable table = (JTable)this.waitForIndexedField(IGuiMock.FieldType.Table, tableIndex);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                Rectangle r = SwingMock.this.getTableCellBounds(table, rowIndex, columnIndex);
                if (!table.getVisibleRect().contains(r.x + r.width / 2, r.y + r.height / 2)) {
                    throw new IllegalStateException("table cell " + rowIndex + "," + columnIndex + " is not visible on screen");
                }
                Point p = table.getLocationOnScreen();
                SwingMock.this.gotoPoint(p.x + r.x + r.width / 2, p.y + r.y + r.height / 2);
                return null;
            }
        });
    }

    public void gotoTableHeader(int tableIndex, final int columnIndex) {
        final JTable table = (JTable)this.waitForIndexedField(IGuiMock.FieldType.Table, tableIndex);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                Rectangle r = SwingMock.this.getTableHeaderCellBounds(table, columnIndex);
                Point p = table.getTableHeader().getLocationOnScreen();
                SwingMock.this.gotoPoint(p.x + r.x + r.width / 2, p.y + r.y + r.height / 2);
                return null;
            }
        });
    }

    public void gotoTree(int treeIndex, final String nodeText) {
        final JTree tree = (JTree)this.waitForIndexedField(IGuiMock.FieldType.Tree, treeIndex);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                Rectangle r = SwingMock.this.getTreeRowBounds(tree, SwingMock.this.getTreeRowIndex(tree, nodeText));
                if (!tree.getVisibleRect().contains(r.x + r.width / 2, r.y + r.height / 2)) {
                    throw new IllegalStateException("tree node " + nodeText + " is not visible on screen");
                }
                Point p = tree.getLocationOnScreen();
                SwingMock.this.gotoPoint(p.x + r.x + r.width / 2, p.y + r.y + r.height / 2);
                return null;
            }
        });
    }

    public void gotoTreeExpandIcon(int treeIndex, final String nodeText) {
        final JTree tree = (JTree)this.waitForIndexedField(IGuiMock.FieldType.Tree, treeIndex);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                Rectangle r = SwingMock.this.getTreeRowBounds(tree, SwingMock.this.getTreeRowIndex(tree, nodeText));
                if (!tree.getVisibleRect().contains(r.x + r.width / 2, r.y + r.height / 2)) {
                    throw new IllegalStateException("tree node " + nodeText + " is not visible on screen");
                }
                Point p = tree.getLocationOnScreen();
                SwingMock.this.gotoPoint(p.x + r.x - SwingMock.this.getTreeNodeToExpandIconGap() - 2, p.y + r.y + r.height / 2);
                return null;
            }
        });
    }

    public void contextMenu(String ... names) {
        int i = 0;
        while (i < names.length) {
            String label = names[i];
            final boolean lastItem = i == names.length - 1;
            final Component m = this.waitForContextMenu(label);
            this.syncExec(new WaitCondition<Boolean>(){

                public Boolean run() throws Throwable {
                    Point p = m.getLocationOnScreen();
                    SwingMock.this.gotoPoint(p.x + m.getWidth() / 2, p.y + m.getHeight() / 2);
                    if (lastItem) {
                        SwingMock.this.clickLeft();
                    }
                    return null;
                }
            });
            this.waitForIdle();
            ++i;
        }
    }

    public List<String> getTableCells(int tableIndex, final int columnIndex) {
        final JTable table = (JTable)this.waitForIndexedField(IGuiMock.FieldType.Table, tableIndex);
        return this.syncExec(new WaitCondition<List<String>>(){

            public List<String> run() throws Throwable {
                ArrayList<String> list = new ArrayList<String>();
                int row = 0;
                while (row < table.getRowCount()) {
                    list.add(SwingMock.this.getTableCellText(table, row, columnIndex));
                    ++row;
                }
                return list;
            }
        });
    }

    public List<String> getTreeNodes(int treeIndex) {
        final JTree tree = (JTree)this.waitForIndexedField(IGuiMock.FieldType.Tree, treeIndex);
        return this.syncExec(new WaitCondition<List<String>>(){

            public List<String> run() throws Throwable {
                ArrayList<String> list = new ArrayList<String>();
                int row = 0;
                while (row < tree.getRowCount()) {
                    list.add(SwingMock.this.getTreeRowText(tree, row));
                    ++row;
                }
                return list;
            }
        });
    }

    public Set<String> getSelectedTableCells(int tableIndex, final int columnIndex) {
        final JTable table = (JTable)this.waitForIndexedField(IGuiMock.FieldType.Table, tableIndex);
        return this.syncExec(new WaitCondition<Set<String>>(){

            public Set<String> run() throws Throwable {
                TreeSet<String> set = new TreeSet<String>();
                int[] sel = table.getSelectedRows();
                if (sel != null) {
                    int[] nArray = sel;
                    int n = sel.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int row = nArray[n2];
                        set.add(SwingMock.this.getTableCellText(table, row, columnIndex));
                        ++n2;
                    }
                }
                return set;
            }
        });
    }

    public Set<String> getCheckedTableCells(int tableIndex, final int columnIndex) {
        final JTable table = (JTable)this.waitForIndexedField(IGuiMock.FieldType.Table, tableIndex);
        return this.syncExec(new WaitCondition<Set<String>>(){

            public Set<String> run() throws Throwable {
                TreeSet<String> check = new TreeSet<String>();
                int i = 0;
                while (i < table.getRowCount()) {
                    Icon icon = SwingMock.this.getTableCellIcon(table, i);
                    if (icon instanceof CheckboxIcon && ((CheckboxIcon)icon).isSelecetd()) {
                        check.add(SwingMock.this.getTableCellText(table, i, columnIndex));
                    }
                    ++i;
                }
                return check;
            }
        });
    }

    public Set<String> getSelectedTreeNodes(int treeIndex) {
        final JTree tree = (JTree)this.waitForIndexedField(IGuiMock.FieldType.Tree, treeIndex);
        return this.syncExec(new WaitCondition<Set<String>>(){

            public Set<String> run() throws Throwable {
                TreeSet<String> set = new TreeSet<String>();
                int[] sel = tree.getSelectionRows();
                if (sel != null) {
                    int[] nArray = sel;
                    int n = sel.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int row = nArray[n2];
                        set.add(SwingMock.this.getTreeRowText(tree, row));
                        ++n2;
                    }
                }
                return set;
            }
        });
    }

    public IGuiMock.FieldState getFocusFieldState() {
        return this.syncExec(new WaitCondition<IGuiMock.FieldState>(){

            public IGuiMock.FieldState run() throws Throwable {
                SwingMock.this.checkActiveWindow();
                Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (c == null) {
                    throw new IllegalStateException("There is no focus owner");
                }
                if (!(c instanceof JComponent)) {
                    throw new IllegalStateException("Focus owner is not a swing field");
                }
                return SwingMock.this.getFieldStateInternal((JComponent)c);
            }
        });
    }

    public IGuiMock.FieldState getFieldState(IGuiMock.FieldType type, int index) {
        final JComponent c = this.waitForIndexedField(type, index);
        return this.syncExec(new WaitCondition<IGuiMock.FieldState>(){

            public IGuiMock.FieldState run() throws Throwable {
                return SwingMock.this.getFieldStateInternal(c);
            }
        });
    }

    public IGuiMock.FieldState getScoutFieldState(String name) {
        final JComponent c = this.waitForScoutField(name);
        return this.syncExec(new WaitCondition<IGuiMock.FieldState>(){

            public IGuiMock.FieldState run() throws Throwable {
                return SwingMock.this.getFieldStateInternal(c);
            }
        });
    }

    public IGuiMock.FieldState getScoutFieldContainerState(String name) {
        final JComponent c = this.waitForScoutField(name);
        return this.syncExec(new WaitCondition<IGuiMock.FieldState>(){

            public IGuiMock.FieldState run() throws Throwable {
                ISwingScoutComposite swingScoutComposite = SwingScoutComposite.getCompositeOnWidget((Component)c);
                if (swingScoutComposite == null) {
                    return null;
                }
                return SwingMock.this.getFieldStateInternal(swingScoutComposite.getSwingContainer());
            }
        });
    }

    public List<IGuiMock.FieldState> getFieldStates(final IGuiMock.FieldType type) {
        return this.syncExec(new WaitCondition<List<IGuiMock.FieldState>>(){

            public List<IGuiMock.FieldState> run() throws Throwable {
                SwingMock.this.checkActiveWindow();
                ArrayList<IGuiMock.FieldState> list = new ArrayList<IGuiMock.FieldState>();
                for (Component parent : SwingMock.this.enumerateParentContainers()) {
                    for (JComponent c : SwingUtility.findChildComponents((Component)parent, JComponent.class)) {
                        if (type == null && SwingMock.this.getFieldTypeOf(c) != null) {
                            list.add(SwingMock.this.getFieldStateInternal(c));
                            continue;
                        }
                        if (type == null || SwingMock.this.getFieldTypeOf(c) != type) continue;
                        list.add(SwingMock.this.getFieldStateInternal(c));
                    }
                }
                return list;
            }
        });
    }

    public void gotoPoint(int x, int y) {
        this.m_bot.moveTo(x, y);
    }

    public void move(int deltaX, int deltaY) {
        this.m_bot.moveDelta(deltaX, deltaY);
    }

    public void clickLeft() {
        this.m_bot.clickLeft();
        this.waitForIdle();
    }

    public void clickRight() {
        this.m_bot.clickRight();
        this.waitForIdle();
    }

    public void pressLeft() {
        this.m_bot.pressLeft();
    }

    public void releaseLeft() {
        this.m_bot.releaseLeft();
        this.waitForIdle();
    }

    public void drag(int x1, int y1, int x2, int y2) {
        this.gotoPoint(x1, y1);
        this.m_bot.pressLeft();
        this.gotoPoint(x2, y2);
        this.m_bot.releaseLeft();
        this.waitForIdle();
    }

    public void dragWindowRightBorder(IGuiMock.WindowState windowState, int pixelToMoveOnX) {
        int borderSize = 2;
        int xPos = windowState.x + windowState.width + borderSize;
        int yPos = windowState.y + windowState.height / 2;
        this.drag(xPos, yPos, xPos + pixelToMoveOnX, yPos);
    }

    public void typeText(String text) {
        this.m_bot.typeText(text);
        this.waitForIdle();
    }

    public void pressKey(IGuiMock.Key key) {
        this.m_bot.pressKey(key);
        this.waitForIdle();
    }

    public void paste(String text) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), null);
        this.m_bot.pressKey(IGuiMock.Key.Control);
        this.m_bot.typeText("v");
        this.m_bot.releaseKey(IGuiMock.Key.Control);
    }

    public void releaseKey(IGuiMock.Key key) {
        this.m_bot.releaseKey(key);
        this.waitForIdle();
    }

    public void typeKey(IGuiMock.Key key) {
        this.m_bot.typeKey(key);
        this.waitForIdle();
    }

    public IGuiMock.WindowState getWindowState(final String title) {
        return this.syncExec(new WaitCondition<IGuiMock.WindowState>(){

            public IGuiMock.WindowState run() throws Throwable {
                SwingMock.this.checkActiveWindow();
                JInternalFrame part = SwingMock.this.findInternalFrame(title);
                if (part != null) {
                    Rectangle r = part.getBounds();
                    IGuiMock.WindowState state = new IGuiMock.WindowState();
                    Point p = part.getLocationOnScreen();
                    state.x = p.x;
                    state.y = p.y;
                    state.width = r.width;
                    state.height = r.height;
                    return state;
                }
                Window w = SwingMock.this.findWindow(title);
                if (w != null) {
                    Rectangle r = w.getBounds();
                    IGuiMock.WindowState state = new IGuiMock.WindowState();
                    Point p = w.getLocationOnScreen();
                    state.x = p.x;
                    state.y = p.y;
                    state.width = r.width;
                    state.height = r.height;
                    return state;
                }
                throw new IllegalStateException("Window " + title + " not found");
            }
        });
    }

    public String getClipboardText() {
        this.waitForIdle();
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        TransferObject o = SwingUtility.createScoutTransferable((Transferable)t);
        if (o != null && o.isText()) {
            return ((TextTransferObject)o).getPlainText();
        }
        return null;
    }

    public void setClipboardText(String value) {
        this.waitForIdle();
        TextTransferable text = new TextTransferable(value, value);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)text, null);
    }

    public Object internal0(Object o) {
        return null;
    }

    protected IGuiMock.FieldState getFieldStateInternal(Container c) {
        IGuiMock.FieldState state = new IGuiMock.FieldState();
        state.type = this.getFieldTypeOf(c);
        state.scoutName = this.getScoutNameOf(c);
        state.focus = c.isFocusOwner();
        state.visible = c.isShowing();
        if (c.isShowing()) {
            Point p = c.getLocationOnScreen();
            state.x = p.x;
            state.y = p.y;
            state.width = c.getWidth();
            state.height = c.getHeight();
        }
        state.foregroundColor = ColorUtility.createStringFromColor((Color)c.getForeground());
        state.backgroundColor = ColorUtility.createStringFromColor((Color)c.getBackground());
        if (c instanceof JLabel) {
            state.text = ((JLabel)c).getText();
        }
        if (c instanceof JTextComponent) {
            state.text = ((JTextComponent)c).getText();
        }
        if (c instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)c;
            state.text = button.getText();
            state.selected = button.isSelected();
        }
        state.widget = c;
        return state;
    }

    protected int getTreeRowIndex(JTree tree, String nodeText) {
        int i = 0;
        while (i < tree.getRowCount()) {
            JLabel label;
            Component tmp = tree.getCellRenderer().getTreeCellRendererComponent(tree, tree.getPathForRow(i).getLastPathComponent(), false, false, false, i, false);
            if (tmp instanceof JLabel && nodeText.equals((label = (JLabel)tmp).getText())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected String getTreeRowText(JTree tree, int rowIndex) {
        if (rowIndex < 0 || rowIndex > tree.getRowCount()) {
            throw new IllegalStateException("Tree has " + tree.getRowCount() + " rows (accessing " + rowIndex + ")");
        }
        Component tmp = tree.getCellRenderer().getTreeCellRendererComponent(tree, tree.getPathForRow(rowIndex).getLastPathComponent(), false, false, false, rowIndex, false);
        if (tmp instanceof JLabel) {
            JLabel label = (JLabel)tmp;
            return label.getText();
        }
        return null;
    }

    protected Rectangle getTreeRowBounds(JTree tree, int rowIndex) {
        if (rowIndex < 0 || rowIndex > tree.getRowCount()) {
            throw new IllegalStateException("Tree has " + tree.getRowCount() + " rows (accessing " + rowIndex + ")");
        }
        return tree.getPathBounds(tree.getPathForRow(rowIndex));
    }

    protected String getTableCellText(JTable table, int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex > table.getRowCount()) {
            throw new IllegalStateException("Table has " + table.getRowCount() + " rows (accessing " + rowIndex + ")");
        }
        if (columnIndex < 0 || columnIndex > table.getColumnCount()) {
            throw new IllegalStateException("Table has " + table.getColumnCount() + " columns (accessing " + columnIndex + ")");
        }
        Component label = table.prepareRenderer(table.getCellRenderer(rowIndex, columnIndex), rowIndex, columnIndex);
        if (label instanceof JLabel) {
            return ((JLabel)label).getText();
        }
        return null;
    }

    protected Icon getTableCellIcon(JTable table, int rowIndex) {
        if (rowIndex < 0 || rowIndex > table.getRowCount()) {
            throw new IllegalStateException("Table has " + table.getRowCount() + " rows (accessing " + rowIndex + ")");
        }
        Component label = table.prepareRenderer(table.getCellRenderer(rowIndex, 0), rowIndex, 0);
        if (label instanceof JLabel) {
            return ((JLabel)label).getIcon();
        }
        return null;
    }

    protected Rectangle getTableCellBounds(JTable table, int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex > table.getRowCount()) {
            throw new IllegalStateException("Table has " + table.getRowCount() + " rows (accessing " + rowIndex + ")");
        }
        if (columnIndex < 0 || columnIndex > table.getColumnCount()) {
            throw new IllegalStateException("Table has " + table.getColumnCount() + " columns (accessing " + columnIndex + ")");
        }
        return table.getCellRect(rowIndex, columnIndex, true);
    }

    protected Rectangle getTableHeaderCellBounds(JTable table, int columnIndex) {
        if (columnIndex < 0 || columnIndex > table.getColumnCount()) {
            throw new IllegalStateException("Table has " + table.getColumnCount() + " columns (accessing " + columnIndex + ")");
        }
        return table.getTableHeader().getHeaderRect(columnIndex);
    }

    protected void checkActiveWindow() {
        if (this.getActiveWindow() == null) {
            throw new IllegalStateException("There is no active view");
        }
    }

    protected Window getActiveWindow() {
        Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        return w;
    }

    protected String cleanButtonLabel(String s) {
        return StringUtility.removeMnemonic((String)s);
    }

    protected Window findWindow(String title) {
        Window[] windowArray = Window.getWindows();
        int n = windowArray.length;
        int n2 = 0;
        while (n2 < n) {
            Window w = windowArray[n2];
            if (w.isVisible()) {
                if (w instanceof Dialog && title.equals(((Dialog)w).getTitle())) {
                    return w;
                }
                if (w instanceof Frame && title.equals(((Frame)w).getTitle())) {
                    return w;
                }
            }
            ++n2;
        }
        return null;
    }

    protected List<Window> findWindows(String title) {
        ArrayList<Window> list = new ArrayList<Window>();
        Window[] windowArray = Window.getWindows();
        int n = windowArray.length;
        int n2 = 0;
        while (n2 < n) {
            Window w = windowArray[n2];
            if (w.isVisible()) {
                if (w instanceof Dialog && title.equals(((Dialog)w).getTitle())) {
                    list.add(w);
                } else if (w instanceof Frame && title.equals(((Frame)w).getTitle())) {
                    list.add(w);
                }
            }
            ++n2;
        }
        return list;
    }

    protected JInternalFrame findInternalFrame(String title) {
        Window[] windowArray = JWindow.getWindows();
        int n = windowArray.length;
        int n2 = 0;
        while (n2 < n) {
            Window w = windowArray[n2];
            for (JInternalFrame i : SwingUtility.findChildComponents((Component)w, JInternalFrame.class)) {
                if (!i.isVisible() || !title.equals(i.getTitle())) continue;
                return i;
            }
            ++n2;
        }
        return null;
    }

    protected Component waitForContextMenu(final String text) {
        return this.waitUntil(new WaitCondition<Component>(){

            public Component run() {
                return SwingMock.this.syncExec(new WaitCondition<Component>(){

                    public Component run() throws Throwable {
                        Component[] a;
                        String label = SwingMock.this.cleanButtonLabel(text);
                        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                        Component popupContainer = null;
                        if (popupContainer == null && activeWindow instanceof RootPaneContainer && (a = ((RootPaneContainer)((Object)activeWindow)).getLayeredPane().getComponentsInLayer(JLayeredPane.POPUP_LAYER)).length > 0) {
                            popupContainer = a[0];
                        }
                        if (popupContainer == null) {
                            popupContainer = this.findHeavyweightPopup(activeWindow);
                        }
                        if (popupContainer != null) {
                            for (AbstractButton b : SwingUtility.findChildComponents((Component)popupContainer, AbstractButton.class)) {
                                if (!label.equals(b.getText())) continue;
                                return b;
                            }
                        }
                        return null;
                    }

                    private Component findHeavyweightPopup(Window window) {
                        Window[] windowArray = window.getOwnedWindows();
                        int n = windowArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Window ownedWindow = windowArray[n2];
                            if (ownedWindow.getClass().getName().equals("javax.swing.Popup$HeavyWeightWindow")) {
                                if (ownedWindow instanceof JWindow) {
                                    JWindow w = (JWindow)ownedWindow;
                                    if (w.isVisible()) {
                                        Component child = this.findHeavyweightPopup(w);
                                        if (child != null) {
                                            return child;
                                        }
                                        return ((RootPaneContainer)((Object)ownedWindow)).getContentPane();
                                    }
                                } else {
                                    if (ownedWindow instanceof RootPaneContainer) {
                                        return ((RootPaneContainer)((Object)ownedWindow)).getContentPane();
                                    }
                                    return ownedWindow;
                                }
                            }
                            ++n2;
                        }
                        return null;
                    }
                });
            }
        });
    }

    protected JComponent waitForPushButtonWithLabel(final String label) {
        return this.waitUntil(new WaitCondition<JComponent>(){

            public JComponent run() {
                return SwingMock.this.syncExec(new WaitCondition<JComponent>(){

                    public JComponent run() throws Throwable {
                        for (Component parent : SwingMock.this.enumerateParentContainers()) {
                            for (Component o : SwingUtility.findChildComponents((Component)parent, Component.class)) {
                                if (!(o instanceof AbstractButton) || !SwingMock.this.cleanButtonLabel(label).equals(SwingMock.this.cleanButtonLabel(((AbstractButton)o).getText()))) continue;
                                return (AbstractButton)o;
                            }
                        }
                        return null;
                    }
                });
            }
        });
    }

    protected JComponent waitForIndexedField(final IGuiMock.FieldType type, final int fieldIndex) {
        return this.waitUntil(new WaitCondition<JComponent>(){

            public JComponent run() {
                return SwingMock.this.syncExec(new WaitCondition<JComponent>(){

                    public JComponent run() throws Throwable {
                        for (Component parent : SwingMock.this.enumerateParentContainers()) {
                            int index = 0;
                            for (JComponent c : SwingUtility.findChildComponents((Component)parent, JComponent.class)) {
                                if (SwingMock.this.getFieldTypeOf(c) != type) continue;
                                if (index == fieldIndex) {
                                    return c;
                                }
                                ++index;
                            }
                        }
                        return null;
                    }
                });
            }
        });
    }

    protected JComponent waitForScoutField(final String name) {
        return this.waitUntil(new WaitCondition<JComponent>(){

            public JComponent run() {
                return SwingMock.this.syncExec(new WaitCondition<JComponent>(){

                    public JComponent run() throws Throwable {
                        JComponent lastSecondaryCandidate = null;
                        for (Component parent : SwingMock.this.enumerateParentContainers()) {
                            for (JComponent c : SwingUtility.findChildComponents((Component)parent, JComponent.class)) {
                                String s = SwingMock.this.getScoutNameOf(c);
                                if (s == null || !("." + s).endsWith("." + name)) continue;
                                lastSecondaryCandidate = c;
                                if (SwingMock.this.getFieldTypeOf(c) == null) continue;
                                return c;
                            }
                        }
                        return lastSecondaryCandidate;
                    }
                });
            }
        });
    }

    protected List<Component> enumerateParentContainers() {
        Window w;
        Component[] a;
        ArrayList<Component> parents = new ArrayList<Component>();
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (activeWindow instanceof RootPaneContainer && (a = ((RootPaneContainer)((Object)activeWindow)).getLayeredPane().getComponentsInLayer(JLayeredPane.POPUP_LAYER)).length > 0) {
            parents.add(a[0]);
        }
        Window[] windowArray = activeWindow.getOwnedWindows();
        int n = windowArray.length;
        int n2 = 0;
        while (n2 < n) {
            w = windowArray[n2];
            if (w.getClass().getName().equals("javax.swing.Popup$HeavyWeightWindow")) {
                if (!w.isShowing()) break;
                if (w instanceof RootPaneContainer) {
                    parents.add(((RootPaneContainer)((Object)w)).getContentPane());
                    break;
                }
                parents.add(w);
                break;
            }
            ++n2;
        }
        windowArray = JWindow.getWindows();
        n = windowArray.length;
        n2 = 0;
        while (n2 < n) {
            w = windowArray[n2];
            if (w.isShowing()) {
                if (w instanceof RootPaneContainer) {
                    parents.add(((RootPaneContainer)((Object)w)).getContentPane());
                } else {
                    parents.add(w);
                }
            }
            ++n2;
        }
        return parents;
    }

    protected IGuiMock.FieldType getFieldTypeOf(Container c) {
        if (c == null) {
            return null;
        }
        if (!c.isShowing()) {
            return null;
        }
        if (c instanceof JComponent && ((JComponent)c).getVisibleRect().isEmpty()) {
            return null;
        }
        if (c instanceof JLabel) {
            return IGuiMock.FieldType.Label;
        }
        if (c instanceof JTextComponent) {
            return IGuiMock.FieldType.Text;
        }
        if (c instanceof JCheckBox) {
            return IGuiMock.FieldType.Checkbox;
        }
        if (c instanceof JRadioButton) {
            return IGuiMock.FieldType.RadioButton;
        }
        if (c instanceof JTable) {
            return IGuiMock.FieldType.Table;
        }
        if (c instanceof JTree) {
            return IGuiMock.FieldType.Tree;
        }
        if (c instanceof AbstractButton) {
            if (SwingUtilities.getAncestorOfClass(JScrollBar.class, c) != null) {
                return IGuiMock.FieldType.ScrollButton;
            }
            return IGuiMock.FieldType.PushButton;
        }
        return null;
    }

    protected String getScoutNameOf(Container c) {
        IPropertyObserver scoutObject = SwingScoutComposite.getScoutModelOnWidget((Component)c);
        if (scoutObject != null) {
            return scoutObject.getClass().getName();
        }
        return null;
    }

    protected int toKeyCode(IGuiMock.Key key) {
        switch (key) {
            case Shift: {
                return 16;
            }
            case Control: {
                return 17;
            }
            case Alt: {
                return 18;
            }
            case Delete: {
                return 127;
            }
            case Backspace: {
                return 8;
            }
            case Enter: {
                return 10;
            }
            case Esc: {
                return 27;
            }
            case Tab: {
                return 9;
            }
            case ContextMenu: {
                return 525;
            }
            case Up: {
                return 38;
            }
            case Down: {
                return 40;
            }
            case Left: {
                return 37;
            }
            case Right: {
                return 39;
            }
        }
        throw new IllegalArgumentException("Unknown keyboard key: " + key);
    }

    protected <T> T syncExec(final WaitCondition<T> r) {
        final AtomicReference ret = new AtomicReference();
        if (!SwingUtilities.isEventDispatchThread()) {
            final AtomicReference ex = new AtomicReference();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ret.set(SwingMock.this.syncExec(r));
                        }
                        catch (Throwable t) {
                            ex.set(t);
                        }
                    }
                });
                if (ex.get() != null) {
                    throw (Throwable)ex.get();
                }
                return (T)ret.get();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        try {
            return (T)r.run();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected <T> T waitUntil(WaitCondition<T> w) {
        try {
            Object object = TestingUtility.waitUntil((long)10000L, w);
            return (T)object;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            this.waitForIdle();
        }
    }

    public void clickLeftOnSmartFieldMagnifier(IGuiMock.FieldState fieldState) {
        this.gotoPoint(fieldState.x + fieldState.width - 10, fieldState.y + 10);
        this.clickLeft();
    }

    public void clickRightOnSmartFieldMagnifier(IGuiMock.FieldState fieldState) {
        this.gotoPoint(fieldState.x + fieldState.width - 10, fieldState.y + 10);
        this.clickRight();
    }
}

