/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.ui.swt;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.testing.shared.ScoutJUnitPluginTestExecutor;
import org.eclipse.scout.rt.testing.shared.TestingUtility;
import org.eclipse.scout.rt.testing.shared.WaitCondition;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.ui.PlatformUI;

public class JUnitSWTJob
extends Job {
    private final ISwtEnvironment m_environment;
    private final long m_waitTimeout;

    public JUnitSWTJob(ISwtEnvironment environment, long waitTimeout) {
        super("JUnit SWT Runner");
        this.setSystem(true);
        this.m_environment = environment;
        this.m_waitTimeout = waitTimeout;
    }

    public JUnitSWTJob(ISwtEnvironment environment) {
        this(environment, 10000L);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            TestingUtility.waitUntil((long)10000L, (WaitCondition)new WaitCondition<Object>(){

                public Object run() {
                    try {
                        if (PlatformUI.isWorkbenchRunning()) {
                            IDesktop desktop;
                            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    JUnitSWTJob.this.m_environment.ensureInitialized();
                                }
                            });
                            IClientSession session = JUnitSWTJob.this.m_environment.getClientSession();
                            if (session != null && (desktop = session.getDesktop()) != null && desktop.isGuiAvailable() && desktop.isOpened()) {
                                return true;
                            }
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        System.exit(0);
                    }
                    return null;
                }
            });
        }
        catch (Throwable t) {
            System.err.println("Timeout waiting for SWTApplication to start: " + t);
            System.exit(0);
        }
        ScoutJUnitPluginTestExecutor scoutJUnitPluginTestExecutor = new ScoutJUnitPluginTestExecutor();
        int code = scoutJUnitPluginTestExecutor.runAllTests();
        System.exit(code);
        return Status.OK_STATUS;
    }
}

