/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingUtility;

public class SwingPopupWorker
implements Runnable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingPopupWorker.class);
    private final ISwingEnvironment m_env;
    private final Point m_point;
    private final List<? extends IMenu> m_scoutMenus;
    private boolean m_isLightWeightPopup;
    private final EventListenerList m_listeners;
    private Component m_target;
    private final JTextComponent m_systemMenuOwner;

    public SwingPopupWorker(ISwingEnvironment env, Component target, Point point, List<? extends IMenu> scoutMenus) {
        this(env, target, null, point, scoutMenus);
    }

    public SwingPopupWorker(ISwingEnvironment env, Component target, JTextComponent systemMenuOwner, Point point, List<? extends IMenu> scoutMenus) {
        this(env, target, systemMenuOwner, point, scoutMenus, true);
    }

    public SwingPopupWorker(ISwingEnvironment env, Component target, JTextComponent systemMenuOwner, Point point, List<? extends IMenu> scoutMenus, boolean isLightWeightPopup) {
        this.m_env = env;
        this.m_target = target;
        this.m_systemMenuOwner = systemMenuOwner;
        this.m_point = point;
        this.m_scoutMenus = scoutMenus;
        this.m_isLightWeightPopup = isLightWeightPopup;
        this.m_listeners = new EventListenerList();
    }

    public void addListener(PopupMenuListener l) {
        this.m_listeners.add(PopupMenuListener.class, (EventListener)l);
    }

    public void removeListener(PopupMenuListener l) {
        this.m_listeners.add(PopupMenuListener.class, (EventListener)l);
    }

    @Override
    public void run() {
        if (!CollectionUtility.hasElements(this.m_scoutMenus) && this.m_systemMenuOwner == null) {
            return;
        }
        JPopupMenu pop = new JPopupMenu();
        PopupMenuListener[] popupMenuListenerArray = (PopupMenuListener[])this.m_listeners.getListeners(PopupMenuListener.class);
        int n = popupMenuListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PopupMenuListener l = popupMenuListenerArray[n2];
            pop.addPopupMenuListener(l);
            ++n2;
        }
        pop.setLightWeightPopupEnabled(this.m_isLightWeightPopup);
        for (JMenuItem item : this.getSystemMenus()) {
            pop.add(item);
        }
        if (pop.getComponentCount() > 0 && CollectionUtility.hasElements(this.m_scoutMenus)) {
            pop.addSeparator();
        }
        this.m_env.appendActions(pop, this.m_scoutMenus);
        try {
            if (pop.getComponentCount() > 0) {
                Point whereOnTarget = this.m_point;
                if (!this.m_target.isVisible()) {
                    Component visibleAncestor = this.m_target;
                    while (visibleAncestor != null && !visibleAncestor.isVisible()) {
                        visibleAncestor = visibleAncestor.getParent();
                    }
                    whereOnTarget = SwingUtilities.convertPoint(this.m_target, whereOnTarget, visibleAncestor);
                    this.m_target = visibleAncestor;
                }
                Point compLocationOnScreen = this.m_target.getLocationOnScreen();
                Point p = new Point(whereOnTarget);
                p.translate(compLocationOnScreen.x, compLocationOnScreen.y);
                Rectangle r = new Rectangle(p, pop.getPreferredSize());
                Rectangle ownerBounds = new Rectangle(this.m_target.getLocationOnScreen().x, this.m_target.getLocationOnScreen().y, this.m_target.getWidth(), this.m_target.getHeight());
                if (this.m_target.getParent() instanceof JViewport && this.m_target.getParent().getParent() instanceof JScrollPane) {
                    Container scrollpane = this.m_target.getParent().getParent();
                    ownerBounds = new Rectangle(scrollpane.getLocationOnScreen().x, scrollpane.getLocationOnScreen().y, scrollpane.getWidth(), scrollpane.getHeight());
                }
                Rectangle ownerScreen = SwingUtility.getFullScreenBoundsFor(ownerBounds, true);
                r = SwingUtility.validateRectangleOnScreen(r, ownerScreen, true, true);
                if (r.y < ownerBounds.y && r.height > ownerBounds.height) {
                    Rectangle tmp = new Rectangle(r);
                    tmp.y = ownerBounds.y + ownerBounds.height + 2;
                    Rectangle result = SwingUtility.validateRectangleOnScreen(tmp, ownerScreen, true, true);
                    if (result.equals(tmp)) {
                        r = tmp;
                    } else {
                        tmp = new Rectangle(r);
                        tmp.y = ownerBounds.y - pop.getPreferredSize().height - 2;
                        result = SwingUtility.validateRectangleOnScreen(tmp, ownerScreen, true, true);
                        if (result.equals(tmp)) {
                            r = tmp;
                        }
                    }
                }
                p = r.getLocation();
                p.translate(-compLocationOnScreen.x, -compLocationOnScreen.y);
                pop.show(this.m_target, p.x, p.y);
            }
        }
        catch (Exception e) {
            LOG.error(null, (Throwable)e);
        }
    }

    private List<JMenuItem> getSystemMenus() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        if (this.m_systemMenuOwner != null) {
            if (this.m_systemMenuOwner.isEditable()) {
                JMenuItem cutItem = new JMenuItem(SwingUtility.getNlsText("Cut", new String[0]));
                cutItem.setEnabled(StringUtility.hasText((String)this.m_systemMenuOwner.getSelectedText()));
                cutItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        SwingPopupWorker.this.m_systemMenuOwner.cut();
                    }
                });
                items.add(cutItem);
            }
            JMenuItem copyItem = new JMenuItem(SwingUtility.getNlsText("Copy", new String[0]));
            if (this.m_systemMenuOwner.isEnabled() && this.m_systemMenuOwner.isEditable()) {
                copyItem.setEnabled(StringUtility.hasText((String)this.m_systemMenuOwner.getSelectedText()));
            }
            copyItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (SwingPopupWorker.this.m_systemMenuOwner.isEnabled() && SwingPopupWorker.this.m_systemMenuOwner.isEditable()) {
                        SwingPopupWorker.this.m_systemMenuOwner.copy();
                    } else {
                        boolean hasSelection = StringUtility.hasText((String)SwingPopupWorker.this.m_systemMenuOwner.getSelectedText());
                        if (hasSelection) {
                            SwingPopupWorker.this.m_systemMenuOwner.copy();
                        } else {
                            SwingPopupWorker.this.m_systemMenuOwner.selectAll();
                            SwingPopupWorker.this.m_systemMenuOwner.copy();
                            SwingPopupWorker.this.m_systemMenuOwner.select(0, 0);
                        }
                    }
                }
            });
            items.add(copyItem);
            if (this.m_systemMenuOwner.isEditable()) {
                JMenuItem pasteItem = new JMenuItem(SwingUtility.getNlsText("Paste", new String[0]));
                pasteItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        SwingPopupWorker.this.m_systemMenuOwner.paste();
                    }
                });
                items.add(pasteItem);
            }
        }
        return items;
    }

    public void enqueue() {
        this.m_env.invokeSwingLater(this);
    }
}

