/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing;

import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.text.JTextComponent;

public final class TextBlockDragAndDrop {
    private static final boolean DND_ENABLED = false;

    public static void attach(JTextComponent c) {
    }

    private TextBlockDragAndDrop() {
    }

    private static class P_DragSource
    implements DragGestureListener,
    DragSourceListener {
        public P_DragSource(JTextComponent c) {
            DragSource dragSource = DragSource.getDefaultDragSource();
            dragSource.createDefaultDragGestureRecognizer(c, 3, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            JTextComponent textComp = (JTextComponent)e.getComponent();
            if (!textComp.isEnabled()) {
                String selText = null;
                int selStart = textComp.getSelectionStart();
                int selEnd = textComp.getSelectionStart();
                int pos = textComp.viewToModel(e.getDragOrigin());
                if (selEnd - selStart > 0) {
                    if (pos >= selStart && pos <= selEnd) {
                        selText = textComp.getSelectedText();
                    }
                } else {
                    selText = textComp.getText();
                }
                if (selText != null && selText.length() > 0) {
                    e.startDrag(DragSource.DefaultCopyDrop, new StringSelection(selText), this);
                }
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent e) {
        }

        @Override
        public void dragExit(DragSourceEvent e) {
        }

        @Override
        public void dragOver(DragSourceDragEvent e) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent e) {
        }
    }
}

