/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.action;

import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.menu.IContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingPopupWorker;
import org.eclipse.scout.rt.ui.swing.action.menu.text.CopyMenu;
import org.eclipse.scout.rt.ui.swing.action.menu.text.CutMenu;
import org.eclipse.scout.rt.ui.swing.action.menu.text.PasteMenu;

public class SwingScoutMenuSupport
extends MouseAdapter
implements FocusListener,
KeyListener {
    private final JComponent m_comp;
    private final IContextMenu m_contextMenu;
    private final ISwingEnvironment m_env;
    private final IFormField m_scoutObject;
    private final EventListenerList m_listeners;

    protected SwingScoutMenuSupport(JComponent comp, IContextMenu contextMenu, IFormField scoutObject, ISwingEnvironment env) {
        this.m_comp = comp;
        this.m_contextMenu = contextMenu;
        this.m_env = env;
        this.m_scoutObject = scoutObject;
        this.m_listeners = new EventListenerList();
    }

    public void addListener(PopupMenuListener l) {
        this.m_listeners.add(PopupMenuListener.class, (EventListener)l);
    }

    public void removeListener(PopupMenuListener l) {
        this.m_listeners.add(PopupMenuListener.class, (EventListener)l);
    }

    public static SwingScoutMenuSupport install(JTextComponent comp, IFormField scoutObject, IContextMenu contextMenu, ISwingEnvironment env, boolean includeSystemMenus) {
        ArrayList<IMenu> menus = new ArrayList<IMenu>();
        if (includeSystemMenus) {
            menus.add((IMenu)new CutMenu(comp));
            menus.add((IMenu)new CopyMenu(comp));
            menus.add((IMenu)new PasteMenu(comp));
        }
        return SwingScoutMenuSupport.install((JComponent)comp, scoutObject, contextMenu, env, menus);
    }

    public static SwingScoutMenuSupport install(JComponent comp, IFormField scoutObject, IContextMenu contextMenu, ISwingEnvironment env) {
        return SwingScoutMenuSupport.install(comp, scoutObject, contextMenu, env, new ArrayList<IMenu>());
    }

    private static SwingScoutMenuSupport install(JComponent comp, IFormField scoutObject, final IContextMenu contextMenu, ISwingEnvironment env, List<IMenu> menus) {
        List allMenus;
        final AtomicReference<Object> ref = new AtomicReference<Object>(null);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ref.set(contextMenu.getChildActions());
            }
        };
        JobEx job = env.invokeScoutLater(t, 1000L);
        try {
            job.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        List list = ref.get();
        if (list != null && (allMenus = MenuUtility.consolidateMenus((List)list)).size() > 0) {
            SwingScoutMenuSupport support = new SwingScoutMenuSupport(comp, contextMenu, scoutObject, env);
            comp.addMouseListener(support);
            comp.addFocusListener(support);
            comp.addKeyListener(support);
            return support;
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() && this.isLocationOnText(e.getPoint())) {
            this.onSwingPopup(e.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() && this.isLocationOnText(e.getPoint())) {
            this.onSwingPopup(e.getPoint());
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.m_comp.setComponentPopupMenu(null);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.m_comp.setComponentPopupMenu(null);
    }

    private boolean isLocationOnText(Point p) {
        if (this.m_comp instanceof JTextComponent) {
            JTextComponent jtc = (JTextComponent)this.m_comp;
            Insets insets = jtc.getMargin();
            if (insets == null) {
                return true;
            }
            return p.x >= insets.left && p.y >= insets.top && p.x <= jtc.getWidth() - insets.right && p.y <= jtc.getHeight() - insets.bottom;
        }
        return true;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (525 == e.getKeyCode()) {
            Point location = this.m_comp.getLocation();
            this.onSwingPopup(location);
        }
    }

    private void onSwingPopup(Point point) {
        long timeout = 1200L;
        final AtomicReference scoutMenusRef = new AtomicReference();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                scoutMenusRef.set(ActionUtility.visibleNormalizedActions((List)SwingScoutMenuSupport.this.m_contextMenu.getChildActions()));
            }
        };
        JobEx job = this.m_env.invokeScoutLater(t, 1200L);
        try {
            job.join(1200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        List list = (List)scoutMenusRef.get();
        if (list != null) {
            SwingPopupWorker worker = new SwingPopupWorker(this.m_env, this.m_comp, point, list);
            PopupMenuListener[] popupMenuListenerArray = (PopupMenuListener[])this.m_listeners.getListeners(PopupMenuListener.class);
            int n = popupMenuListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                PopupMenuListener l = popupMenuListenerArray[n2];
                worker.addListener(l);
                ++n2;
            }
            worker.run();
        }
    }
}

